/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.AttCertIssuer;
import cn.com.infosec.asn1.x509.GeneralName;
import cn.com.infosec.asn1.x509.GeneralNames;
import cn.com.infosec.asn1.x509.V2Form;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateIssuer
implements CertSelector {
    ASN1Encodable form;

    AttributeCertificateIssuer(AttCertIssuer attCertIssuer) {
        this.form = attCertIssuer.getIssuer();
    }

    public AttributeCertificateIssuer(X500Principal x500Principal) throws IOException {
        this(new X509Principal(x500Principal.getEncoded()));
    }

    public AttributeCertificateIssuer(X509Principal x509Principal) {
        this.form = new V2Form(new GeneralNames(new DERSequence(new GeneralName(x509Principal))));
    }

    private Object[] getNames() {
        GeneralNames generalNames = this.form instanceof V2Form ? ((V2Form)this.form).getIssuerName() : (GeneralNames)this.form;
        GeneralName[] generalNameArray = generalNames.getNames();
        ArrayList<X500Principal> arrayList = new ArrayList<X500Principal>(generalNameArray.length);
        int n = 0;
        while (n != generalNameArray.length) {
            if (generalNameArray[n].getName() instanceof X509Name) {
                try {
                    arrayList.add(new X500Principal(((X509Name)generalNameArray[n].getName()).getEncoded()));
                }
                catch (IOException iOException) {
                    throw new RuntimeException("badly formed Name object");
                }
            }
            ++n;
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public Principal[] getPrincipals() {
        Object[] objectArray = this.getNames();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n != objectArray.length) {
            if (objectArray[n] instanceof Principal) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Principal[arrayList.size()]);
    }

    private boolean matchesDN(X500Principal x500Principal, GeneralNames generalNames) {
        GeneralName[] generalNameArray = generalNames.getNames();
        int n = 0;
        while (n != generalNameArray.length) {
            GeneralName generalName = generalNameArray[n];
            if (generalName.getTagNo() == 4) {
                try {
                    if (new X500Principal(((ASN1Encodable)generalName.getName()).getEncoded()).equals(x500Principal)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return false;
    }

    public Object clone() {
        return new AttributeCertificateIssuer(AttCertIssuer.getInstance(this.form));
    }

    public boolean match(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (this.form instanceof V2Form) {
            V2Form v2Form = (V2Form)this.form;
            if (v2Form.getBaseCertificateID() != null) {
                return v2Form.getBaseCertificateID().getSerial().getValue().equals(x509Certificate.getSerialNumber()) && this.matchesDN(x509Certificate.getIssuerX500Principal(), v2Form.getBaseCertificateID().getIssuer());
            }
            GeneralNames generalNames = v2Form.getIssuerName();
            if (this.matchesDN(x509Certificate.getSubjectX500Principal(), generalNames)) {
                return true;
            }
        } else {
            GeneralNames generalNames = (GeneralNames)this.form;
            if (this.matchesDN(x509Certificate.getSubjectX500Principal(), generalNames)) {
                return true;
            }
        }
        return false;
    }
}

