/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.x509.Attribute;

public class X509Attribute
extends ASN1Encodable {
    Attribute attr;

    X509Attribute(ASN1Encodable aSN1Encodable) {
        this.attr = Attribute.getInstance(aSN1Encodable);
    }

    public X509Attribute(String string, ASN1Encodable aSN1Encodable) {
        this.attr = new Attribute(new DERObjectIdentifier(string), new DERSet(aSN1Encodable));
    }

    public X509Attribute(String string, ASN1EncodableVector aSN1EncodableVector) {
        this.attr = new Attribute(new DERObjectIdentifier(string), new DERSet(aSN1EncodableVector));
    }

    public String getOID() {
        return this.attr.getAttrType().getId();
    }

    public ASN1Encodable[] getValues() {
        ASN1Set aSN1Set = this.attr.getAttrValues();
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[aSN1Set.size()];
        int n = 0;
        while (n != aSN1Set.size()) {
            aSN1EncodableArray[n] = (ASN1Encodable)aSN1Set.getObjectAt(n);
            ++n;
        }
        return aSN1EncodableArray;
    }

    public DERObject toASN1Object() {
        return this.attr.toASN1Object();
    }
}

