/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.common;

import com.alibaba.fastjson.JSON;
import com.cib.fintech.dfp.open.sdk.config.Configure;
import com.cib.fintech.dfp.open.sdk.config.GrayConfigure;
import com.cib.fintech.dfp.open.sdk.config.KeyConfigure;
import com.cib.fintech.dfp.open.sdk.enums.ReqMethodEnum;
import com.cib.fintech.dfp.open.sdk.exception.SdkExType;
import com.cib.fintech.dfp.open.sdk.exception.SdkException;
import com.cib.fintech.dfp.open.sdk.service.AbstractTransService;
import com.cib.fintech.dfp.open.sdk.util.Base64;
import com.cib.fintech.dfp.open.sdk.util.ChannelUtil;
import com.cib.fintech.dfp.open.sdk.util.MacUtil;
import com.cib.fintech.dfp.open.sdk.util.SdkUtil;
import com.cib.fintech.dfp.open.sdk.util.VerifyRespSignature;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpsPostRequest
extends AbstractTransService {
    private static final int BUFFER_SIZE = 2048;
    private static final String HEADER_TIMESTAMP = "Timestamp";
    private static final String HEADER_SIGNATURE = "Signature";
    private static final String HEADER_NONCE = "Nonce";
    private static final String HTTPS = "https";
    private static final String BOUNDARY = "---------------------------543279124964751";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static HostnameVerifier hv = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static SSLContext sc;
    private static SSLSocketFactory sf;
    private static Map<String, SSLSocketFactory> SFS;
    private static Object LOCK;
    private static boolean SSL_INIT_STATUS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSSLContents() {
        if (!SSL_INIT_STATUS) {
            Object object = LOCK;
            synchronized (object) {
                if (!SSL_INIT_STATUS) {
                    Map<String, KeyConfigure> keyConfigures = Configure.getKeyConfigures();
                    for (Map.Entry<String, KeyConfigure> entry : keyConfigures.entrySet()) {
                        String keyId = entry.getKey();
                        FileInputStream fis = null;
                        try {
                            SSLContext sslContext = SSLContext.getInstance("SSL");
                            KeyStore keyStore = KeyStore.getInstance("PKCS12");
                            fis = new FileInputStream(new File(Configure.getCertPath(), keyId + ".p12"));
                            char[] password = entry.getValue().getCertProtectionPwd() == null ? null : entry.getValue().getCertProtectionPwd().toCharArray();
                            keyStore.load(fis, password);
                            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                            kmf.init(keyStore, password);
                            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
                            SFS.put(keyId, sslContext.getSocketFactory());
                        }
                        catch (Exception exception) {}
                        continue;
                        finally {
                            if (fis == null) continue;
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    SSL_INIT_STATUS = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object send(String url, ReqMethodEnum method, String authInfo, Map<String, String> headParams, String bodyParamString, String filePath, Map<String, String> bodyParamMap, KeyConfigure keyConfigure, String bodyJson) throws Exception {
        GrayConfigure grayConfigure;
        URL connUrl = null;
        HttpURLConnection conn = null;
        Object retn = null;
        connUrl = new URL(url);
        conn = (HttpURLConnection)connUrl.openConnection();
        if (Configure.isDevEnv() && HTTPS.equals(connUrl.getProtocol())) {
            HttpsPostRequest.ignoreSSLVerify((HttpsURLConnection)conn);
        }
        if (Configure.getCertPath() != null) {
            this.initSSLContents();
            SSLSocketFactory sslSocketFactory = SFS.get(keyConfigure.getKeyId());
            if (sslSocketFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            }
        }
        if (keyConfigure.getEnterpriseBearer() != null) {
            authInfo = authInfo + "," + keyConfigure.getEnterpriseBearer();
        }
        conn.setRequestProperty("Authorization", authInfo);
        if (keyConfigure.getXCfcaBasic() != null) {
            conn.setRequestProperty("X-Cfca-Basic", keyConfigure.getXCfcaBasic());
        }
        if (headParams != null) {
            for (String key : headParams.keySet()) {
                conn.setRequestProperty(key, headParams.get(key));
            }
        }
        if (null != (grayConfigure = keyConfigure.getGrayConfigure()) && grayConfigure.notNull()) {
            conn.setRequestProperty(grayConfigure.getKey(), grayConfigure.getValue());
        }
        String timestamp = "";
        String responseSignValue = "";
        String responseNonce = "";
        if (null == filePath) {
            OutputStream outStream = null;
            InputStream inStream = null;
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            if (SdkUtil.isJSONString(bodyJson)) {
                bodyParamString = bodyJson;
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            }
            try {
                switch (method) {
                    case POST: {
                        conn.setRequestMethod(ReqMethodEnum.POST.toString());
                        conn.setDoOutput(true);
                        outStream = conn.getOutputStream();
                        outStream.write(bodyParamString.getBytes("UTF-8"));
                        outStream.flush();
                        break;
                    }
                    case PUT: {
                        conn.setRequestMethod(ReqMethodEnum.PUT.toString());
                        conn.setDoOutput(true);
                        outStream = conn.getOutputStream();
                        outStream.write(bodyParamString.getBytes("UTF-8"));
                        outStream.flush();
                        break;
                    }
                    case DELETE: {
                        conn.setRequestMethod(ReqMethodEnum.DELETE.toString());
                        conn.setDoOutput(true);
                        outStream = conn.getOutputStream();
                        outStream.write(bodyParamString.getBytes("UTF-8"));
                        outStream.flush();
                        break;
                    }
                }
                int code = conn.getResponseCode();
                inStream = code >= 200 && code < 300 && code != 0 ? conn.getInputStream() : conn.getErrorStream();
                byte[] bin = HttpsPostRequest.readInputStream(inStream);
                retn = APPLICATION_OCTET_STREAM.equals(conn.getContentType()) ? bin : (Object)new String(bin, "UTF-8");
                timestamp = conn.getHeaderField(HEADER_TIMESTAMP);
                responseSignValue = conn.getHeaderField(HEADER_SIGNATURE);
                responseNonce = conn.getHeaderField(HEADER_NONCE);
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        try {
            conn.setRequestMethod(ReqMethodEnum.POST.toString());
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------543279124964751");
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (null != bodyParamMap) {
                StringBuffer strBuf = new StringBuffer();
                for (Map.Entry<String, String> entry : bodyParamMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                ((OutputStream)out).write(strBuf.toString().getBytes());
            }
            File file = new File(filePath);
            String filename = file.getName();
            String inputName = "file";
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
            strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + filename + "\"\r\n\r\n");
            ((OutputStream)out).write(strBuf.toString().getBytes());
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream in = new DataInputStream(fileInputStream);
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            in.close();
            fileInputStream.close();
            byte[] endData = "\r\n-----------------------------543279124964751--\r\n".getBytes();
            ((OutputStream)out).write(endData);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            InputStream inStream = null;
            int code = conn.getResponseCode();
            inStream = code >= 200 && code < 300 && code != 0 ? conn.getInputStream() : conn.getErrorStream();
            strBuf = new StringBuffer();
            InputStreamReader inputStreamReader = new InputStreamReader(inStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
            retn = strBuf.toString();
            reader.close();
            reader = null;
            inputStreamReader.close();
            inputStreamReader = null;
            timestamp = conn.getHeaderField(HEADER_TIMESTAMP);
            responseSignValue = conn.getHeaderField(HEADER_SIGNATURE);
            responseNonce = conn.getHeaderField(HEADER_NONCE);
        }
        catch (FileNotFoundException e) {
            SdkException ex = new SdkException(SdkExType.FILE_ERROR_RESULT);
            String string = ex.toString();
            return string;
        }
        catch (IOException e) {
            SdkException ex = new SdkException(SdkExType.CONN_ERR);
            String string = ex.toString();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        if (keyConfigure.isRespSignSwitch() && !retn.toString().contains("\"code\":\"OPEN")) {
            VerifyRespSignature.verify(timestamp, responseNonce, responseSignValue, retn, keyConfigure);
        }
        return retn;
    }

    @Override
    public Object sendBySM(String url, ReqMethodEnum method, String authInfo, Map<String, String> headParams, String bodyParamString, Map<String, String> bodyParamMap, KeyConfigure keyConfigure, String bodyJson, String cfcaSignValue) throws Exception {
        String retn = null;
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca1", ChannelUtil.getCertificate(keyConfigure.getSslCertFilePath()));
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustMgrFact.init(trustStore);
        SSLContext ctx = SSLContext.getInstance("GMTLSV1.1");
        ctx.init(null, trustMgrFact.getTrustManagers(), null);
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        String responseSignValue = "";
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setMaxConnTotal(10).build();){
            RequestConfig ex = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(ex);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            StringEntity stringEntity = null;
            if (SdkUtil.isJSONString(bodyJson)) {
                paramMap.put("signValue", Base64.encode(cfcaSignValue.getBytes(StandardCharsets.UTF_8)));
                stringEntity = new StringEntity(JSON.toJSONString(paramMap), "UTF-8");
                httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            } else {
                paramMap.put("signValue", cfcaSignValue);
                stringEntity = new StringEntity("signValue=" + Base64.encode(cfcaSignValue.getBytes(StandardCharsets.UTF_8)), "UTF-8");
                httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("Authorization", authInfo);
            httpPost.addHeader("Mac_Addr", MacUtil.getLocalMac());
            CloseableHttpResponse response = null;
            try {
                response = httpclient.execute((HttpUriRequest)httpPost);
            }
            catch (Exception e) {
                CloseableHttpClient httpclientNoSSL;
                if (Configure.isDevEnv()) {
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                        public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                            return false;
                        }
                    }).build();
                    NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                    SSLConnectionSocketFactory smSslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                    httpclientNoSSL = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)smSslsf).setMaxConnTotal(10).build();
                } else {
                    httpclientNoSSL = HttpClients.custom().setMaxConnTotal(10).build();
                }
                response = httpclientNoSSL.execute((HttpUriRequest)httpPost);
            }
            HttpEntity entity = response.getEntity();
            if (response.getHeaders(HEADER_SIGNATURE).length > 0) {
                responseSignValue = response.getHeaders(HEADER_SIGNATURE)[0].getValue();
            }
            responseSignValue = new String(Base64.decode(responseSignValue));
            retn = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
        }
        if (keyConfigure.isRespSignSwitch() && !retn.toString().contains("\"code\":\"OPEN")) {
            VerifyRespSignature.verifyByCfcaSM(responseSignValue, keyConfigure);
        }
        return retn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(InputStream inStream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = null;
        byte[] buffer = new byte[2048];
        int len = 0;
        try {
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            data = outStream.toByteArray();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        return data;
    }

    private static void ignoreSSLVerify(HttpsURLConnection conn) {
        conn.setSSLSocketFactory(sf);
        conn.setHostnameVerifier(hv);
    }

    static {
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            sf = sc.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        SFS = new HashMap<String, SSLSocketFactory>();
        LOCK = new Object();
        SSL_INIT_STATUS = false;
    }
}

