/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.util;

import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

public class CFCASignature {
    private static Session session = null;
    private static final String DOT = ".";
    private static final String PFX_EXT_NAME = "pfx";
    private static final String SM2_EXT_NAME = "sm2";

    public static String signature(String sourceData, String certFilePath, String certPassword) {
        if (sourceData == null) {
            System.out.println("Signature source data is is null");
            return null;
        }
        String extName = CFCASignature.extName(certFilePath);
        try {
            if (PFX_EXT_NAME.equalsIgnoreCase(extName)) {
                PrivateKey ex = KeyUtil.getPrivateKeyFromPFX((String)certFilePath, (String)certPassword);
                X509Cert cert = CertUtil.getCertFromPFX((String)certFilePath, (String)certPassword);
                Signature sigUtil = new Signature();
                byte[] signature = sigUtil.p7SignMessageAttach("sha256WithRSAEncryption", sourceData.getBytes("UTF8"), ex, cert, session);
                return new String(signature, "UTF-8");
            }
            if (extName.equalsIgnoreCase(SM2_EXT_NAME)) {
                File file = new File(certFilePath);
                System.out.println(file.exists());
                SM2PrivateKey ex = KeyUtil.getPrivateKeyFromSM2((String)certFilePath, (String)certPassword);
                X509Cert cert = CertUtil.getCertFromSM2((String)certFilePath);
                Signature sigUtil = new Signature();
                byte[] signature = sigUtil.p7SignMessageAttach("sm3WithSM2Encryption", sourceData.getBytes("UTF8"), (PrivateKey)ex, cert, session);
                return new String(signature, "UTF-8");
            }
            throw new Exception("Error cert file :" + certFilePath);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static Boolean verify(String signData, String certFilePath) throws Exception {
        if (signData == null) {
            throw new Exception("Signature signData  is is null");
        }
        String extName = CFCASignature.extName(certFilePath);
        if (extName.equalsIgnoreCase(SM2_EXT_NAME)) {
            Signature sigUtil = new Signature();
            Boolean f = sigUtil.p7VerifyMessageAttach(signData.getBytes(StandardCharsets.UTF_8), session);
            return f;
        }
        throw new Exception("Error cert file :" + certFilePath);
    }

    private static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(DOT);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    static {
        try {
            JCrypto ex = JCrypto.getInstance();
            ex.initialize("JSOFT_LIB", null);
            session = ex.openSession("JSOFT_LIB");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

