/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.util;

import com.cib.fintech.dfp.open.sdk.util.Base64;
import com.cib.fintech.dfp.open.sdk.util.CertUtil;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class ChannelUtil {
    public static synchronized Certificate getCertificate(String sslCerFilePath) throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.addProvider((Provider)new BouncyCastleJsseProvider("BC"));
        }
        String certContent = CertUtil.getCertData(sslCerFilePath);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        return certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.decode(certContent)));
    }
}

