/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.util;

import com.cib.fintech.dfp.open.sdk.util.Const;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;

public class SdkUtil {
    private static final String REQ_SEPARATOR = "/";

    public static String checkReqUri(String reqUri) {
        if (reqUri == null || reqUri.length() == 0) {
            return reqUri;
        }
        if (!reqUri.startsWith(REQ_SEPARATOR)) {
            reqUri = REQ_SEPARATOR + reqUri;
        }
        if (reqUri.endsWith(REQ_SEPARATOR)) {
            reqUri = reqUri.substring(0, reqUri.length() - 1);
        }
        return reqUri;
    }

    public static String jointMap(Map<String, String> paramsMap) {
        try {
            StringBuilder mapBuilder = new StringBuilder();
            if (paramsMap != null && paramsMap.size() != 0) {
                for (String key : paramsMap.keySet()) {
                    mapBuilder.append(URLEncoder.encode(key, "UTF-8"));
                    mapBuilder.append("=");
                    mapBuilder.append(null == paramsMap.get(key) ? null : URLEncoder.encode(paramsMap.get(key), "UTF-8"));
                    mapBuilder.append("&");
                }
            }
            if (mapBuilder.length() > 1) {
                mapBuilder.setLength(mapBuilder.length() - 1);
            }
            return mapBuilder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getDateTime() {
        return Const.FORMATTER_TIME.format(new Date());
    }

    public static boolean notBlank(String str) {
        return null != str && !"".equals(str) && !"".equals(str.trim());
    }

    public static boolean notEmpty(Map<String, String> map) {
        return map != null && map.size() != 0;
    }

    public static boolean isJSONString(String str) {
        return null != str && str.startsWith("{") && str.endsWith("}");
    }
}

