/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.icbccrypto;

public class CEA {
    long[][] ExtendKey = new long[2 * this.CEA_ROTATE + 4][2];
    int CEA_ROTATE = 6;
    int CEA_MPI_LONG = 2;

    protected void Add(long[] s1, long[] s2, long[] res, int length) {
        long c = 0L;
        int i = length - 1;
        while (i >= 0) {
            res[i] = s1[i] + s2[i] + c;
            c = (res[i] & 0xFF00000000L) >>> 32;
            res[i] = res[i] & 0xFFFFFFFFL;
            --i;
        }
    }

    public void ByteToInt(byte[] source, int[] result, int length) {
        int i = 0;
        while (i < length) {
            result[i] = source[i] >= 0 ? source[i] : source[i] + 256;
            ++i;
        }
    }

    public void CEADecrypt(byte[] cipher, byte[] plain) {
        long[] A = new long[2];
        long[] B = new long[2];
        long[] Temp1 = new long[2];
        long[] Temp2 = new long[2];
        int[] Temp = new int[16];
        this.ByteToInt(cipher, Temp, 16);
        A[0] = (long)Temp[0] << 24 | (long)Temp[1] << 16 | (long)Temp[2] << 8 | (long)Temp[3];
        A[1] = (long)Temp[4] << 24 | (long)Temp[5] << 16 | (long)Temp[6] << 8 | (long)Temp[7];
        B[0] = (long)Temp[8] << 24 | (long)Temp[9] << 16 | (long)Temp[10] << 8 | (long)Temp[11];
        B[1] = (long)Temp[12] << 24 | (long)Temp[13] << 16 | (long)Temp[14] << 8 | (long)Temp[15];
        this.Add(A, this.ExtendKey[0], A, this.CEA_MPI_LONG);
        this.Add(B, this.ExtendKey[1], B, this.CEA_MPI_LONG);
        int i = 1;
        while (i <= this.CEA_ROTATE) {
            this.Xor(A, B, Temp1, this.CEA_MPI_LONG);
            int shift = (int)(B[1] & 0x3FL);
            this.LShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Add(Temp2, this.ExtendKey[2 * i], A, this.CEA_MPI_LONG);
            this.Xor(B, A, Temp1, this.CEA_MPI_LONG);
            shift = (int)(A[1] & 0x3FL);
            this.LShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Add(Temp2, this.ExtendKey[2 * i + 1], B, this.CEA_MPI_LONG);
            ++i;
        }
        this.Xor(A, this.ExtendKey[2 * this.CEA_ROTATE + 2], Temp1, this.CEA_MPI_LONG);
        this.Copy(Temp1, A, this.CEA_MPI_LONG);
        this.Xor(B, this.ExtendKey[2 * this.CEA_ROTATE + 3], Temp1, this.CEA_MPI_LONG);
        this.Copy(Temp1, B, this.CEA_MPI_LONG);
        this.LShift(A, Temp1, 1, this.CEA_MPI_LONG);
        this.LShift(B, Temp2, 1, this.CEA_MPI_LONG);
        long Bit1 = Temp1[1] & 1L;
        long Bit2 = Temp2[1] & 1L;
        Temp1[1] = Temp1[1] & 0xFFFFFFFEL;
        Temp1[1] = Temp1[1] | Bit2;
        Temp2[1] = Temp2[1] & 0xFFFFFFFEL;
        Temp2[1] = Temp2[1] | Bit1;
        Bit1 = Temp1[0] & 0x80000000L;
        Bit2 = (Temp1[0] & 0x40000000L) << 1;
        Temp1[0] = Temp1[0] & Integer.MAX_VALUE;
        Temp1[0] = Temp1[0] | (Bit1 ^= Bit2);
        this.Copy(Temp1, A, this.CEA_MPI_LONG);
        this.Copy(Temp2, B, this.CEA_MPI_LONG);
        int i2 = this.CEA_ROTATE;
        while (i2 >= 1) {
            this.Sub(B, this.ExtendKey[2 * i2 + 1], Temp1, this.CEA_MPI_LONG);
            int shift = (int)(A[1] & 0x3FL);
            this.RShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Xor(Temp2, A, B, this.CEA_MPI_LONG);
            this.Sub(A, this.ExtendKey[2 * i2], Temp1, this.CEA_MPI_LONG);
            shift = (int)(B[1] & 0x3FL);
            this.RShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Xor(Temp2, B, A, this.CEA_MPI_LONG);
            --i2;
        }
        this.Sub(B, this.ExtendKey[1], Temp1, this.CEA_MPI_LONG);
        Temp[8] = (int)(Temp1[0] >>> 24 & 0xFFL);
        Temp[9] = (int)(Temp1[0] >>> 16 & 0xFFL);
        Temp[10] = (int)(Temp1[0] >>> 8 & 0xFFL);
        Temp[11] = (int)(Temp1[0] & 0xFFL);
        Temp[12] = (int)(Temp1[1] >>> 24 & 0xFFL);
        Temp[13] = (int)(Temp1[1] >>> 16 & 0xFFL);
        Temp[14] = (int)(Temp1[1] >>> 8 & 0xFFL);
        Temp[15] = (int)(Temp1[1] & 0xFFL);
        this.Sub(A, this.ExtendKey[0], Temp1, this.CEA_MPI_LONG);
        Temp[0] = (int)(Temp1[0] >>> 24 & 0xFFL);
        Temp[1] = (int)(Temp1[0] >>> 16 & 0xFFL);
        Temp[2] = (int)(Temp1[0] >>> 8 & 0xFFL);
        Temp[3] = (int)(Temp1[0] & 0xFFL);
        Temp[4] = (int)(Temp1[1] >>> 24 & 0xFFL);
        Temp[5] = (int)(Temp1[1] >>> 16 & 0xFFL);
        Temp[6] = (int)(Temp1[1] >>> 8 & 0xFFL);
        Temp[7] = (int)(Temp1[1] & 0xFFL);
        this.IntToByte(Temp, plain, 16);
    }

    public void CEAEncrypt(byte[] plain, byte[] cipher) {
        long[] A = new long[2];
        long[] B = new long[2];
        long[] Temp1 = new long[2];
        long[] Temp2 = new long[2];
        int[] Temp = new int[16];
        this.ByteToInt(plain, Temp, 16);
        A[0] = (long)Temp[0] << 24 | (long)Temp[1] << 16 | (long)Temp[2] << 8 | (long)Temp[3];
        A[1] = (long)Temp[4] << 24 | (long)Temp[5] << 16 | (long)Temp[6] << 8 | (long)Temp[7];
        B[0] = (long)Temp[8] << 24 | (long)Temp[9] << 16 | (long)Temp[10] << 8 | (long)Temp[11];
        B[1] = (long)Temp[12] << 24 | (long)Temp[13] << 16 | (long)Temp[14] << 8 | (long)Temp[15];
        this.Add(A, this.ExtendKey[0], A, this.CEA_MPI_LONG);
        this.Add(B, this.ExtendKey[1], B, this.CEA_MPI_LONG);
        int i = 1;
        while (i <= this.CEA_ROTATE) {
            this.Xor(A, B, Temp1, this.CEA_MPI_LONG);
            int shift = (int)(B[1] & 0x3FL);
            this.LShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Add(Temp2, this.ExtendKey[2 * i], A, this.CEA_MPI_LONG);
            this.Xor(B, A, Temp1, this.CEA_MPI_LONG);
            shift = (int)(A[1] & 0x3FL);
            this.LShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Add(Temp2, this.ExtendKey[2 * i + 1], B, this.CEA_MPI_LONG);
            ++i;
        }
        this.LShift(A, Temp1, 63, this.CEA_MPI_LONG);
        this.LShift(B, Temp2, 63, this.CEA_MPI_LONG);
        long Bit1 = Temp1[0] & 0x80000000L;
        long Bit2 = Temp2[0] & 0x80000000L;
        Temp1[0] = Temp1[0] & Integer.MAX_VALUE;
        Temp1[0] = Temp1[0] | Bit2;
        Temp2[0] = Temp2[0] & Integer.MAX_VALUE;
        Temp2[0] = Temp2[0] | Bit1;
        Bit1 = Temp1[0] & 0x40000000L;
        Bit2 = (Temp1[0] & 0x20000000L) << 1;
        Temp1[0] = Temp1[0] & 0xBFFFFFFFL;
        Temp1[0] = Temp1[0] | (Bit1 ^= Bit2);
        this.Xor(Temp1, this.ExtendKey[2 * this.CEA_ROTATE + 2], A, this.CEA_MPI_LONG);
        this.Xor(Temp2, this.ExtendKey[2 * this.CEA_ROTATE + 3], B, this.CEA_MPI_LONG);
        int i2 = this.CEA_ROTATE;
        while (i2 >= 1) {
            this.Sub(B, this.ExtendKey[2 * i2 + 1], Temp1, this.CEA_MPI_LONG);
            int shift = (int)(A[1] & 0x3FL);
            this.RShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Xor(Temp2, A, B, this.CEA_MPI_LONG);
            this.Sub(A, this.ExtendKey[2 * i2], Temp1, this.CEA_MPI_LONG);
            shift = (int)(B[1] & 0x3FL);
            this.RShift(Temp1, Temp2, shift, this.CEA_MPI_LONG);
            this.Xor(Temp2, B, A, this.CEA_MPI_LONG);
            --i2;
        }
        this.Sub(B, this.ExtendKey[1], Temp1, this.CEA_MPI_LONG);
        Temp[8] = (int)(Temp1[0] >>> 24 & 0xFFL);
        Temp[9] = (int)(Temp1[0] >>> 16 & 0xFFL);
        Temp[10] = (int)(Temp1[0] >>> 8 & 0xFFL);
        Temp[11] = (int)(Temp1[0] & 0xFFL);
        Temp[12] = (int)(Temp1[1] >>> 24 & 0xFFL);
        Temp[13] = (int)(Temp1[1] >>> 16 & 0xFFL);
        Temp[14] = (int)(Temp1[1] >>> 8 & 0xFFL);
        Temp[15] = (int)(Temp1[1] & 0xFFL);
        this.Sub(A, this.ExtendKey[0], Temp1, this.CEA_MPI_LONG);
        Temp[0] = (int)(Temp1[0] >>> 24 & 0xFFL);
        Temp[1] = (int)(Temp1[0] >>> 16 & 0xFFL);
        Temp[2] = (int)(Temp1[0] >>> 8 & 0xFFL);
        Temp[3] = (int)(Temp1[0] & 0xFFL);
        Temp[4] = (int)(Temp1[1] >>> 24 & 0xFFL);
        Temp[5] = (int)(Temp1[1] >>> 16 & 0xFFL);
        Temp[6] = (int)(Temp1[1] >>> 8 & 0xFFL);
        Temp[7] = (int)(Temp1[1] & 0xFFL);
        this.IntToByte(Temp, cipher, 16);
    }

    public void Copy(long[] source, long[] result, int length) {
        int i = 0;
        while (i < length) {
            result[i] = source[i];
            ++i;
        }
    }

    public int Decrypt(byte[] in_data, byte[] out_data, int in_len, byte[] key, int key_len) {
        if (in_len < 16) {
            return -1;
        }
        byte[] in_temp = new byte[16];
        byte[] out_temp = new byte[16];
        this.init(key, key_len);
        int remainder = in_len % 16;
        int n = in_len / 16;
        if (remainder == 0) {
            int i = 0;
            while (i < n) {
                int k = i * 16;
                int j = 0;
                while (j < 16) {
                    in_temp[j] = in_data[k];
                    ++k;
                    ++j;
                }
                this.CEADecrypt(in_temp, out_temp);
                k = i * 16;
                j = 0;
                while (j < 16) {
                    out_data[k] = out_temp[j];
                    ++k;
                    ++j;
                }
                ++i;
            }
        } else {
            int k;
            int i = 0;
            while (i < n - 1) {
                k = i * 16;
                int j = 0;
                while (j < 16) {
                    in_temp[j] = in_data[k];
                    ++k;
                    ++j;
                }
                this.CEADecrypt(in_temp, out_temp);
                k = i * 16;
                j = 0;
                while (j < 16) {
                    out_data[k] = out_temp[j];
                    ++k;
                    ++j;
                }
                ++i;
            }
            k = (n - 1) * 16 + remainder;
            int j = 0;
            while (j < 16) {
                in_temp[j] = in_data[k];
                ++k;
                ++j;
            }
            this.CEADecrypt(in_temp, out_temp);
            k = n * 16;
            j = 0;
            while (j < remainder) {
                out_data[k] = out_temp[j];
                ++k;
                ++j;
            }
            k = (n - 1) * 16;
            j = 0;
            while (j < remainder) {
                in_temp[j] = in_data[k];
                ++k;
                ++j;
            }
            j = remainder;
            while (j < 16) {
                in_temp[j] = out_temp[j];
                ++j;
            }
            this.CEADecrypt(in_temp, out_temp);
            k = (n - 1) * 16;
            j = 0;
            while (j < 16) {
                out_data[k] = out_temp[j];
                ++k;
                ++j;
            }
        }
        return 0;
    }

    public int Encrypt(byte[] in_data, byte[] out_data, int in_len, byte[] key, int key_len) {
        if (in_len < 16) {
            return -1;
        }
        byte[] in_temp = new byte[16];
        byte[] out_temp = new byte[16];
        this.init(key, key_len);
        int remainder = in_len % 16;
        int n = in_len / 16;
        int i = 0;
        while (i < n) {
            int k = i * 16;
            int j = 0;
            while (j < 16) {
                in_temp[j] = in_data[k];
                ++k;
                ++j;
            }
            this.CEAEncrypt(in_temp, out_temp);
            k = i * 16;
            j = 0;
            while (j < 16) {
                out_data[k] = out_temp[j];
                ++k;
                ++j;
            }
            ++i;
        }
        if (remainder != 0) {
            int k = n * 16;
            int j = 0;
            while (j < remainder) {
                in_temp[j] = in_data[k];
                ++k;
                ++j;
            }
            k = (n - 1) * 16 + remainder;
            j = remainder;
            while (j < 16) {
                in_temp[j] = out_data[k];
                ++k;
                ++j;
            }
            this.CEAEncrypt(in_temp, out_temp);
            k = (n - 1) * 16 + remainder;
            j = 0;
            while (j < 16) {
                out_data[k] = out_temp[j];
                ++k;
                ++j;
            }
        }
        return 0;
    }

    public void init(byte[] key, int keylength) {
        long[][] SrcKey = new long[2 * this.CEA_ROTATE + 4][this.CEA_MPI_LONG];
        long[] A = new long[this.CEA_MPI_LONG];
        long[] B = new long[this.CEA_MPI_LONG];
        long[] Temp1 = new long[this.CEA_MPI_LONG];
        long[] Temp2 = new long[this.CEA_MPI_LONG];
        int i = 0;
        while (i < this.CEA_MPI_LONG) {
            A[i] = 0L;
            B[i] = 0L;
            Temp1[i] = 0L;
            Temp2[i] = 0L;
            ++i;
        }
        int keycount = (keylength + (this.CEA_MPI_LONG * 4 - 1)) / (this.CEA_MPI_LONG * 4);
        int[] temp = new int[keycount * (this.CEA_MPI_LONG * 4)];
        int i2 = 0;
        while (i2 < keycount * (this.CEA_MPI_LONG * 4)) {
            temp[i2] = 0;
            ++i2;
        }
        this.ByteToInt(key, temp, keylength);
        int n = 0;
        int i3 = 0;
        while (i3 < keycount) {
            int j = 0;
            while (j < this.CEA_MPI_LONG) {
                SrcKey[i3][j] = 0L;
                int k = 0;
                while (k < 4) {
                    SrcKey[i3][j] = SrcKey[i3][j] << 8 | (long)(temp[n] & 0xFF);
                    ++n;
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        this.ExtendKey[0][0] = 3084996963L;
        this.ExtendKey[0][1] = 2654435769L;
        i3 = 1;
        while (i3 < 2 * this.CEA_ROTATE + 4) {
            this.LShift(this.ExtendKey[i3 - 1], this.ExtendKey[i3], i3, this.CEA_MPI_LONG);
            ++i3;
        }
        i3 = 0;
        while (i3 < 2 * this.CEA_ROTATE + 4) {
            this.Add(A, B, Temp1, this.CEA_MPI_LONG);
            this.Add(this.ExtendKey[i3], Temp1, Temp2, this.CEA_MPI_LONG);
            this.LShift(Temp2, this.ExtendKey[i3], 5, this.CEA_MPI_LONG);
            this.Copy(this.ExtendKey[i3], A, this.CEA_MPI_LONG);
            this.Add(A, B, Temp1, this.CEA_MPI_LONG);
            this.Add(Temp1, SrcKey[i3 % keycount], Temp2, this.CEA_MPI_LONG);
            long t = Temp1[1] % 64L;
            this.LShift(Temp2, SrcKey[i3 % keycount], (int)t, this.CEA_MPI_LONG);
            this.Copy(SrcKey[i3 % keycount], B, this.CEA_MPI_LONG);
            ++i3;
        }
    }

    public void IntToByte(int[] source, byte[] result, int length) {
        int i = 0;
        while (i < length) {
            result[i] = source[i] < 128 ? (byte)source[i] : (byte)(source[i] - 256);
            ++i;
        }
    }

    public void LShift(long[] source, long[] result, int count, int length) {
        long[] mid = new long[length];
        int shiftlong = (count %= length * 32) >>> 5;
        int shiftbit = count & 0x1F;
        int rshiftbit = 32 - shiftbit;
        int i = 0;
        while (i < length) {
            mid[i] = source[shiftlong] << shiftbit & 0xFFFFFFFFL;
            if (++shiftlong >= length) {
                shiftlong = 0;
            }
            mid[i] = mid[i] | source[shiftlong] >>> rshiftbit & 0xFFFFFFFFL;
            ++i;
        }
        i = 0;
        while (i < length) {
            result[i] = mid[i];
            ++i;
        }
    }

    public static void main(String[] args) {
    }

    public void RShift(long[] source, long[] result, int count, int length) {
        count %= length * 32;
        count = length * 32 - count;
        this.LShift(source, result, count %= length * 32, length);
    }

    public void Sub(long[] s1, long[] s2, long[] result, int length) {
        long b = 0L;
        int i = length - 1;
        while (i >= 0) {
            result[i] = s1[i] - s2[i] - b;
            if (result[i] >= 0L) {
                b = 0L;
            } else {
                result[i] = result[i] + 0x100000000L;
                b = 1L;
            }
            --i;
        }
    }

    public void Xor(long[] s1, long[] s2, long[] result, int length) {
        int i = 0;
        while (i < length) {
            result[i] = s1[i] ^ s2[i];
            ++i;
        }
    }
}

