/*
 * Decompiled with CFR 0.152.
 */
package com.cgb.skms;

import com.alibaba.fastjson.JSON;
import com.cgb.skms.SmAlgorithm;
import com.cgb.skms.util.FileUtil;
import com.cgb.skms.util.GetKeyMessage;
import com.cgb.skms.util.Hex;
import com.cgb.skms.util.KeyException;
import com.cgb.skms.util.SM2KeyPair;
import com.cgb.skms.util.SM2Util;
import com.cgb.skms.util.SM3Util;
import com.cgb.skms.util.SM4Util;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class SdkEn_decrypt {
    private String authPath;
    private String systemShortName;
    private String queryPubKeyPath;
    private String sdkQueryKeyPath;

    public Hashtable<String, String> cryptEncrypt(String keyId, String plaintext) {
        String flag = "000000";
        String algorithm = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            algorithm = SmAlgorithm.getKey(keyId);
        }
        catch (KeyException e) {
            flag = "3060";
            e.printStackTrace();
        }
        try {
            if (algorithm.equals("sm2")) {
                try {
                    result = SmAlgorithm.sm2Encrypt(keyId, plaintext);
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    flag = "3060";
                }
            } else if (algorithm.equals("sm4")) {
                try {
                    result = SmAlgorithm.sm4Encrypt(keyId, plaintext, true);
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    flag = "3060";
                }
            } else {
                flag = "3060";
            }
            if (flag != "000000") {
                result.put("resultCode", flag);
                result.put("ciphertext", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (flag != "000000") {
            result.put("resultCode", flag);
        }
        return result;
    }

    public Hashtable<String, String> cryptEncryptCBC(String keyId, String plaintext) {
        String flag = "000000";
        Hashtable<String, String> result = new Hashtable();
        try {
            result = SmAlgorithm.sm4Encrypt(keyId, plaintext, false);
        }
        catch (KeyException e) {
            flag = "3060";
            e.printStackTrace();
        }
        if (flag != "000000") {
            result.put("resultCode", flag);
        }
        return result;
    }

    public Hashtable<String, String> cryptDecrypt(String keyId, String ciphertext) {
        String flag = "000000";
        String algorithm = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            algorithm = SmAlgorithm.getKey(keyId);
        }
        catch (KeyException e) {
            flag = "3060";
            e.printStackTrace();
        }
        try {
            if (algorithm.equals("sm2")) {
                try {
                    result = SmAlgorithm.sm2Decrypt(keyId, ciphertext);
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    flag = "3060";
                }
            } else if (algorithm.equals("sm4")) {
                try {
                    result = SmAlgorithm.sm4Decrypt(keyId, ciphertext, true);
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    flag = "3060";
                }
            } else {
                flag = "3060";
            }
            if (flag != "000000") {
                result.put("resultCode", flag);
                result.put("ciphertext", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (flag != "000000") {
            result.put("resultCode", flag);
        }
        return result;
    }

    public Hashtable<String, String> cryptDecryptCBC(String keyId, String plaintext) {
        String flag = "000000";
        Hashtable<String, String> result = new Hashtable();
        try {
            result = SmAlgorithm.sm4Decrypt(keyId, plaintext, false);
        }
        catch (KeyException e) {
            flag = "3060";
            e.printStackTrace();
        }
        if (flag != "000000") {
            result.put("resultCode", flag);
        }
        return result;
    }

    public String genWorkKey(String keyID) {
        String key = Hex.encode(SM4Util.generateKey(128));
        Hashtable<String, String> keyMap = this.cryptEncrypt(keyID, key);
        return keyMap.get("ciphertext");
    }

    public Hashtable<String, String> cryptEncrypt(String keyID, String keyCode, String data) {
        String resultCode = "000000";
        Hashtable<Object, Object> result = new Hashtable();
        Hashtable<String, String> encryptResult = new Hashtable<String, String>();
        String code = null;
        result = this.cryptDecrypt(keyID, keyCode);
        if ("000000" == result.get("resultCode") && resultCode == "000000") {
            try {
                code = Hex.encode(SM4Util.encryptECB(data.getBytes(), Hex.decode((String)result.get("plaintext"))));
            }
            catch (DataLengthException e) {
                resultCode = "1021";
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                resultCode = "2200";
                e.printStackTrace();
            }
            catch (KeyException e) {
                resultCode = "3060";
                e.printStackTrace();
            }
            encryptResult.put("resultCode", resultCode);
            if (resultCode.equals("000000")) {
                encryptResult.put("ciphertext", code);
            }
        } else {
            if ("000000" != result.get("resultCode") && result.containsKey("resultCode")) {
                encryptResult.put("resultCode", (String)result.get("resultCode"));
            } else {
                encryptResult.put("resultCode", resultCode);
            }
            encryptResult.put("ciphertext", "");
        }
        return encryptResult;
    }

    public Hashtable<String, String> cryptDecrypt(String keyID, String keyCode, String code) {
        String resultCode = "000000";
        Hashtable<Object, Object> result = new Hashtable();
        Hashtable<String, String> encryptResult = new Hashtable<String, String>();
        String data = null;
        result = this.cryptDecrypt(keyID, keyCode);
        if ("000000" == result.get("resultCode") && resultCode == "000000") {
            try {
                data = new String(SM4Util.decryptECB(Hex.decode(code), Hex.decode((String)result.get("plaintext"))));
            }
            catch (DataLengthException e) {
                resultCode = "1021";
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                resultCode = "2200";
                e.printStackTrace();
            }
            catch (KeyException e) {
                resultCode = "3060";
                e.printStackTrace();
            }
            encryptResult.put("resultCode", resultCode);
            if (resultCode.equals("000000")) {
                encryptResult.put("ciphertext", data);
            }
        } else {
            if ("000000" != result.get("resultCode") && result.containsKey("resultCode")) {
                encryptResult.put("resultCode", (String)result.get("resultCode"));
            } else {
                encryptResult.put("resultCode", resultCode);
            }
            encryptResult.put("ciphertext", "");
        }
        return encryptResult;
    }

    public String countHash(String data) {
        byte[] dataByte = null;
        try {
            dataByte = Hex.decode(GetKeyMessage.stringToHexString(data));
        }
        catch (KeyException e) {
            e.printStackTrace();
        }
        return Hex.encode(SM3Util.hash(dataByte));
    }

    public boolean verifyHash(String code, String data) {
        byte[] dataByte = null;
        byte[] codeByte = null;
        try {
            dataByte = Hex.decode(GetKeyMessage.stringToHexString(data));
            codeByte = Hex.decode(code);
        }
        catch (KeyException e) {
            e.printStackTrace();
        }
        return SM3Util.verifyHash(dataByte, codeByte);
    }

    public Hashtable<String, String> sm2Sign(String keyId, String data) {
        Hashtable report = (Hashtable)JSON.parseObject((String)((String)SmAlgorithm.securityKey.get(keyId)), Hashtable.class);
        String privKey = (String)report.get("keyValue");
        String flag = "000000";
        String signData = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            signData = Hex.encode(SM2Util.sign(Hex.decode(privKey), data.getBytes()));
        }
        catch (CryptoException e) {
            flag = "9820";
            e.printStackTrace();
        }
        catch (KeyException e) {
            flag = "3060";
            e.printStackTrace();
        }
        if (flag.equals("000000")) {
            result.put("signValue", signData);
        }
        result.put("resultCode", flag);
        return result;
    }

    public Hashtable<String, String> sm2SignFile(String keyId, String inFlieName, String inFliePath) {
        Hashtable report = (Hashtable)JSON.parseObject((String)((String)SmAlgorithm.securityKey.get(keyId)), Hashtable.class);
        String privKey = (String)report.get("keyValue");
        String flag = "000000";
        String signData = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        String inPath = inFliePath + File.separator + inFlieName;
        File dir = new File(inPath);
        if (!dir.exists()) {
            flag = "4400";
        }
        try {
            signData = Hex.encode(SM2Util.sign(Hex.decode("0000000000000000"), Hex.decode(privKey), FileUtil.getBytesByFile(inPath)));
        }
        catch (CryptoException e) {
            flag = "9820";
            e.printStackTrace();
        }
        catch (KeyException e) {
            flag = "3060";
            e.printStackTrace();
        }
        if (flag.equals("000000")) {
            result.put("signValue", signData);
        }
        result.put("resultCode", flag);
        return result;
    }

    public boolean sm2VerifySignFile(String keyId, String inFlieName, String inFliePath, String signValue) {
        boolean isSce = false;
        Hashtable report = (Hashtable)JSON.parseObject((String)((String)SmAlgorithm.securityKey.get(keyId)), Hashtable.class);
        String publicKey = (String)report.get("pbkValue");
        String inPath = inFliePath + File.separator + inFlieName;
        File dir = new File(inPath);
        if (!dir.exists()) {
            try {
                isSce = SM2Util.verifySign(Hex.decode("0000000000000000"), Hex.decode(publicKey), FileUtil.getBytesByFile(inPath), Hex.decode(signValue));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return isSce;
        }
        return false;
    }

    public boolean sm2VerifySign(String keyId, String data, String signValue) {
        boolean isSce = false;
        Hashtable report = (Hashtable)JSON.parseObject((String)((String)SmAlgorithm.securityKey.get(keyId)), Hashtable.class);
        String publicKey = (String)report.get("pbkValue");
        try {
            isSce = SM2Util.verifySign(Hex.decode(publicKey), Hex.decode(GetKeyMessage.stringToHexString(data)), Hex.decode(signValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSce;
    }

    public String cryptFile(int flag, String keyId, String inFlieName, String inFliePath, String outFlieName, String outFliePath) {
        String result = null;
        String inPath = inFliePath + File.separator + inFlieName;
        File dir = new File(inPath);
        if (dir.exists()) {
            if (flag == 0) {
                try {
                    result = SmAlgorithm.encryptFile(keyId, inPath, outFlieName, outFliePath);
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    result = "3060";
                }
            } else {
                try {
                    result = SmAlgorithm.decryptFile(keyId, inPath, outFlieName, outFliePath);
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    result = "3060";
                }
            }
        }
        return result;
    }

    public Hashtable<String, String> queryKeyValue(int flag, String keyId, String upload) {
        Hashtable<String, String> result = null;
        try {
            result = GetKeyMessage.checkCode(flag, this.systemShortName, keyId, this.authPath, this.queryPubKeyPath, this.sdkQueryKeyPath, upload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String queryKey(int flag, String keyId, String upload) {
        Hashtable<String, String> result = null;
        try {
            result = GetKeyMessage.checkCode(flag, this.systemShortName, keyId, this.authPath, this.queryPubKeyPath, this.sdkQueryKeyPath, upload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            return (String)result.get("resultCode");
        }
        return "";
    }

    public String queryKey(String keyId, String upload) {
        Hashtable<String, String> result = null;
        try {
            result = GetKeyMessage.checkCode(keyId, upload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            return result.get("resultCode");
        }
        return "";
    }

    public SdkEn_decrypt(String authPath, String systemShortName, String ip) {
        this.authPath = authPath;
        this.systemShortName = systemShortName;
        this.queryPubKeyPath = "http://" + ip + "/skms/noSessionServlet/sdk/queryPubKey.fun";
        this.sdkQueryKeyPath = "http://" + ip + "/skms/noSessionServlet/sdk/queryAppKey.fun";
    }

    public String sm4Encrypt(byte[] keyByte, String plaintext, boolean isECB) {
        String result = SmAlgorithm.sm4Encrypt(keyByte, plaintext, isECB);
        return result;
    }

    public String sm4Decrypt(byte[] keyByte, String ciphertext, boolean isECB) {
        return SmAlgorithm.sm4Decrypt(keyByte, ciphertext, isECB);
    }

    public byte[] genSm4Key() {
        return SM4Util.generateKey(128);
    }

    public SM2KeyPair genSm2Key() {
        return SM2Util.generateKeyPair();
    }

    public Hashtable<String, String> sm2Sign(byte[] priKey, String data) {
        String flag = "000000";
        String signData = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            signData = Hex.encode(SM2Util.sign(priKey, data.getBytes()));
        }
        catch (CryptoException e) {
            flag = "9820";
            e.printStackTrace();
        }
        if (flag.equals("000000")) {
            result.put("signValue", signData);
        }
        result.put("resultCode", flag);
        return result;
    }

    public boolean sm2VerifySign(byte[] pubKey, String data, String signValue) {
        boolean isSce = false;
        try {
            isSce = SM2Util.verifySign(pubKey, data.getBytes(), Hex.decode(signValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSce;
    }

    public Hashtable<String, String> sm2Encrypt(byte[] pubKey, String plaintext) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String resultCode = "000000";
        String sm2Code = null;
        try {
            sm2Code = Hex.encode(SM2Util.encrypt(pubKey, plaintext.getBytes()));
        }
        catch (InvalidCipherTextException e) {
            resultCode = "9003";
            e.printStackTrace();
        }
        catch (IOException e) {
            resultCode = "1100";
            e.printStackTrace();
        }
        result.put("resultCode", resultCode);
        if ("000000".equals(resultCode)) {
            result.put("ciphertext", sm2Code);
        } else {
            result.put("ciphertext", "");
        }
        return result;
    }

    public Hashtable<String, String> sm2Decrypt(byte[] priKey, String ciphertext) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String resultCode = "000000";
        String data = null;
        try {
            data = new String(SM2Util.decrypt(priKey, Hex.decode(ciphertext)));
        }
        catch (InvalidCipherTextException e) {
            resultCode = "9003";
            e.printStackTrace();
        }
        catch (IOException e) {
            resultCode = "1100";
            e.printStackTrace();
        }
        catch (KeyException e) {
            resultCode = "3060";
            e.printStackTrace();
        }
        result.put("resultCode", resultCode);
        if ("000000".equals(resultCode)) {
            result.put("plaintext", data);
        } else {
            result.put("plaintext", "");
        }
        return result;
    }
}

