/*
 * Decompiled with CFR 0.152.
 */
package com.cgb.skms.util;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.params.KeyParameter;

public class SM4Util {
    private static final int SM4_ENCRYPT = 1;
    private static final int SM4_DECRYPT = 0;
    public static final int SM4_PKCS7PADDING = 1;
    public static final int SM4_NOPADDING = 0;
    public static final int SM4_KEY_128 = 128;

    public static byte[] generateKey(int keySize) {
        byte[] key = new byte[keySize / 8];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(key);
        return key;
    }

    public static byte[] encryptECB(byte[] data, byte[] key) {
        return SM4Util.encryptECB(data, key, 1);
    }

    public static byte[] decryptECB(byte[] cipher, byte[] key) {
        return SM4Util.decryptECB(cipher, key, 1);
    }

    public static byte[] encryptCBC(byte[] data, byte[] key, byte[] iv) {
        return SM4Util.encryptCBC(data, key, iv, 1);
    }

    public static byte[] decryptCBC(byte[] cipher, byte[] key, byte[] iv) {
        return SM4Util.decryptCBC(cipher, key, iv, 1);
    }

    public static byte[] encryptECB(byte[] data, byte[] key, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(true, (CipherParameters)new KeyParameter(key));
        if (paddingMode == 1) {
            try {
                data = SM4Util.padding(data, 1, 7);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                data = SM4Util.padding(data, 1, 5);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int length = data.length;
        int i = 0;
        while (length > 0) {
            engine.processBlock(data, i, data, i);
            length -= 16;
            i += 16;
        }
        return data;
    }

    public static byte[] decryptECB(byte[] cipher, byte[] key, int paddingMode) throws DataLengthException, IllegalStateException {
        SM4Engine engine = new SM4Engine();
        engine.init(false, (CipherParameters)new KeyParameter(key));
        int length = cipher.length;
        byte[] tmp = new byte[cipher.length];
        int i = 0;
        while (length > 0) {
            engine.processBlock(cipher, i, tmp, i);
            length -= 16;
            i += 16;
        }
        byte[] plain = null;
        if (paddingMode == 1) {
            try {
                plain = SM4Util.padding(tmp, 0, 7);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                plain = SM4Util.padding(tmp, 0, 5);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return plain;
    }

    public static byte[] encryptCBC(byte[] data, byte[] key, byte[] iv, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(true, (CipherParameters)new KeyParameter(key));
        if (paddingMode == 1) {
            try {
                data = SM4Util.padding(data, 1, 7);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                data = SM4Util.padding(data, 1, 5);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int length = data.length;
        iv = (byte[])iv.clone();
        int i = 0;
        while (length > 0) {
            for (int j = 0; j < 16; ++j) {
                data[i + j] = (byte)(data[i + j] ^ iv[j]);
            }
            engine.processBlock(data, i, data, i);
            System.arraycopy(data, i, iv, 0, 16);
            length -= 16;
            i += 16;
        }
        return data;
    }

    public static byte[] decryptCBC(byte[] cipher, byte[] key, byte[] iv, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(false, (CipherParameters)new KeyParameter(key));
        int length = cipher.length;
        byte[] plain = new byte[cipher.length];
        iv = (byte[])iv.clone();
        int i = 0;
        while (length > 0) {
            engine.processBlock(cipher, i, plain, i);
            for (int j = 0; j < 16; ++j) {
                plain[j + i] = (byte)(plain[i + j] ^ iv[j]);
            }
            System.arraycopy(cipher, i, iv, 0, 16);
            length -= 16;
            i += 16;
        }
        byte[] res = null;
        if (paddingMode == 1) {
            try {
                res = SM4Util.padding(plain, 0, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            res = plain;
        }
        return res;
    }

    private static byte[] padding(byte[] input, int mode, int type) throws Exception {
        byte[] ret;
        block13: {
            block12: {
                if (input == null) {
                    return null;
                }
                ret = null;
                if (mode != 1) break block12;
                switch (type) {
                    case 7: {
                        int p = 16 - input.length % 16;
                        ret = new byte[input.length + p];
                        System.arraycopy(input, 0, ret, 0, input.length);
                        for (int i = 0; i < p; ++i) {
                            ret[input.length + i] = (byte)p;
                        }
                        break block13;
                    }
                    case 5: {
                        if (input.length <= 0) {
                            throw new Exception("\u6570\u636e\u5f02\u5e38\uff0cPKCS5Padding\u586b\u5145\u6a21\u5f0f\u9519\u8bef\uff0c\u5b57\u8282\u53c2\u6570\u4e3a\u7a7a\uff01");
                        }
                        try {
                            int length = input.length;
                            int leftLength = 8 - (length % 8 == 0 ? 8 : length % 8);
                            byte[] arrayReturn = new byte[length + leftLength];
                            byte[] plusbyte = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
                            if (leftLength > 0) {
                                for (int i = 0; i < length + leftLength; ++i) {
                                    arrayReturn[i] = i < length ? input[i] : plusbyte[leftLength];
                                }
                            } else {
                                ret = (byte[])input.clone();
                                break;
                            }
                            ret = (byte[])arrayReturn.clone();
                            break;
                        }
                        catch (Exception e) {
                            throw new Exception("\u6570\u636e\u5f02\u5e38\uff0cPKCS5Padding\u586b\u5145\u6a21\u5f0f\u9519\u8bef\uff0c\u5f02\u5e38\u629b\u51fa\uff01" + e.getMessage());
                        }
                    }
                }
                break block13;
            }
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }

    public static byte[] PKCS5Padding(byte[] inputByte) throws Exception {
        if (inputByte.length <= 0) {
            throw new Exception("\u6570\u636e\u5f02\u5e38\uff0cPKCS5Padding\u586b\u5145\u6a21\u5f0f\u9519\u8bef\uff0c\u5b57\u8282\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        try {
            int length = inputByte.length;
            int leftLength = 8 - (length % 8 == 0 ? 8 : length % 8);
            byte[] arrayReturn = new byte[length + leftLength];
            byte[] plusbyte = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
            if (leftLength > 0) {
                for (int i = 0; i < length + leftLength; ++i) {
                    arrayReturn[i] = i < length ? inputByte[i] : plusbyte[leftLength];
                }
            } else {
                return inputByte;
            }
            return arrayReturn;
        }
        catch (Exception e) {
            throw new Exception("\u6570\u636e\u5f02\u5e38\uff0cPKCS5Padding\u586b\u5145\u6a21\u5f0f\u9519\u8bef\uff0c\u5f02\u5e38\u629b\u51fa\uff01" + e.getMessage());
        }
    }
}

