/*
 * Decompiled with CFR 0.152.
 */
package cfca.asn1.parser;

import cfca.org.bouncycastle.crypto.CipherParameters;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BigFileCipherUtil {
    public static void bigFileBlockCipher(boolean encryptFlag, Mechanism alg, byte[] key, File inputFile, File outputFile) throws Exception {
        block29: {
            KeyParameter params;
            ParametersWithIV params2;
            Object param;
            String type = alg.getMechanismType();
            PaddedBufferedBlockCipher cipher = null;
            RC4Engine rc4 = null;
            if (type.equals("RC4")) {
                rc4 = new RC4Engine();
                param = new KeyParameter(key);
                rc4.init(encryptFlag, (CipherParameters)param);
            } else if (type.equals("DESede/CBC/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()), new PKCS7Padding());
                param = (CBCParam)alg.getParam();
                params2 = new ParametersWithIV(new KeyParameter(key), ((CBCParam)param).getIv());
                cipher.init(encryptFlag, params2);
            } else if (type.equals("SM4/CBC/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
                param = (CBCParam)alg.getParam();
                params2 = new ParametersWithIV(new KeyParameter(key), ((CBCParam)param).getIv());
                cipher.init(encryptFlag, params2);
            } else if (type.equals("DESede/ECB/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new DESedeEngine(), new PKCS7Padding());
                params = new KeyParameter(key);
                cipher.init(encryptFlag, params);
            } else if (type.equals("SM4/ECB/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new SM4Engine(), new PKCS7Padding());
                params = new KeyParameter(key);
                cipher.init(encryptFlag, params);
            } else {
                throw new PKIException("do not support this algorithm:" + type);
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int readLen = 0;
                byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
                fis = new FileInputStream(inputFile);
                fos = new FileOutputStream(outputFile);
                if (rc4 != null) {
                    byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER];
                    while ((readLen = fis.read(buffer)) > 0) {
                        rc4.processBytes(buffer, 0, readLen, outBytes, 0);
                        fos.write(outBytes, 0, readLen);
                    }
                    break block29;
                }
                byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER + 100];
                long readTotalLen = 0L;
                long fileLen = inputFile.length();
                int processLen = 0;
                while ((readLen = fis.read(buffer)) > 0) {
                    if (readLen == GlobalVariable.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                        processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                        fos.write(outBytes, 0, processLen);
                        continue;
                    }
                    int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    int len2 = cipher.doFinal(outBytes, len1);
                    fos.write(outBytes, 0, len1 + len2);
                    break;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

