/*
 * Decompiled with CFR 0.152.
 */
package cfca.asn1.parser;

import cfca.asn1.parser.ASN1Node;
import cfca.org.bouncycastle.crypto.BlockCipher;
import cfca.org.bouncycastle.crypto.CipherParameters;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class BigFileDecrypt {
    public static void bigFileBlockDecrypt(byte[] key, BlockCipher engine, CBCParam param, ASN1Node file_encrypted, OutputStream fos) throws Exception {
        block15: {
            RandomAccessFile raf = null;
            try {
                CipherParameters params;
                PaddedBufferedBlockCipher cipher = null;
                if (param == null) {
                    cipher = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
                    params = new KeyParameter(key);
                    cipher.init(false, params);
                } else {
                    cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
                    params = new ParametersWithIV(new KeyParameter(key), param.getIv());
                    cipher.init(false, params);
                }
                File encrypted_f = file_encrypted.f;
                long valueStartPos = file_encrypted.valueStartPos;
                long totalLength = file_encrypted.valueLength;
                long readTotalLen = 0L;
                int readLen = 0;
                int processLen = 0;
                byte[] temp = new byte[GlobalVariable.BIG_FILE_BUFFER];
                byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER + 100];
                raf = new RandomAccessFile(encrypted_f, "r");
                raf.seek(valueStartPos);
                if (totalLength > (long)GlobalVariable.BIG_FILE_BUFFER) {
                    while ((readLen = raf.read(temp)) > 0) {
                        if (readLen == GlobalVariable.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < totalLength) {
                            processLen = cipher.processBytes(temp, 0, readLen, outBytes, 0);
                            fos.write(outBytes, 0, processLen);
                            continue;
                        }
                        int len1 = cipher.processBytes(temp, 0, readLen, outBytes, 0);
                        int len2 = cipher.doFinal(outBytes, len1);
                        fos.write(outBytes, 0, len1 + len2);
                        break block15;
                    }
                    break block15;
                }
                readLen = raf.read(temp, 0, (int)totalLength);
                int len1 = cipher.processBytes(temp, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                fos.write(outBytes, 0, len1 + len2);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public static void bigFileBlockDecrypt(PaddedBufferedBlockCipher cipher, ASN1Node file_encrypted, OutputStream fos, RandomAccessFile raf) throws Exception {
        byte[] temp = new byte[GlobalVariable.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER + 100];
        long valueStartPos = 0L;
        int valueLen = 0;
        int childLen = file_encrypted.childNodes.size();
        int readTotalLen = 0;
        int len1 = 0;
        for (int i = 0; i < childLen; ++i) {
            ASN1Node file_encrypted_child = (ASN1Node)file_encrypted.childNodes.get(i);
            valueStartPos = file_encrypted_child.valueStartPos;
            valueLen = (int)file_encrypted_child.valueLength;
            raf.seek(valueStartPos);
            int currentLen = raf.read(temp, readTotalLen, valueLen);
            if ((readTotalLen += currentLen) < GlobalVariable.BIG_FILE_BUFFER) continue;
            len1 = cipher.processBytes(temp, 0, readTotalLen, outBytes, 0);
            fos.write(outBytes, 0, len1);
            readTotalLen = 0;
        }
        if (readTotalLen > 0) {
            len1 = cipher.processBytes(temp, 0, readTotalLen, outBytes, 0);
        }
        int len2 = cipher.doFinal(outBytes, len1);
        fos.write(outBytes, 0, len1 + len2);
    }

    public static void bigFileRC4Decrypt(byte[] key, ASN1Node file_encrypted, OutputStream fos) throws Exception {
        block13: {
            RandomAccessFile raf = null;
            try {
                KeyParameter param = new KeyParameter(key);
                RC4Engine rc4 = new RC4Engine();
                rc4.init(false, param);
                File encrypted_f = file_encrypted.f;
                long valueStartPos = file_encrypted.valueStartPos;
                long totalLength = file_encrypted.valueLength;
                long readTotalLen = 0L;
                int readLen = 0;
                byte[] temp = new byte[GlobalVariable.BIG_FILE_BUFFER];
                byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER];
                raf = new RandomAccessFile(encrypted_f, "r");
                raf.seek(valueStartPos);
                if (totalLength > (long)GlobalVariable.BIG_FILE_BUFFER) {
                    while ((readLen = raf.read(temp)) > 0) {
                        if (readLen == GlobalVariable.BIG_FILE_BUFFER && readTotalLen < totalLength) {
                            readTotalLen += (long)readLen;
                            rc4.processBytes(temp, 0, readLen, outBytes, 0);
                            fos.write(outBytes);
                            continue;
                        }
                        rc4.processBytes(temp, 0, readLen, outBytes, 0);
                        fos.write(outBytes, 0, readLen);
                        break block13;
                    }
                    break block13;
                }
                readLen = raf.read(temp, 0, (int)totalLength);
                rc4.processBytes(temp, 0, readLen, outBytes, 0);
                fos.write(outBytes, 0, readLen);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public static void bigFileRC4Decrypt(RC4Engine rc4, ASN1Node file_encrypted, OutputStream fos, RandomAccessFile raf) throws Exception {
        long valueStartPos = 0L;
        int readTotalLen = 0;
        byte[] temp = new byte[GlobalVariable.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER];
        int childLen = file_encrypted.childNodes.size();
        int valueLen = 0;
        for (int i = 0; i < childLen; ++i) {
            ASN1Node file_encrypted_child = (ASN1Node)file_encrypted.childNodes.get(i);
            valueStartPos = file_encrypted_child.valueStartPos;
            valueLen = (int)file_encrypted_child.valueLength;
            raf.seek(valueStartPos);
            int currentReadLen = raf.read(temp, readTotalLen, valueLen);
            if ((readTotalLen += currentReadLen) < GlobalVariable.BIG_FILE_BUFFER) continue;
            rc4.processBytes(temp, 0, readTotalLen, outBytes, 0);
            fos.write(outBytes, 0, readTotalLen);
            readTotalLen = 0;
        }
        if (readTotalLen > 0) {
            rc4.processBytes(temp, 0, readTotalLen, outBytes, 0);
            fos.write(outBytes, 0, readTotalLen);
        }
    }
}

