/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.net;

import cfca.ch.qos.logback.access.joran.JoranConfigurator;
import cfca.ch.qos.logback.access.net.SocketNode;
import cfca.ch.qos.logback.access.spi.AccessContext;
import cfca.ch.qos.logback.classic.joran.action.ConfigurationAction;
import cfca.ch.qos.logback.core.joran.spi.JoranException;
import cfca.ch.qos.logback.core.util.StatusPrinter;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleSocketServer {
    static int port;
    private static AccessContext basicContext;

    public static void main(String[] argv) throws Exception {
        if (argv.length == 2) {
            SimpleSocketServer.init(argv[0], argv[1]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        SimpleSocketServer.runServer();
    }

    static void runServer() {
        try {
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.out.println("Listening on port " + port);
            }
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                    System.out.println("Waiting to accept a new client.");
                }
                Socket socket = serverSocket.accept();
                if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                    System.out.println("Connected to client at " + socket.getInetAddress());
                    System.out.println("Starting new socket node.");
                }
                new Thread(new SocketNode(socket, basicContext)).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static void usage(String msg) {
        if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
            System.err.println(msg);
            System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        }
        System.exit(1);
    }

    static void init(String portStr, String configFile) throws JoranException {
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + portStr + "].");
        }
        basicContext = new AccessContext();
        if (configFile.endsWith(".xml")) {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(basicContext);
            configurator.doConfigure(configFile);
            StatusPrinter.print(basicContext);
        }
    }
}

