/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.servlet;

import cfca.ch.qos.logback.access.servlet.TeeHttpServletRequest;
import cfca.ch.qos.logback.access.servlet.TeeHttpServletResponse;
import cfca.ch.qos.logback.classic.joran.action.ConfigurationAction;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TeeFilter
implements Filter {
    boolean active;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.active && request instanceof HttpServletRequest) {
            try {
                TeeHttpServletRequest teeRequest = new TeeHttpServletRequest((HttpServletRequest)request);
                TeeHttpServletResponse teeResponse = new TeeHttpServletResponse((HttpServletResponse)response);
                filterChain.doFilter((ServletRequest)teeRequest, (ServletResponse)teeResponse);
                teeResponse.finish();
                teeRequest.setAttribute("LB_OUTPUT_BUFFER", teeResponse.getOutputBuffer());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            catch (ServletException e) {
                e.printStackTrace();
                throw e;
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String includeListAsStr = filterConfig.getInitParameter("includes");
        String excludeListAsStr = filterConfig.getInitParameter("excludes");
        String localhostName = TeeFilter.getLocalhostName();
        this.active = TeeFilter.computeActivation(localhostName, includeListAsStr, excludeListAsStr);
        if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
            if (this.active) {
                System.out.println("TeeFilter will be ACTIVE on this host [" + localhostName + "]");
            } else {
                System.out.println("TeeFilter will be DISABLED on this host [" + localhostName + "]");
            }
        }
    }

    static List<String> extractNameList(String nameListAsStr) {
        String[] nameArray;
        ArrayList<String> nameList = new ArrayList<String>();
        if (nameListAsStr == null) {
            return nameList;
        }
        if ((nameListAsStr = nameListAsStr.trim()).length() == 0) {
            return nameList;
        }
        String[] stringArray = nameArray = nameListAsStr.split("[,;]");
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            n3 = n3.trim();
            nameList.add(n3);
            ++n2;
        }
        return nameList;
    }

    static String getLocalhostName() {
        String hostname = "127.0.0.1";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        return hostname;
    }

    static boolean computeActivation(String hostname, String includeListAsStr, String excludeListAsStr) {
        List<String> includeList = TeeFilter.extractNameList(includeListAsStr);
        List<String> excludeList = TeeFilter.extractNameList(excludeListAsStr);
        boolean inIncludesList = TeeFilter.mathesIncludesList(hostname, includeList);
        boolean inExcludesList = TeeFilter.mathesExcludesList(hostname, excludeList);
        return inIncludesList && !inExcludesList;
    }

    static boolean mathesIncludesList(String hostname, List<String> includeList) {
        if (includeList.isEmpty()) {
            return true;
        }
        return includeList.contains(hostname);
    }

    static boolean mathesExcludesList(String hostname, List<String> excludesList) {
        if (excludesList.isEmpty()) {
            return false;
        }
        return excludesList.contains(hostname);
    }
}

