/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.classic.selector.servlet;

import cfca.ch.qos.logback.classic.Logger;
import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.action.ConfigurationAction;
import cfca.ch.qos.logback.classic.selector.ContextSelector;
import cfca.ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import cfca.ch.qos.logback.classic.util.JNDIUtil;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ContextDetachingSCL
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String loggerContextName = null;
        try {
            Context ctx = JNDIUtil.getInitialContext();
            loggerContextName = JNDIUtil.lookup(ctx, "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (loggerContextName != null) {
            ContextSelector selector;
            if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.out.println("About to detach context named " + loggerContextName);
            }
            if ((selector = ContextSelectorStaticBinder.getSingleton().getContextSelector()) == null) {
                if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                    System.out.println("Selector is null, cannot detach context. Skipping.");
                }
                return;
            }
            LoggerContext context = selector.getLoggerContext(loggerContextName);
            if (context != null) {
                Logger logger = context.getLogger("ROOT");
                logger.warn("Stopping logger context " + loggerContextName);
                selector.detachLoggerContext(loggerContextName);
                context.stop();
            } else if (!"true".equalsIgnoreCase(ConfigurationAction.CFCA_LOGBACK_NOLOG_KEY)) {
                System.out.println("No context named " + loggerContextName + " was found.");
            }
        }
    }

    public void contextInitialized(ServletContextEvent arg0) {
    }
}

