/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.classic.spi;

import cfca.ch.qos.logback.classic.Level;
import cfca.ch.qos.logback.classic.Logger;
import cfca.ch.qos.logback.classic.turbo.TurboFilter;
import cfca.ch.qos.logback.core.spi.FilterReply;
import cfca.org.slf4j.Marker;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TurboFilterList
extends CopyOnWriteArrayList<TurboFilter> {
    private static final long serialVersionUID = 1L;

    public FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        int size = this.size();
        if (size == 1) {
            try {
                TurboFilter tf = (TurboFilter)this.get(0);
                return tf.decide(marker, logger, level, format, params, t);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return FilterReply.NEUTRAL;
            }
        }
        Object[] tfa = this.toArray();
        int len = tfa.length;
        int i = 0;
        while (i < len) {
            TurboFilter tf = (TurboFilter)tfa[i];
            FilterReply r = tf.decide(marker, logger, level, format, params, t);
            if (r == FilterReply.DENY || r == FilterReply.ACCEPT) {
                return r;
            }
            ++i;
        }
        return FilterReply.NEUTRAL;
    }
}

