/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.core.pattern;

import cfca.ch.qos.logback.core.Context;
import cfca.ch.qos.logback.core.pattern.CompositeConverter;
import cfca.ch.qos.logback.core.pattern.Converter;
import cfca.ch.qos.logback.core.pattern.DynamicConverter;
import cfca.ch.qos.logback.core.spi.ContextAware;

public class ConverterUtil {
    public static <E> void startConverters(Converter<E> head) {
        Converter<E> c = head;
        while (c != null) {
            if (c instanceof CompositeConverter) {
                CompositeConverter cc = (CompositeConverter)c;
                Converter childConverter = cc.childConverter;
                ConverterUtil.startConverters(childConverter);
                cc.start();
            } else if (c instanceof DynamicConverter) {
                DynamicConverter dc = (DynamicConverter)c;
                dc.start();
            }
            c = c.getNext();
        }
    }

    public static <E> Converter<E> findTail(Converter<E> head) {
        Converter<E> p = head;
        while (p != null) {
            Converter<E> next = p.getNext();
            if (next == null) break;
            p = next;
        }
        return p;
    }

    public static <E> void setContextForConverters(Context context, Converter<E> head) {
        Converter<E> c = head;
        while (c != null) {
            if (c instanceof ContextAware) {
                ((ContextAware)((Object)c)).setContext(context);
            }
            c = c.getNext();
        }
    }
}

