/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.core.rolling.helper;

import cfca.ch.qos.logback.core.Context;
import cfca.ch.qos.logback.core.pattern.Converter;
import cfca.ch.qos.logback.core.pattern.ConverterUtil;
import cfca.ch.qos.logback.core.pattern.LiteralConverter;
import cfca.ch.qos.logback.core.pattern.parser.Node;
import cfca.ch.qos.logback.core.pattern.parser.Parser;
import cfca.ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import cfca.ch.qos.logback.core.rolling.helper.DateTokenConverter;
import cfca.ch.qos.logback.core.rolling.helper.FileFilterUtil;
import cfca.ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import cfca.ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import cfca.ch.qos.logback.core.spi.ContextAwareBase;
import cfca.ch.qos.logback.core.spi.ScanException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter<Object> headTokenConverter;

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }

    public FileNamePattern(String patternArg, Context contextArg) {
        this.setPattern(FileFilterUtil.slashify(patternArg));
        this.setContext(contextArg);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            String patternForParsing = this.escapeRightParantesis(this.pattern);
            Parser p = new Parser(patternForParsing, new AlmostAsIsEscapeUtil());
            p.setContext(this.context);
            Node t = p.parse();
            this.headTokenConverter = p.compile(t, CONVERTER_MAP);
        }
        catch (ScanException sce) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", sce);
        }
    }

    String escapeRightParantesis(String in) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public DateTokenConverter<Object> getPrimaryDateTokenConverter() {
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            DateTokenConverter dtc;
            if (p instanceof DateTokenConverter && (dtc = (DateTokenConverter)p).isPrimary()) {
                return dtc;
            }
            p = p.getNext();
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            if (p instanceof IntegerTokenConverter) {
                return (IntegerTokenConverter)p;
            }
            p = p.getNext();
        }
        return null;
    }

    public boolean hasIntegerTokenCOnverter() {
        IntegerTokenConverter itc = this.getIntegerTokenConverter();
        return itc != null;
    }

    public String convertMultipleArguments(Object ... objectList) {
        StringBuilder buf = new StringBuilder();
        Converter<Object> c = this.headTokenConverter;
        while (c != null) {
            if (c instanceof MonoTypedConverter) {
                MonoTypedConverter monoTyped = (MonoTypedConverter)((Object)c);
                Object[] objectArray = objectList;
                int n = objectList.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monoTyped.isApplicable(o)) {
                        buf.append(c.convert(o));
                    }
                    ++n2;
                }
            } else {
                buf.append(c.convert(objectList));
            }
            c = c.getNext();
        }
        return buf.toString();
    }

    public String convert(Object o) {
        StringBuilder buf = new StringBuilder();
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            buf.append(p.convert(o));
            p = p.getNext();
        }
        return buf.toString();
    }

    public String convertInt(int i) {
        return this.convert(i);
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toRegexForFixedDate(Date date) {
        StringBuilder buf = new StringBuilder();
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
            } else if (p instanceof IntegerTokenConverter) {
                buf.append("(\\d{1,3})");
            } else if (p instanceof DateTokenConverter) {
                buf.append(p.convert(date));
            }
            p = p.getNext();
        }
        return buf.toString();
    }

    public String toRegex() {
        StringBuilder buf = new StringBuilder();
        Converter<Object> p = this.headTokenConverter;
        while (p != null) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
            } else if (p instanceof IntegerTokenConverter) {
                buf.append("\\d{1,2}");
            } else if (p instanceof DateTokenConverter) {
                DateTokenConverter dtc = (DateTokenConverter)p;
                buf.append(dtc.toRegex());
            }
            p = p.getNext();
        }
        return buf.toString();
    }
}

