/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.asn1.pkcs;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import java.math.BigInteger;

public class MacData
extends ASN1Object {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    DigestInfo digInfo;
    byte[] salt;
    BigInteger iterationCount;

    public static MacData getInstance(Object obj) {
        if (obj instanceof MacData) {
            return (MacData)obj;
        }
        if (obj != null) {
            return new MacData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private MacData(ASN1Sequence seq) {
        this.digInfo = DigestInfo.getInstance(seq.getObjectAt(0));
        this.salt = ((ASN1OctetString)seq.getObjectAt(1)).getOctets();
        this.iterationCount = seq.size() == 3 ? ((ASN1Integer)seq.getObjectAt(2)).getValue() : ONE;
    }

    public MacData(DigestInfo digInfo, byte[] salt, int iterationCount) {
        this.digInfo = digInfo;
        this.salt = salt;
        this.iterationCount = BigInteger.valueOf(iterationCount);
    }

    public DigestInfo getMac() {
        return this.digInfo;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public BigInteger getIterationCount() {
        return this.iterationCount;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.digInfo);
        v.add(new DEROctetString(this.salt));
        if (!this.iterationCount.equals(ONE)) {
            v.add(new ASN1Integer(this.iterationCount));
        }
        return new DERSequence(v);
    }
}

