/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cert.cmp;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.cmp.CertConfirmContent;
import cfca.org.bouncycastle.asn1.cmp.CertStatus;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cert.cmp.CMPException;
import cfca.org.bouncycastle.cert.cmp.CMPUtil;
import cfca.org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import cfca.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.DigestCalculator;
import cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List acceptedCerts = new ArrayList();
    private List acceptedReqIds = new ArrayList();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgFinder) {
        this.digestAlgFinder = digestAlgFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder certHolder, BigInteger certReqID) {
        this.acceptedCerts.add(certHolder);
        this.acceptedReqIds.add(certReqID);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digesterProvider) throws CMPException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != this.acceptedCerts.size(); ++i) {
            DigestCalculator digester;
            X509CertificateHolder certHolder = (X509CertificateHolder)this.acceptedCerts.get(i);
            BigInteger reqID = (BigInteger)this.acceptedReqIds.get(i);
            AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
            if (digAlg == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digester = digesterProvider.get(digAlg);
            }
            catch (OperatorCreationException e) {
                throw new CMPException("unable to create digest: " + e.getMessage(), e);
            }
            CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
            v.add(new CertStatus(digester.getDigest(), reqID));
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(v)), this.digestAlgFinder);
    }
}

