/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cert.crmf;

import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.DERBitString;
import cfca.org.bouncycastle.asn1.crmf.EncryptedValue;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cert.crmf.CRMFException;
import cfca.org.bouncycastle.cert.crmf.EncryptedValuePadder;
import cfca.org.bouncycastle.operator.KeyWrapper;
import cfca.org.bouncycastle.operator.OperatorException;
import cfca.org.bouncycastle.operator.OutputEncryptor;
import cfca.org.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedValueBuilder {
    private KeyWrapper wrapper;
    private OutputEncryptor encryptor;
    private EncryptedValuePadder padder;

    public EncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor) {
        this(wrapper, encryptor, null);
    }

    public EncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor, EncryptedValuePadder padder) {
        this.wrapper = wrapper;
        this.encryptor = encryptor;
        this.padder = padder;
    }

    public EncryptedValue build(char[] revocationPassphrase) throws CRMFException {
        return this.encryptData(this.padData(Strings.toUTF8ByteArray(revocationPassphrase)));
    }

    public EncryptedValue build(X509CertificateHolder holder) throws CRMFException {
        try {
            return this.encryptData(this.padData(holder.getEncoded()));
        }
        catch (IOException e) {
            throw new CRMFException("cannot encode certificate: " + e.getMessage(), e);
        }
    }

    private EncryptedValue encryptData(byte[] data) throws CRMFException {
        DERBitString encSymmKey;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream eOut = this.encryptor.getOutputStream(bOut);
        try {
            eOut.write(data);
            eOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("cannot process data: " + e.getMessage(), e);
        }
        AlgorithmIdentifier intendedAlg = null;
        AlgorithmIdentifier symmAlg = this.encryptor.getAlgorithmIdentifier();
        try {
            this.wrapper.generateWrappedKey(this.encryptor.getKey());
            encSymmKey = new DERBitString(this.wrapper.generateWrappedKey(this.encryptor.getKey()));
        }
        catch (OperatorException e) {
            throw new CRMFException("cannot wrap key: " + e.getMessage(), e);
        }
        AlgorithmIdentifier keyAlg = this.wrapper.getAlgorithmIdentifier();
        ASN1OctetString valueHint = null;
        DERBitString encValue = new DERBitString(bOut.toByteArray());
        return new EncryptedValue(intendedAlg, symmAlg, encSymmKey, keyAlg, valueHint, encValue);
    }

    private byte[] padData(byte[] data) {
        if (this.padder != null) {
            return this.padder.getPaddedData(data);
        }
        return data;
    }
}

