/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cert.crmf.jcajce;

import cfca.org.bouncycastle.asn1.crmf.CertReqMsg;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.cert.crmf.CRMFException;
import cfca.org.bouncycastle.cert.crmf.CertificateRequestMessage;
import cfca.org.bouncycastle.cert.crmf.jcajce.CRMFHelper;
import cfca.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import cfca.org.bouncycastle.jcajce.NamedJcaJceHelper;
import cfca.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import java.io.IOException;
import java.security.Provider;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class JcaCertificateRequestMessage
extends CertificateRequestMessage {
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JcaCertificateRequestMessage(CertificateRequestMessage certReqMsg) {
        this(certReqMsg.toASN1Structure());
    }

    public JcaCertificateRequestMessage(CertReqMsg certReqMsg) {
        super(certReqMsg);
    }

    public JcaCertificateRequestMessage setProvider(String providerName) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcaCertificateRequestMessage setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public X500Principal getSubjectX500Principal() {
        X500Name subject = this.getCertTemplate().getSubject();
        if (subject != null) {
            try {
                return new X500Principal(subject.getEncoded("DER"));
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to construct DER encoding of name: " + e.getMessage());
            }
        }
        return null;
    }

    public PublicKey getPublicKey() throws CRMFException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getCertTemplate().getPublicKey();
        if (subjectPublicKeyInfo != null) {
            return this.helper.toPublicKey(subjectPublicKeyInfo);
        }
        return null;
    }
}

