/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cert.ocsp;

import cfca.org.bouncycastle.asn1.DERGeneralizedTime;
import cfca.org.bouncycastle.asn1.ocsp.RevokedInfo;
import cfca.org.bouncycastle.asn1.x509.CRLReason;
import cfca.org.bouncycastle.cert.ocsp.CertificateStatus;
import cfca.org.bouncycastle.cert.ocsp.OCSPUtils;
import java.util.Date;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public RevokedStatus(Date revocationDate, int reason) {
        this.info = new RevokedInfo(new DERGeneralizedTime(revocationDate), CRLReason.lookup(reason));
    }

    public Date getRevocationTime() {
        return OCSPUtils.extractDate(this.info.getRevocationTime());
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

