/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms.bc;

import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import cfca.org.bouncycastle.cms.SignerInformationVerifier;
import cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import cfca.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import java.security.cert.CertificateException;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcRSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator sigAlgNameGen, SignatureAlgorithmIdentifierFinder sigAlgIdFinder, DigestAlgorithmIdentifierFinder digestAlgorithmFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = sigAlgNameGen;
        this.sigAlgIdFinder = sigAlgIdFinder;
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder certHolder) throws OperatorCreationException, CertificateException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(certHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter pubKey) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(pubKey), this.digestCalculatorProvider);
    }
}

