/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms.jcajce;

import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.CMSAlgorithm;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import cfca.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import cfca.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import cfca.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import cfca.org.bouncycastle.operator.GenericKey;
import cfca.org.bouncycastle.operator.OutputEncryptor;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCMSContentEncryptorBuilder {
    private static Map keySizes = new HashMap();
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;

    private static int getKeySize(ASN1ObjectIdentifier oid) {
        Integer size = (Integer)keySizes.get(oid);
        if (size != null) {
            return size;
        }
        return -1;
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, JceCMSContentEncryptorBuilder.getKeySize(encryptionOID));
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public JceCMSContentEncryptorBuilder setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new CMSOutputEncryptor(this.encryptionOID, this.keySize, this.random);
    }

    static {
        keySizes.put(CMSAlgorithm.AES128_CBC, new Integer(128));
        keySizes.put(CMSAlgorithm.AES192_CBC, new Integer(192));
        keySizes.put(CMSAlgorithm.AES256_CBC, new Integer(256));
        keySizes.put(CMSAlgorithm.CAMELLIA128_CBC, new Integer(128));
        keySizes.put(CMSAlgorithm.CAMELLIA192_CBC, new Integer(192));
        keySizes.put(CMSAlgorithm.CAMELLIA256_CBC, new Integer(256));
    }

    private class CMSOutputEncryptor
    implements OutputEncryptor {
        private SecretKey encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Cipher cipher;

        CMSOutputEncryptor(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            KeyGenerator keyGen = JceCMSContentEncryptorBuilder.this.helper.createKeyGenerator(encryptionOID);
            if (random == null) {
                random = new SecureRandom();
            }
            if (keySize < 0) {
                keyGen.init(random);
            } else {
                keyGen.init(keySize, random);
            }
            this.cipher = JceCMSContentEncryptorBuilder.this.helper.createCipher(encryptionOID);
            this.encKey = keyGen.generateKey();
            AlgorithmParameters params = JceCMSContentEncryptorBuilder.this.helper.generateParameters(encryptionOID, this.encKey, random);
            try {
                this.cipher.init(1, (Key)this.encKey, params, random);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("unable to initialize cipher: " + e.getMessage(), e);
            }
            if (params == null) {
                params = this.cipher.getParameters();
            }
            this.algorithmIdentifier = JceCMSContentEncryptorBuilder.this.helper.getAlgorithmIdentifier(encryptionOID, params);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream dOut) {
            return new CipherOutputStream(dOut, this.cipher);
        }

        public GenericKey getKey() {
            return new GenericKey(this.encKey);
        }
    }
}

