/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms.jcajce;

import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.KeyTransRecipient;
import cfca.org.bouncycastle.cms.jcajce.CMSUtils;
import cfca.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import cfca.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import cfca.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import cfca.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import cfca.org.bouncycastle.operator.OperatorException;
import cfca.org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;

public abstract class JceKeyTransRecipient
implements KeyTransRecipient {
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected Map extraMappings;

    public JceKeyTransRecipient(PrivateKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.extraMappings = new HashMap();
        this.recipientKey = recipientKey;
    }

    public JceKeyTransRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyTransRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyTransRecipient setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    public JceKeyTransRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyTransRecipient setContentProvider(String providerName) {
        this.contentHelper = CMSUtils.createContentHelper(providerName);
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        JceAsymmetricKeyUnwrapper unwrapper = this.helper.createAsymmetricUnwrapper(keyEncryptionAlgorithm, this.recipientKey);
        if (!this.extraMappings.isEmpty()) {
            for (ASN1ObjectIdentifier algorithm : this.extraMappings.keySet()) {
                unwrapper.setAlgorithmMapping(algorithm, (String)this.extraMappings.get(algorithm));
            }
        }
        try {
            return this.helper.getJceKey(encryptedKeyAlgorithm.getAlgorithm(), unwrapper.generateUnwrappedKey(encryptedKeyAlgorithm, encryptedEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

