/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.crypto.agreement.kdf;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.crypto.DataLengthException;
import cfca.org.bouncycastle.crypto.DerivationFunction;
import cfca.org.bouncycastle.crypto.DerivationParameters;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import java.io.IOException;

public class DHKEKGenerator
implements DerivationFunction {
    private final Digest digest;
    private DERObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;
    private byte[] partyAInfo;

    public DHKEKGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
        this.partyAInfo = params.getExtraInfo();
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (len < 0) {
            throw new DataLengthException("output buffer length is negative");
        }
        if (outOff < 0) {
            throw new DataLengthException("output buffer offset is negative");
        }
        if (out.length - len < outOff) {
            throw new DataLengthException("output buffer too small");
        }
        long oBytes = len;
        int outLen = this.digest.getDigestSize();
        int cThreshold = (int)((oBytes + (long)outLen - 1L) / (long)outLen);
        byte[] dig = new byte[this.digest.getDigestSize()];
        int counter = 1;
        for (int i = 0; i < cThreshold; ++i) {
            this.digest.update(this.z, 0, this.z.length);
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(this.algorithm);
            v2.add(new DEROctetString(this.integerToBytes(counter)));
            v1.add(new DERSequence(v2));
            if (this.partyAInfo != null) {
                v1.add(new DERTaggedObject(true, 0, new DEROctetString(this.partyAInfo)));
            }
            v1.add(new DERTaggedObject(true, 2, new DEROctetString(this.integerToBytes(this.keySize))));
            try {
                byte[] other = new DERSequence(v1).getEncoded("DER");
                this.digest.update(other, 0, other.length);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to encode parameter info: " + e.getMessage());
            }
            this.digest.doFinal(dig, 0);
            if (len > outLen) {
                System.arraycopy(dig, 0, out, outOff, outLen);
                outOff += outLen;
                len -= outLen;
            } else {
                System.arraycopy(dig, 0, out, outOff, len);
            }
            ++counter;
        }
        this.digest.reset();
        return len;
    }

    private byte[] integerToBytes(int keySize) {
        byte[] val = new byte[]{(byte)(keySize >> 24), (byte)(keySize >> 16), (byte)(keySize >> 8), (byte)keySize};
        return val;
    }
}

