/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.crypto.generators;

import cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cfca.org.bouncycastle.crypto.KeyGenerationParameters;
import cfca.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import cfca.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import cfca.org.bouncycastle.crypto.params.DHParameters;
import cfca.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

