/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.crypto.tls;

import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.Mac;
import cfca.org.bouncycastle.crypto.macs.HMac;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.tls.ProtocolVersion;
import cfca.org.bouncycastle.crypto.tls.SSL3Mac;
import cfca.org.bouncycastle.crypto.tls.TlsClientContext;
import cfca.org.bouncycastle.crypto.tls.TlsUtils;
import cfca.org.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsMac {
    protected TlsClientContext context;
    protected long seqNo;
    protected byte[] secret;
    protected Mac mac;

    public TlsMac(TlsClientContext context, Digest digest, byte[] key_block, int offset, int len) {
        this.context = context;
        this.seqNo = 0L;
        KeyParameter param = new KeyParameter(key_block, offset, len);
        this.secret = Arrays.clone(param.getKey());
        boolean isTls = context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        this.mac = isTls ? new HMac(digest) : new SSL3Mac(digest);
        this.mac.init(param);
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public long getSequenceNumber() {
        return this.seqNo;
    }

    public void incSequenceNumber() {
        ++this.seqNo;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(short type, byte[] message, int offset, int len) {
        ProtocolVersion serverVersion = this.context.getServerVersion();
        boolean isTls = serverVersion.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        ByteArrayOutputStream bosMac = new ByteArrayOutputStream(isTls ? 13 : 11);
        try {
            TlsUtils.writeUint64(this.seqNo++, bosMac);
            TlsUtils.writeUint8(type, bosMac);
            if (isTls) {
                TlsUtils.writeVersion(serverVersion, bosMac);
            }
            TlsUtils.writeUint16(len, bosMac);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] macHeader = bosMac.toByteArray();
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, len);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return result;
    }
}

