/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.asymmetric.dh;

import cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import cfca.org.bouncycastle.crypto.generators.DHParametersGenerator;
import cfca.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import cfca.org.bouncycastle.crypto.params.DHParameters;
import cfca.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    DHKeyGenerationParameters param;
    DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
        }
        DHParameterSpec dhParams = (DHParameterSpec)params;
        this.param = new DHKeyGenerationParameters(random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            Integer paramStrength = new Integer(this.strength);
            if (params.containsKey(paramStrength)) {
                this.param = (DHKeyGenerationParameters)params.get(paramStrength);
            } else {
                DHParameterSpec dhParams = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters();
                if (dhParams != null && dhParams.getP().bitLength() == this.strength) {
                    this.param = new DHKeyGenerationParameters(this.random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
                } else {
                    DHParametersGenerator pGen = new DHParametersGenerator();
                    pGen.init(this.strength, this.certainty, this.random);
                    this.param = new DHKeyGenerationParameters(this.random, pGen.generateParameters());
                    params.put(paramStrength, this.param);
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        DHPublicKeyParameters pub = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters priv = (DHPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCDHPublicKey(pub), new BCDHPrivateKey(priv));
    }
}

