/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import cfca.org.bouncycastle.crypto.AsymmetricBlockCipher;
import cfca.org.bouncycastle.crypto.CryptoException;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA224Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.org.bouncycastle.crypto.engines.RSABlindedEngine;
import cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.org.bouncycastle.crypto.signers.PSSSigner;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;

public class PSSSignatureSpi
extends Signature {
    private AlgorithmParameters engineParams;
    private PSSParameterSpec paramSpec;
    private AsymmetricBlockCipher signer;
    private Digest contentDigest;
    private Digest mgfDigest;
    private int saltLength;
    private boolean isRaw;
    private PSSSigner pss;

    private void setupContentDigest() {
        this.contentDigest = this.isRaw ? new NullPssDigest(this.mgfDigest) : this.mgfDigest;
    }

    protected PSSSignatureSpi(String name, AsymmetricBlockCipher signer, Digest digest) {
        super(name);
        this.signer = signer;
        this.mgfDigest = digest;
        this.saltLength = digest != null ? digest.getDigestSize() : 20;
        if (this.paramSpec != null) {
            this.saltLength = this.paramSpec.getSaltLength();
        }
        this.isRaw = false;
        this.setupContentDigest();
    }

    protected PSSSignatureSpi(String name, AsymmetricBlockCipher signer, Digest digest, boolean isRaw) {
        super(name);
        this.signer = signer;
        this.mgfDigest = digest;
        this.saltLength = digest != null ? digest.getDigestSize() : 20;
        if (this.paramSpec != null) {
            this.saltLength = this.paramSpec.getSaltLength();
        }
        this.isRaw = isRaw;
        this.setupContentDigest();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(false, RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey));
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(true, new ParametersWithRandom(RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey), random));
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(true, RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey));
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.pss.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.pss.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException(e.getMessage());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pss.verifySignature(sigBytes);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidParameterException {
        if (params instanceof PSSParameterSpec) {
            PSSParameterSpec newParamSpec = (PSSParameterSpec)params;
            this.engineParams = null;
            this.paramSpec = newParamSpec;
            this.saltLength = this.paramSpec.getSaltLength();
            if (this.mgfDigest == null) {
                switch (this.saltLength) {
                    case 20: {
                        this.mgfDigest = new SHA1Digest();
                        break;
                    }
                    case 28: {
                        this.mgfDigest = new SHA224Digest();
                        break;
                    }
                    case 32: {
                        this.mgfDigest = new SHA256Digest();
                        break;
                    }
                    case 48: {
                        this.mgfDigest = new SHA384Digest();
                        break;
                    }
                    case 64: {
                        this.mgfDigest = new SHA512Digest();
                    }
                }
                this.setupContentDigest();
            }
        } else {
            throw new InvalidParameterException("Only PSSParameterSpec supported");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", BouncyCastleProvider.PROVIDER_NAME);
                this.engineParams.init(new PSSParameterSpec(this.saltLength));
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    private class NullPssDigest
    implements Digest {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        private Digest baseDigest;
        private boolean oddTime = true;

        public NullPssDigest(Digest mgfDigest) {
            this.baseDigest = mgfDigest;
        }

        public String getAlgorithmName() {
            return "NULL";
        }

        public int getDigestSize() {
            return this.baseDigest.getDigestSize();
        }

        public void update(byte in) {
            this.bOut.write(in);
        }

        public void update(byte[] in, int inOff, int len) {
            this.bOut.write(in, inOff, len);
        }

        public int doFinal(byte[] out, int outOff) {
            byte[] res = this.bOut.toByteArray();
            if (this.oddTime) {
                System.arraycopy(res, 0, out, outOff, res.length);
            } else {
                this.baseDigest.update(res, 0, res.length);
                this.baseDigest.doFinal(out, outOff);
            }
            this.reset();
            this.oddTime = !this.oddTime;
            return res.length;
        }

        public void reset() {
            this.bOut.reset();
            this.baseDigest.reset();
        }
    }

    public static class SHA512withRSA
    extends PSSSignatureSpi {
        public SHA512withRSA() {
            super("SHA512withRSAandMGF1", new RSABlindedEngine(), new SHA512Digest());
        }
    }

    public static class SHA384withRSA
    extends PSSSignatureSpi {
        public SHA384withRSA() {
            super("SHA384withRSAandMGF1", new RSABlindedEngine(), new SHA384Digest());
        }
    }

    public static class SHA256withRSA
    extends PSSSignatureSpi {
        public SHA256withRSA() {
            super("SHA256withRSAandMGF1", new RSABlindedEngine(), new SHA256Digest());
        }
    }

    public static class SHA224withRSA
    extends PSSSignatureSpi {
        public SHA224withRSA() {
            super("SHA224withRSAandMGF1", new RSABlindedEngine(), new SHA224Digest());
        }
    }

    public static class SHA1withRSA
    extends PSSSignatureSpi {
        public SHA1withRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), new SHA1Digest());
        }
    }

    public static class PSSwithRSA
    extends PSSSignatureSpi {
        public PSSwithRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), null);
        }
    }

    public static class nonePSS
    extends PSSSignatureSpi {
        public nonePSS() {
            super("NONEwithRSAandMGF1", new RSABlindedEngine(), null, true);
        }
    }
}

