/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.digest;

import cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.org.bouncycastle.crypto.digests.WhirlpoolDigest;
import cfca.org.bouncycastle.crypto.macs.HMac;
import cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cfca.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cfca.org.bouncycastle.jce.provider.JCEMac;

public class Whirlpool {

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }
}

