/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.ocsp;

import cfca.org.bouncycastle.asn1.DERGeneralizedTime;
import cfca.org.bouncycastle.asn1.ocsp.RevokedInfo;
import cfca.org.bouncycastle.asn1.x509.CRLReason;
import cfca.org.bouncycastle.ocsp.CertificateStatus;
import java.text.ParseException;
import java.util.Date;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public RevokedStatus(Date revocationDate, int reason) {
        this.info = new RevokedInfo(new DERGeneralizedTime(revocationDate), CRLReason.lookup(reason));
    }

    public Date getRevocationTime() {
        try {
            return this.info.getRevocationTime().getDate();
        }
        catch (ParseException e) {
            throw new IllegalStateException("ParseException:" + e.getMessage());
        }
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

