/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.operator.bc;

import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.Signer;
import cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.org.bouncycastle.crypto.signers.RSADigestSigner;
import cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import cfca.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import cfca.org.bouncycastle.operator.bc.BcUtil;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        Digest dig = BcUtil.createDigest(digAlg);
        return new RSADigestSigner(dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

