/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.pkcs;

import cfca.org.bouncycastle.asn1.pkcs.MacData;
import cfca.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.org.bouncycastle.operator.MacCalculator;
import cfca.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import cfca.org.bouncycastle.pkcs.PKCSException;
import java.io.IOException;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder builder) {
        this.builder = builder;
    }

    public MacData build(char[] password, byte[] data) throws PKCSException {
        MacCalculator macCalculator = this.builder.build(password);
        AlgorithmIdentifier algId = macCalculator.getAlgorithmIdentifier();
        OutputStream out = macCalculator.getOutputStream();
        try {
            out.write(data);
            out.close();
        }
        catch (IOException e) {
            throw new PKCSException("unable to process data: " + e.getMessage(), e);
        }
        DigestInfo dInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algId.getParameters());
        return new MacData(dInfo, params.getIV(), params.getIterations().intValue());
    }
}

