/*
 * Decompiled with CFR 0.152.
 */
package cfca.rsa.envelope;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.BigFileDecrypt;
import cfca.asn1.parser.EnvelopFileParser;
import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.Mechanism_Inside;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.BEROctetString;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.rsa.envelope.RSAEncryptedContentInfo;
import cfca.rsa.envelope.RSAEncryptedInputStream;
import cfca.rsa.envelope.RSAEnvelopedData;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.PKCS7EnvelopedData;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.SymmetricAlgorithm;
import cfca.util.Base64;
import cfca.util.cipher.lib.BCSoftLib;
import cfca.util.cipher.lib.JCrypto;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RSAEnvelopeUtil {
    private static final int recipientPolicy = 0;
    private static String RSA_PKCS = "RSA/ECB/PKCS1PADDING";

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        return RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws Exception {
        SymmetricAlgorithm.SymmetricAlgorithmParameters params = RSAEnvelopeUtil.buildSymmetricAlgorithmParameters(symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
        byte[] encryptedData = RSASymmetricCryptoUtil.encrypt(params.symmetricKey, sourceData, params.contentEncryptionAlg);
        BEROctetString encryptOctet = new BEROctetString(encryptedData);
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.data, params.contentEncryptionAlgId, encryptOctet);
        EnvelopedData enData = new EnvelopedData(null, new DERSet(params.recipientInfos), eci, null);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, enData);
        byte[] binary = ASN1Parser.writeDERObj2Bytes(new CMSEnvelopedData(contentInfo).toASN1Structure());
        return Base64.encode(binary);
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        return RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        RSAEnvelopeUtil.envelopeFile(sourceFilePath, envelopedFilePath, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public static final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws Exception {
        SymmetricAlgorithm.SymmetricAlgorithmParameters params = RSAEnvelopeUtil.buildSymmetricAlgorithmParameters(symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
        RSAEncryptedInputStream encryptStream = null;
        FileOutputStream fos = null;
        ASN1OutputStream dos = null;
        try {
            encryptStream = new RSAEncryptedInputStream(new File(sourceFilePath), params.symmetricKey, params.contentEncryptionAlg);
            RSAEncryptedContentInfo sm2Eci = new RSAEncryptedContentInfo(PKCSObjectIdentifiers.encryptedData, params.contentEncryptionAlgId, encryptStream);
            RSAEnvelopedData enData = new RSAEnvelopedData(null, new DERSet(params.recipientInfos), sm2Eci, null);
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, enData);
            File f = new File(envelopedFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(envelopedFilePath);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(contentInfo);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            encryptStream = null;
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        RSAEnvelopeUtil.envelopeFile(sourceFilePath, envelopedFilePath, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        if (cmsEnvelopedData == null) {
            throw new IllegalArgumentException("null not allowed for parameters: cmsEnvelopedData");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("null not allowed for  parameters: privateKey");
        }
        if (recipientCert == null) {
            throw new IllegalArgumentException("null not allowed for  parameters: recipientCert");
        }
        byte[] bEnvelop = null;
        bEnvelop = ASN1Parser.isBase64Encode(cmsEnvelopedData) ? Base64.decode(cmsEnvelopedData) : cmsEnvelopedData;
        CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
        ContentInfo info = cmsEnData.toASN1Structure();
        EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
        ASN1Set receivers = enData.getRecipientInfos();
        byte[] symmetricKey = RSAEnvelopeUtil.checkRecipientsAndSymmetricKey(privateKey, recipientCert, receivers, session);
        EncryptedContentInfo data = enData.getEncryptedContentInfo();
        ASN1OctetString os = data.getEncryptedContent();
        if (os == null) {
            throw new SecurityException("null not allowed for EncryptedContent");
        }
        AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
        Mechanism_Inside mechanism = RSAEnvelopeUtil.buildMechanism(symmetricAlgId);
        return RSASymmetricCryptoUtil.decrypt(symmetricKey, os.getOctets(), mechanism);
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        return RSAEnvelopeUtil.openEvelopedMessage(cmsEnvelopedData, privateKey, recipientCert, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void openEnvelopedFile(String envelopedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        if (envelopedFilePath == null) {
            throw new IllegalArgumentException("null not allowed for parameters: envelopedFilePath");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("null not allowed for  parameters: privateKey");
        }
        if (recipientCert == null) {
            throw new IllegalArgumentException("null not allowed for  parameters: recipientCert");
        }
        EnvelopFileParser parser = new EnvelopFileParser(new File(envelopedFilePath));
        parser.parser();
        ASN1Node receiver_node = parser.getReceiver_node();
        ASN1Node encrypted_node = parser.getEncrypted_node();
        FilterOutputStream fos = null;
        RandomAccessFile raf = null;
        try {
            ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
            byte[] symmetricKey = RSAEnvelopeUtil.checkRecipientsAndSymmetricKey(privateKey, recipientCert, receivers, session);
            ASN1Node symmetric_encrypted = (ASN1Node)encrypted_node.childNodes.get(1);
            byte[] symmetricAlg_byte = symmetric_encrypted.getData();
            AlgorithmIdentifier symmetricAlgId = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlg_byte));
            Mechanism_Inside mechanism = RSAEnvelopeUtil.buildMechanism(symmetricAlgId);
            File f = new File(plainTextFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new BufferedOutputStream(new FileOutputStream(f), GlobalVariable.BIG_FILE_BUFFER);
            ASN1Node file_encrypted = (ASN1Node)encrypted_node.childNodes.get(2);
            if (file_encrypted.childNodes.size() == 0) {
                if (mechanism.getMechanismType().equals("RC4")) {
                    BigFileDecrypt.bigFileRC4Decrypt(symmetricKey, file_encrypted, fos);
                } else {
                    BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new DESedeEngine(), (CBCParam)mechanism.getParam(), file_encrypted, fos);
                }
            } else if (file_encrypted.childNodes.size() == 1) {
                file_encrypted = (ASN1Node)file_encrypted.childNodes.get(0);
                if (mechanism.getMechanismType().equals("RC4")) {
                    BigFileDecrypt.bigFileRC4Decrypt(symmetricKey, file_encrypted, fos);
                } else {
                    BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new DESedeEngine(), (CBCParam)mechanism.getParam(), file_encrypted, fos);
                }
            } else if ("RC4".equals(mechanism.getMechanismType())) {
                RC4Engine rc4 = new RC4Engine();
                KeyParameter keyParam = new KeyParameter(symmetricKey);
                rc4.init(false, keyParam);
                raf = new RandomAccessFile(file_encrypted.f, "r");
                BigFileDecrypt.bigFileRC4Decrypt(rc4, file_encrypted, fos, raf);
            } else {
                DESedeEngine deSedeEngine = new DESedeEngine();
                PaddedBufferedBlockCipher cipher = null;
                CBCParam param = (CBCParam)mechanism.getParam();
                if (param == null) {
                    cipher = new PaddedBufferedBlockCipher(deSedeEngine, new PKCS7Padding());
                    KeyParameter params = new KeyParameter(symmetricKey);
                    cipher.init(false, params);
                } else {
                    cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(deSedeEngine), new PKCS7Padding());
                    ParametersWithIV params = new ParametersWithIV(new KeyParameter(symmetricKey), param.getIv());
                    cipher.init(false, params);
                }
                raf = new RandomAccessFile(file_encrypted.f, "r");
                BigFileDecrypt.bigFileBlockDecrypt(cipher, file_encrypted, fos, raf);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final void openEnvelopedFile(String envelopedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        RSAEnvelopeUtil.openEnvelopedFile(envelopedFilePath, plainTextFilePath, privateKey, recipientCert, session);
    }

    private static byte[] checkRecipientsAndSymmetricKey(PrivateKey privateKey, X509Cert recipientCert, ASN1Set receivers, Session session) throws Exception {
        if (receivers == null) {
            throw new Exception("the receiver is null!!!");
        }
        SubjectKeyIdentifier acceptedRecipientSubjectKeyID = recipientCert.getSubjectKeyIdentifier();
        X500Name acceptedRecipientIssuer = recipientCert.getIssuerX500Name();
        BigInteger acceptedRecipientSN = recipientCert.getSerialNumber();
        ASN1OctetString encryptKey = null;
        AlgorithmIdentifier algId = null;
        RecipientInfo recip = null;
        KeyTransRecipientInfo inf = null;
        int len = receivers.size();
        for (int i = 0; i < len; ++i) {
            recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
            if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !RSAEnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), acceptedRecipientSubjectKeyID, acceptedRecipientIssuer, acceptedRecipientSN)) continue;
            encryptKey = inf.getEncryptedKey();
            algId = inf.getKeyEncryptionAlgorithm();
            break;
        }
        if (encryptKey == null || algId == null) {
            throw new Exception("can not find the receiver!!!");
        }
        byte[] symmetricKey = RSAEnvelopeUtil.RSADecryptSymmetricKey(privateKey, encryptKey.getOctets(), session);
        if (symmetricKey == null) {
            throw new SecurityException("decrypt symmetricKey failure");
        }
        return symmetricKey;
    }

    private static boolean hasRecipent(KeyTransRecipientInfo keyTransRecipientInfo, SubjectKeyIdentifier acceptedRecipientSubjectKeyID, X500Name acceptedRecipientIssuer, BigInteger acceptedRecipientSN) {
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier == null) {
            return false;
        }
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(acceptedRecipientIssuer, acceptedRecipientSN);
        if (!recipientIdentifier.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive())) {
            return false;
        }
        if (acceptedRecipientSubjectKeyID != null && recipientIdentifier.getId() != null) {
            DEROctetString oct = new DEROctetString(acceptedRecipientSubjectKeyID.getKeyIdentifier());
            return recipientIdentifier.getId().toASN1Primitive().asn1Equals(oct);
        }
        return false;
    }

    private static final SymmetricAlgorithm.SymmetricAlgorithmParameters buildSymmetricAlgorithmParameters(String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicy) throws Exception {
        if (receiverCerts == null || receiverCerts.length == 0 || receiverCerts[0] == null) {
            throw new Exception("buildSymmetricAlgorithmParameters failure without ReceiverCerts");
        }
        SymmetricAlgorithm.SymmetricAlgorithmParameters params = SymmetricAlgorithm.buildRSASymmetricAlgorithmParameters(symmetricAlgorithm);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(RSAEnvelopeUtil.buildRecipientInfo(receiverCerts[i], params.symmetricKey, session, recipientPolicy));
        }
        params.recipientInfos = recipientInfos;
        return params;
    }

    private static final RecipientInfo buildRecipientInfo(X509Cert cert, byte[] symmetricKey, Session session, int recipientPolicy) throws Exception {
        byte[] encryptedKey = RSAEnvelopeUtil.RSAEncryptSymmetricKey(cert.getPublicKey(), symmetricKey, session);
        DEROctetString encKey = new DEROctetString(encryptedKey);
        RecipientIdentifier recipientIdentifier = cert.generateRecipientIdentifier(recipientPolicy);
        AlgorithmIdentifier keyEncAlg = cert.getCertStructure().getSubjectPublicKeyInfo().getAlgorithm();
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(recipientIdentifier, keyEncAlg, encKey);
        return new RecipientInfo(ktr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Mechanism_Inside buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        Mechanism_Inside mechanism = null;
        String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
        if (encryptionAlgStr.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
            CBCParam cbcParam = new CBCParam(doct.getOctets());
            if (!encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgStr);
            return new Mechanism_Inside("DESede/CBC/PKCS7Padding", cbcParam);
        }
        if (encryptionAlgStr.indexOf("ECB") != -1) {
            return new Mechanism_Inside("DESede/ECB/PKCS7Padding");
        }
        if (encryptionAlgStr.indexOf("RC4") == -1) throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgStr);
        return new Mechanism_Inside("RC4");
    }

    private static final byte[] RSAEncryptSymmetricKey(PublicKey publicKey, byte[] symmetricKey, Session session) throws Exception {
        Mechanism_Inside contentEncryptionAlg = new Mechanism_Inside(RSA_PKCS);
        byte[] encryptedSymmetricKey = session.encrypt(contentEncryptionAlg, publicKey, symmetricKey);
        return encryptedSymmetricKey;
    }

    private static final byte[] RSADecryptSymmetricKey(PrivateKey privateKey, byte[] encryptedSymmetricKey, Session session) throws Exception {
        Mechanism_Inside contentEncryptionAlg = new Mechanism_Inside(RSA_PKCS);
        byte[] decryptedSymmetricKey = session.encrypt(contentEncryptionAlg, privateKey, encryptedSymmetricKey);
        return decryptedSymmetricKey;
    }
}

