/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.apple.pay;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.cms.Attribute;
import cfca.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.org.bouncycastle.asn1.cms.Time;
import cfca.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.CMSProcessable;
import cfca.org.bouncycastle.cms.CMSProcessableByteArray;
import cfca.org.bouncycastle.cms.CMSSignedData;
import cfca.org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import cfca.org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import cfca.org.bouncycastle.cms.SignerId;
import cfca.org.bouncycastle.cms.SignerInformation;
import cfca.org.bouncycastle.cms.SignerInformationStore;
import cfca.org.bouncycastle.cms.SignerInformationVerifier;
import cfca.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import cfca.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cfca.org.bouncycastle.util.Store;
import cfca.org.bouncycastle.util.StoreException;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.cmbc.apple.pay.BcECDSASignerInfoVerifierBuilder;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class ApplePay {
    static final Logger logger = LoggerFactory.getLogger(ApplePay.class);
    static final String AppleRootCAG3Base64Text = "MIICQzCCAcmgAwIBAgIILcX8iNLFS5UwCgYIKoZIzj0EAwMwZzEbMBkGA1UEAwwSQXBwbGUgUm9vdCBDQSAtIEczMSYwJAYDVQQLDB1BcHBsZSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTETMBEGA1UECgwKQXBwbGUgSW5jLjELMAkGA1UEBhMCVVMwHhcNMTQwNDMwMTgxOTA2WhcNMzkwNDMwMTgxOTA2WjBnMRswGQYDVQQDDBJBcHBsZSBSb290IENBIC0gRzMxJjAkBgNVBAsMHUFwcGxlIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQKDApBcHBsZSBJbmMuMQswCQYDVQQGEwJVUzB2MBAGByqGSM49AgEGBSuBBAAiA2IABJjpLz1AcqTtkyJygRMc3RCV8cWjTnHcFBbZDuWmBSp3ZHtfTjjTuxxEtX/1H7YyYl3J6YRbTzBPEVoA/VhYDKX1DyxNB0cTddqXl5dvMVztK517IDvYuVTZXpmkOlEKMaNCMEAwHQYDVR0OBBYEFLuw3qFYM4iapIqZ3r6966/ayySrMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMAoGCCqGSM49BAMDA2gAMGUCMQCD6cHEFl4aXTQY2e3v9GwOAEZLuN+yRhHFD/3meoyhpmvOwgPUnPWTxnS4at+qIxUCMG1mihDK1A3UT82NQz60imOlM27jbdoXt2QfyFMm+YhidDkLF1vLUagM6BgD56KyKA==";
    static final String OID_CUSTOM_LEAFCERT = "1.2.840.113635.100.6.29";
    static final String OID_CUSTOM_LEAFCERT_INTERMEDIATECA = "1.2.840.113635.100.6.2.14";
    final X509Cert appleRootCAG3 = new X509Cert(Base64.decode("MIICQzCCAcmgAwIBAgIILcX8iNLFS5UwCgYIKoZIzj0EAwMwZzEbMBkGA1UEAwwSQXBwbGUgUm9vdCBDQSAtIEczMSYwJAYDVQQLDB1BcHBsZSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTETMBEGA1UECgwKQXBwbGUgSW5jLjELMAkGA1UEBhMCVVMwHhcNMTQwNDMwMTgxOTA2WhcNMzkwNDMwMTgxOTA2WjBnMRswGQYDVQQDDBJBcHBsZSBSb290IENBIC0gRzMxJjAkBgNVBAsMHUFwcGxlIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRMwEQYDVQQKDApBcHBsZSBJbmMuMQswCQYDVQQGEwJVUzB2MBAGByqGSM49AgEGBSuBBAAiA2IABJjpLz1AcqTtkyJygRMc3RCV8cWjTnHcFBbZDuWmBSp3ZHtfTjjTuxxEtX/1H7YyYl3J6YRbTzBPEVoA/VhYDKX1DyxNB0cTddqXl5dvMVztK517IDvYuVTZXpmkOlEKMaNCMEAwHQYDVR0OBBYEFLuw3qFYM4iapIqZ3r6966/ayySrMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMAoGCCqGSM49BAMDA2gAMGUCMQCD6cHEFl4aXTQY2e3v9GwOAEZLuN+yRhHFD/3meoyhpmvOwgPUnPWTxnS4at+qIxUCMG1mihDK1A3UT82NQz60imOlM27jbdoXt2QfyFMm+YhidDkLF1vLUagM6BgD56KyKA=="));
    private X509Cert signerCert = null;
    private Date signingTime = null;
    private String encryptionAlgOID = null;
    private byte[] contentDigest = null;

    public final boolean p7VerifyMessageDetach(byte[] contentBytes, byte[] signatureBytes) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageDetach>>>>>>Running");
            buffer.append("\n contentBytes: ");
            buffer.append(Debugger.dump(contentBytes));
            buffer.append("\n signatureBytes: ");
            buffer.append(Debugger.dump(signatureBytes));
            logger.debug(buffer.toString());
        }
        try {
            boolean checkIntermediateCA;
            boolean checkSignerCert;
            boolean checkTokenSignature;
            SignerInformationVerifier verifier;
            byte[] subcaExtBytes;
            X509Cert intermediateCA;
            byte[] subcaBytes;
            byte[] signerExtBytes;
            byte[] signerBytes;
            Collection certList;
            SignerInformation signerInfo;
            Iterator it;
            Store certs;
            CMSSignedData cmsSignedData;
            if (contentBytes == null) {
                throw new PKIException("852001", "missing contentBytes for ApplePay");
            }
            if (signatureBytes == null) {
                throw new PKIException("852001", "missing signatureBytes for ApplePay");
            }
            try {
                cmsSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(contentBytes), signatureBytes);
            }
            catch (CMSException e) {
                throw new PKIException("852001", "decode signedData  failure for ApplePay", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: decode signedData  for ApplePay");
            try {
                certs = cmsSignedData.getCertificates();
                SignerInformationStore signers = cmsSignedData.getSignerInfos();
                it = signers.getSigners().iterator();
            }
            catch (Exception e) {
                throw new PKIException("852001", "decode  signerInformation  failure for ApplePay", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: decode signerInformation  for ApplePay");
            if (!it.hasNext()) {
                throw new PKIException("852001", "missing signerInfo  for ApplePay");
            }
            try {
                signerInfo = (SignerInformation)it.next();
            }
            catch (Exception e) {
                throw new PKIException("852001", "fetch  signerInformation  failure for ApplePay", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch signerInformation  for ApplePay");
            try {
                Attribute timeAttr = signerInfo.getSignedAttributes().get(CMSAttributes.signingTime);
                if (timeAttr == null) {
                    throw new PKIException("852001", "missing signingTime for ApplePay");
                }
                ASN1Encodable time = timeAttr.getAttrValues().getObjectAt(0);
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch signingTime  for ApplePay>>{}", (Object)time);
                this.signingTime = Time.getInstance(time).getDate();
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("852001", "fetch  signingTime  failure for ApplePay", e);
            }
            try {
                this.encryptionAlgOID = signerInfo.getEncryptionAlgOID();
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch encryptionAlgOID  for ApplePay>>{}", (Object)this.encryptionAlgOID);
            }
            catch (Exception e) {
                throw new PKIException("852001", "fetch  encryptionAlgOID  failure for ApplePay", e);
            }
            if (!"1.2.840.10045.4.3.2".equals(this.encryptionAlgOID)) {
                throw new PKIException("ecdsa-with-SHA256 1.2.840.10045.4.3.2");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  leaf certificate  for ApplePay>>signerSID={}", (Object)signerInfo.getSID());
            try {
                certList = certs.getMatches(signerInfo.getSID());
            }
            catch (StoreException e) {
                throw new PKIException("852001", "fetch leaf certificate for ApplePay", e);
            }
            if (certList == null || certList.size() == 0) {
                throw new PKIException("852001", "missing leaf certificate for ApplePay");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  leaf certificate  for ApplePay>>matches={}", (Object)certList.size());
            X509CertificateHolder signerHolder = (X509CertificateHolder)certList.iterator().next();
            if (signerHolder == null) {
                throw new PKIException("852001", "missing leaf certificate for ApplePay");
            }
            try {
                signerBytes = signerHolder.getEncoded();
            }
            catch (IOException e) {
                throw new PKIException("852001", "read leaf certificate for ApplePay", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  leaf certificate  for ApplePay>>certBase64={}", (Object)new String(Base64.encode(signerBytes)));
            }
            try {
                this.signerCert = new X509Cert(signerBytes);
            }
            catch (Exception e) {
                throw new PKIException("852001", "pras leaf certificate for ApplePay", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  leaf certificate  for ApplePay>>{}", (Object)this.signerCert);
            try {
                signerExtBytes = this.signerCert.getExtensionByteData(OID_CUSTOM_LEAFCERT);
            }
            catch (Exception e) {
                throw new PKIException("852001", "check custom OIDs: 1.2.840.113635.100.6.29 failure for ApplePay", e);
            }
            if (signerExtBytes == null) {
                throw new PKIException("852001", "missing custom OIDs: 1.2.840.113635.100.6.29 for the leaf certificate");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  custom OIDs: 1.2.840.113635.100.6.29 for the leaf certificate");
            AuthorityKeyIdentifier authKeyIdentifier = this.signerCert.getAuthorityKeyIdentifier();
            if (authKeyIdentifier == null || authKeyIdentifier.getKeyIdentifier() == null) {
                throw new PKIException("852001", "missing AuthorityKeyIdentifier for the leaf certificate");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  AuthorityKeyIdentifier  for the leaf certificate=0x{}", (Object)Hex.toHexString(authKeyIdentifier.getKeyIdentifier()));
            }
            try {
                certList = certs.getMatches(new SignerId(authKeyIdentifier.getKeyIdentifier()));
            }
            catch (StoreException e) {
                throw new PKIException("852001", "fetch intermediate CA for ApplePay", e);
            }
            if (certList == null || certList.size() == 0) {
                throw new PKIException("852001", "missing intermediate CA for ApplePay");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch intermediate CA for ApplePay>>matches={}", (Object)certList.size());
            X509CertificateHolder subcaHolder = (X509CertificateHolder)certList.iterator().next();
            if (subcaHolder == null) {
                throw new PKIException("852001", "missing intermediate CA for ApplePay");
            }
            try {
                subcaBytes = subcaHolder.getEncoded();
            }
            catch (IOException e) {
                throw new PKIException("852001", "read intermediate CA  for ApplePay", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch intermediate CA  for ApplePay>>certBase64={}", (Object)new String(Base64.encode(signerBytes)));
            }
            try {
                intermediateCA = new X509Cert(subcaBytes);
            }
            catch (Exception e) {
                throw new PKIException("852001", "parse intermediate CA for ApplePay", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch   intermediate CA  for ApplePay>>{}", (Object)intermediateCA);
            try {
                subcaExtBytes = intermediateCA.getExtensionByteData(OID_CUSTOM_LEAFCERT_INTERMEDIATECA);
            }
            catch (Exception e) {
                throw new PKIException("852001", "check custom OIDs: 1.2.840.113635.100.6.2.14 failure for ApplePay", e);
            }
            if (subcaExtBytes == null) {
                throw new PKIException("852001", "missing custom OIDs: 1.2.840.113635.100.6.2.14 for the intermediate CA");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  custom OIDs: 1.2.840.113635.100.6.2.14 for the intermediate CA");
            authKeyIdentifier = intermediateCA.getAuthorityKeyIdentifier();
            if (authKeyIdentifier == null || authKeyIdentifier.getKeyIdentifier() == null) {
                throw new PKIException("852001", "missing AuthorityKeyIdentifier for the intermediate CA");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: fetch  AuthorityKeyIdentifier  for the the intermediate CA=0x{}", (Object)Hex.toHexString(authKeyIdentifier.getKeyIdentifier()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("p7VerifyMessageDetach<<<<<<Okay:compare SubjectKeyIdentifier  for the Apple Root CA - G3=0x{}", (Object)Hex.toHexString(this.appleRootCAG3.getSubjectKeyIdentifier().getKeyIdentifier()));
            }
            if (!Arrays.equals(authKeyIdentifier.getKeyIdentifier(), this.appleRootCAG3.getSubjectKeyIdentifier().getKeyIdentifier())) {
                throw new PKIException("852001", "Ensure that the root CA is the Apple Root CA - G3 for the intermediate CA");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: Ensure that the root CA is the Apple Root CA - G3 for the intermediate CA");
            try {
                verifier = new BcECDSASignerInfoVerifierBuilder(new DefaultCMSSignatureAlgorithmNameGenerator(), new DefaultSignatureAlgorithmIdentifierFinder(), new DefaultDigestAlgorithmIdentifierFinder(), new BcDigestCalculatorProvider()).build(signerHolder);
            }
            catch (OperatorCreationException e) {
                throw new PKIException("852001", " Ensure that the signature is a valid ECDSA signature (ecdsa-with-SHA256 1.2.840.10045.4.3.2) for the token\u2019s signature", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: signerInfoVerifierBuilder");
            try {
                checkTokenSignature = signerInfo.verify(verifier);
            }
            catch (CMSVerifierCertificateNotValidException e) {
                throw new PKIException("852001", "check the token\u2019s signature failure with invalid signingTime", e);
            }
            catch (CMSException e) {
                throw new PKIException("852001", "check the token\u2019s signature failure", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: check the token\u2019s signature={}", (Object)checkTokenSignature);
            if (!checkTokenSignature) {
                throw new PKIException("852001", "Invalid signature for the token\u2019s signature");
            }
            this.contentDigest = signerInfo.getContentDigest();
            if (logger.isDebugEnabled()) {
                logger.debug("p7VerifyMessageDetach<<<<<<Okay: contentDigest=0x{}", (Object)Hex.toHexString(this.contentDigest));
            }
            try {
                checkSignerCert = this.signerCert.verify(intermediateCA.getPublicKey());
            }
            catch (Exception e) {
                throw new PKIException("852001", "check signature failure for the leaf certificate", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: check signature for the leaf certificate={}", (Object)checkSignerCert);
            if (!checkSignerCert) {
                throw new PKIException("852001", "Invalid signature for the leaf certificate");
            }
            try {
                checkIntermediateCA = intermediateCA.verify(this.appleRootCAG3.getPublicKey());
            }
            catch (Exception e) {
                throw new PKIException("852001", "check signature failure for the  intermediate CA", e);
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Okay: check signature for the intermediate CA={}", (Object)checkIntermediateCA);
            if (!checkIntermediateCA) {
                throw new PKIException("852001", "Invalid signature for the intermediate CA");
            }
            logger.debug("p7VerifyMessageDetach<<<<<<Successfully");
            return true;
        }
        catch (PKIException e) {
            if (logger.isDebugEnabled()) {
                logger.error("p7VerifyMessageDetach<<<<<<Failure: " + e.getMessage(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("p7VerifyMessageDetach<<<<<<Exception: " + e.getMessage(), e);
            }
            throw new PKIException("852001", "P7VerifyMessageDetach failure", e);
        }
    }

    public final Date getSigningTime() {
        return this.signingTime;
    }

    public final X509Cert getSignerCert() {
        return this.signerCert;
    }

    public final String getEncryptionAlgOID() {
        return this.encryptionAlgOID;
    }

    public final byte[] getContentDigest() {
        return this.contentDigest;
    }

    public static final byte[] concatenated(String base64EphemeralPublicKey, String base64Data, String hexTransactionId) throws PKIException {
        return ApplePay.concatenated(base64EphemeralPublicKey, base64Data, hexTransactionId, null);
    }

    public static final byte[] concatenated(String base64EphemeralPublicKey, String base64Data, String hexTransactionId, String hexApplicationData) throws PKIException {
        try {
            if (base64EphemeralPublicKey == null || base64EphemeralPublicKey.length() == 0) {
                throw new PKIException("852002", "missing base64EphemeralPublicKey");
            }
            if (base64Data == null || base64Data.length() == 0) {
                throw new PKIException("852002", "missing base64Data");
            }
            if (hexTransactionId == null || hexTransactionId.length() == 0) {
                throw new PKIException("852002", "missing base64Data");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(Base64.decode(base64EphemeralPublicKey));
            }
            catch (IOException e) {
                throw new PKIException("852002", "invalid base64EphemeralPublicKey", e);
            }
            try {
                baos.write(Base64.decode(base64Data));
            }
            catch (IOException e) {
                throw new PKIException("852002", "invalid base64Data", e);
            }
            try {
                baos.write(Hex.decode(hexTransactionId));
            }
            catch (IOException e) {
                throw new PKIException("852002", "invalid hexTransactionId", e);
            }
            try {
                if (hexApplicationData != null && hexApplicationData.length() != 0 && !"nil".equals(hexApplicationData)) {
                    baos.write(Hex.decode(hexApplicationData));
                }
            }
            catch (IOException e) {
                throw new PKIException("852002", "invalid hexApplicationData", e);
            }
            return baos.toByteArray();
        }
        catch (PKIException e) {
            if (logger.isDebugEnabled()) {
                logger.error("concatenated<<<<<<Failure: " + e.getMessage(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("concatenated<<<<<<Exception: " + e.getMessage(), e);
            }
            throw new PKIException("852002", "concatenated failure", e);
        }
    }
}

