/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.cmbc.tools.DecryptKit;
import cfca.sadk.cmbc.tools.DecryptKitException;
import cfca.sadk.cmbc.tools.SecurityKitImpl;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.util.Base64;
import cmbc.cfca.util.EnvelopeUtil;
import cmbc.cfca.util.SignatureUtil2;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.File;
import java.util.UUID;

public final class CMBCDecryptKit
extends SecurityKitImpl
implements DecryptKit {
    private static final Logger logger = LoggerFactory.getLogger(CMBCDecryptKit.class);
    private static final String charset = "UTF-8";
    final String tempDirectory = "/tmp/SignAndEncryptFile/";

    public CMBCDecryptKit() {
        block3: {
            this.tempDirectory = "/tmp/SignAndEncryptFile/";
            try {
                File file = new File("/tmp/SignAndEncryptFile/");
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error("Mkdir SignAndEncryptFile Failure", e);
            }
        }
    }

    public final String SignAndEncryptMessage(String base64PlainMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SignAndEncryptMessage>>>>>>Running");
            buffer.append("\n base64PlainMessage: ");
            buffer.append(Debugger.dump(base64PlainMessage));
            logger.info(buffer.toString());
        }
        try {
            byte[] sourceData;
            byte[] base64PKCS7SignedData;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (base64PlainMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            byte[] binary = Base64.decode(base64PlainMessage);
            if (binary == null) {
                throw new DecryptKitException(1879117826);
            }
            if (logger.isInfoEnabled()) {
                logger.info("SignAndEncryptMessage<<<<<<binaryPlainMessage: " + Debugger.dump(binary));
            }
            byte[] base64EnvelopedData = null;
            SignatureUtil2 engine = new SignatureUtil2();
            String mechanism = null;
            String symmetricAlgorithm = null;
            if (this.smxFlag) {
                mechanism = "SM3withSM2";
                symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
            } else {
                mechanism = "SHA256withRSAEncryption";
                symmetricAlgorithm = "DESede/CBC/PKCS7Padding";
            }
            if (logger.isInfoEnabled()) {
                logger.info("SignAndEncryptMessage<<<<<<smxFlag: " + this.smxFlag);
            }
            try {
                base64PKCS7SignedData = engine.p7SignMessageAttach(mechanism, binary, this.privateKey, this.signedCert, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(0x70010011, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("SignAndEncryptMessage<<<<<<base64PKCS7SignedData: " + Debugger.dumpBase64(base64PKCS7SignedData));
            }
            try {
                sourceData = Base64.decode(base64PKCS7SignedData);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113748, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("SignAndEncryptMessage<<<<<<binaryPKCS7SignedData: " + Debugger.dump(sourceData));
            }
            try {
                base64EnvelopedData = EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, new X509Cert[]{this.cmbcCert}, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113746, (Throwable)e);
            }
            String result = null;
            try {
                result = new String(base64EnvelopedData, charset);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113747, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("SignAndEncryptMessage<<<<<<Finished: base64EnvelopedData: " + Debugger.dumpBase64(base64EnvelopedData));
            }
            return result;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("SignAndEncryptMessage<<<<<<Failure");
                buffer.append("\n base64PlainMessage: ");
                buffer.append(Debugger.dump(base64PlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("SignAndEncryptMessage<<<<<<Failure");
                buffer.append("\n base64PlainMessage: ");
                buffer.append(Debugger.dump(base64PlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    public final String DecryptAndVerifyMessage(String base64EnvelopeMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("DecryptAndVerifyMessage>>>>>>Running");
            buffer.append("\n base64EnvelopeMessage: ");
            buffer.append(Debugger.dump(base64EnvelopeMessage));
            logger.info(buffer.toString());
        }
        try {
            SignatureUtil2 engine;
            byte[] decrtypedBytes;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (base64EnvelopeMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            String base64SourceData = null;
            byte[] cmsEnvelopedData = null;
            try {
                cmsEnvelopedData = base64EnvelopeMessage.getBytes(charset);
                if (cmsEnvelopedData == null) {
                    throw new DecryptKitException(1879117826);
                }
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113764, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("DecryptAndVerifyMessage<<<<<<base64EnvelopeMessage[getBytes]: " + Debugger.dump(cmsEnvelopedData));
                logger.info("DecryptAndVerifyMessage<<<<<<smxFlag: " + this.smxFlag);
            }
            try {
                decrtypedBytes = EnvelopeUtil.openEvelopedMessage(cmsEnvelopedData, this.privateKey, this.signedCert, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113761, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("DecryptAndVerifyMessage<<<<<<binaryDecrtypedBytes: " + Debugger.dump(decrtypedBytes));
            }
            try {
                boolean verifyResult;
                engine = new SignatureUtil2();
                byte[] base64PKCS7SignedData = Base64.encode(decrtypedBytes);
                if (logger.isInfoEnabled()) {
                    logger.info("DecryptAndVerifyMessage<<<<<<base64PKCS7SignedData: " + Debugger.dumpBase64(base64PKCS7SignedData));
                }
                if (!(verifyResult = engine.p7VerifyMessageAttach(base64PKCS7SignedData, this.session))) {
                    throw new DecryptKitException(1879113732);
                }
                this.checkPeerSignedCert(engine.getSignerCert());
            }
            catch (DecryptKitException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113762, (Throwable)e);
            }
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("DecryptAndVerifyMessage<<<<<<SourceData[Bytes]: " + Debugger.dump(engine.getSourceData()));
                }
                base64SourceData = new String(Base64.encode(engine.getSourceData()), charset);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113763, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("DecryptAndVerifyMessage<<<<<<Finished: base64SourceData=" + Debugger.dump(base64SourceData));
            }
            return base64SourceData;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("DecryptAndVerifyMessage<<<<<<Failure");
                buffer.append("\n base64EnvelopeMessage: ");
                buffer.append(Debugger.dump(base64EnvelopeMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("DecryptAndVerifyMessage<<<<<<Failure");
                buffer.append("\n base64EnvelopeMessage: ");
                buffer.append(Debugger.dump(base64EnvelopeMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int SignAndEncryptFile(String binaryPlainFile, String binaryEnvelopeFile) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SignAndEncryptFile>>>>>>Running");
            buffer.append("\n binaryPlainFile: ");
            buffer.append(Debugger.dump(binaryPlainFile));
            buffer.append("\n binaryEnvelopeFile: ");
            buffer.append(Debugger.dump(binaryEnvelopeFile));
            logger.info(buffer.toString());
        }
        try {
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (binaryPlainFile == null) {
                throw new DecryptKitException(0x70011000);
            }
            if (binaryEnvelopeFile == null) {
                throw new DecryptKitException(0x70011000);
            }
            SignatureUtil2 engine = new SignatureUtil2();
            String mechanism = null;
            String symmetricAlgorithm = null;
            if (this.smxFlag) {
                mechanism = "SM3withSM2";
                symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
            } else {
                mechanism = "SHA256withRSAEncryption";
                symmetricAlgorithm = "DESede/CBC/PKCS7Padding";
            }
            String signedFilePath = "/tmp/SignAndEncryptFile/" + new File(binaryPlainFile).getName() + UUID.randomUUID();
            try {
                try {
                    engine.p7SignFileAttach(mechanism, binaryPlainFile, signedFilePath, this.privateKey, this.signedCert, this.session);
                }
                catch (Exception e) {
                    throw new DecryptKitException(0x70010011, (Throwable)e);
                }
                try {
                    EnvelopeUtil.envelopeFile(signedFilePath, binaryEnvelopeFile, symmetricAlgorithm, new X509Cert[]{this.cmbcCert}, this.session);
                }
                catch (Exception e) {
                    throw new DecryptKitException(1879113746, (Throwable)e);
                }
            }
            finally {
                this.deleteFile(signedFilePath);
            }
            logger.info("SignAndEncryptFile<<<<<<Finished");
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("SignAndEncryptFile<<<<<<Failure");
                buffer.append("\n binaryPlainFile: ");
                buffer.append(Debugger.dump(binaryPlainFile));
                buffer.append("\n binaryEnvelopeFile: ");
                buffer.append(Debugger.dump(binaryEnvelopeFile));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("SignAndEncryptFile<<<<<<Failure");
                buffer.append("\n binaryPlainFile: ");
                buffer.append(Debugger.dump(binaryPlainFile));
                buffer.append("\n binaryEnvelopeFile: ");
                buffer.append(Debugger.dump(binaryEnvelopeFile));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int DecryptAndVerifyFile(String binaryEnvelopeFile, String binaryPlainFile) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("DecryptAndVerifyFile>>>>>>Running");
            buffer.append("\n binaryPlainFile: ");
            buffer.append(Debugger.dump(binaryPlainFile));
            buffer.append("\n binaryEnvelopeFile: ");
            buffer.append(Debugger.dump(binaryEnvelopeFile));
            logger.info(buffer.toString());
        }
        try {
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (binaryEnvelopeFile == null) {
                throw new DecryptKitException(0x70011000);
            }
            if (binaryPlainFile == null) {
                throw new DecryptKitException(0x70011000);
            }
            String signedFilePath = "/tmp/SignAndEncryptFile/" + new File(binaryEnvelopeFile).getName() + UUID.randomUUID();
            try {
                try {
                    EnvelopeUtil.openEnvelopedFile(binaryEnvelopeFile, signedFilePath, this.privateKey, this.signedCert, this.session);
                }
                catch (Exception e) {
                    throw new DecryptKitException(1879113761, (Throwable)e);
                }
                try {
                    SignatureUtil2 engine = new SignatureUtil2();
                    boolean verifyResult = engine.p7VerifyFileAttach(signedFilePath, binaryPlainFile, this.session);
                    if (!verifyResult) {
                        throw new DecryptKitException(1879113732);
                    }
                    this.checkPeerSignedCert(engine.getSignerCert());
                }
                catch (DecryptKitException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DecryptKitException(1879113762, (Throwable)e);
                }
            }
            finally {
                this.deleteFile(signedFilePath);
            }
            logger.info("DecryptAndVerifyFile<<<<<<Finished");
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("DecryptAndVerifyFile<<<<<<Failure");
                buffer.append("\n binaryPlainFile: ");
                buffer.append(Debugger.dump(binaryPlainFile));
                buffer.append("\n binaryEnvelopeFile: ");
                buffer.append(Debugger.dump(binaryEnvelopeFile));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("DecryptAndVerifyFile<<<<<<Failure");
                buffer.append("\n binaryPlainFile: ");
                buffer.append(Debugger.dump(binaryPlainFile));
                buffer.append("\n binaryEnvelopeFile: ");
                buffer.append(Debugger.dump(binaryEnvelopeFile));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
        return 0;
    }
}

