/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import cfca.sadk.cmbc.tools.DecryptKitException;
import cfca.sadk.cmbc.tools.Signer;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.util.CertUtil;
import cmbc.cfca.util.KeyUtil;
import cmbc.cfca.x509.certificate.X509Cert;
import java.security.PrivateKey;

final class RSASigner
extends Signer {
    final Mechanism mechanism = new Mechanism("SHA256withRSAEncryption");
    final String keyType = "RSA";
    final String allowedExtensionName = "pfx";

    RSASigner() {
    }

    final PrivateKey loadPrivateKey(String myPrivateFile, String myPrivateFilePassword) throws DecryptKitException {
        try {
            return KeyUtil.getPrivateKeyFromPFX(myPrivateFile, myPrivateFilePassword);
        }
        catch (PKIException e) {
            throw new DecryptKitException(1879130113, (Throwable)e);
        }
    }

    final X509Cert loadCertificate(String myPrivateFile, String myPrivateFilePassword) throws DecryptKitException {
        try {
            return CertUtil.getCertFromPfx(myPrivateFile, myPrivateFilePassword);
        }
        catch (PKIException e) {
            throw new DecryptKitException(1879130114, (Throwable)e);
        }
    }

    final Mechanism getMechanism() {
        return this.mechanism;
    }

    final String getKeyType() {
        return "RSA";
    }

    final String getAllowedExtensionName() {
        return "pfx";
    }
}

