/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import cfca.sadk.cmbc.tools.DecryptKitException;
import cfca.sadk.cmbc.tools.Signer;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.util.CertUtil;
import cmbc.cfca.util.KeyUtil;
import cmbc.cfca.x509.certificate.X509Cert;
import java.security.PrivateKey;

final class SM2Signer
extends Signer {
    final Mechanism mechanism = new Mechanism("SM3withSM2");
    final String keyType = "SM2";
    final String allowedExtensionName = "sm2";

    SM2Signer() {
    }

    final PrivateKey loadPrivateKey(String myPrivateFile, String myPrivateFilePassword) throws DecryptKitException {
        try {
            return KeyUtil.getPrivateKeyFromSM2(myPrivateFile, myPrivateFilePassword);
        }
        catch (PKIException e) {
            throw new DecryptKitException(1879130113, (Throwable)e);
        }
    }

    final X509Cert loadCertificate(String myPrivateFile, String myPrivateFilePassword) throws DecryptKitException {
        try {
            return CertUtil.getCertFromSM2(myPrivateFile);
        }
        catch (PKIException e) {
            throw new DecryptKitException(1879130114, (Throwable)e);
        }
    }

    final Mechanism getMechanism() {
        return this.mechanism;
    }

    final String getKeyType() {
        return "SM2";
    }

    final String getAllowedExtensionName() {
        return "sm2";
    }
}

