/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.cmbc.tools.DecryptKitConfig;
import cfca.sadk.cmbc.tools.DecryptKitException;
import cfca.sadk.cmbc.tools.RSASigner;
import cfca.sadk.cmbc.tools.SM2Signer;
import cfca.sadk.cmbc.tools.SecurityKit;
import cfca.sadk.cmbc.tools.Signer;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Object;
import cmbc.cfca.org.bouncycastle.asn1.x509.Extension;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cmbc.cfca.org.bouncycastle.util.encoders.Hex;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.util.CertUtil;
import cmbc.cfca.util.EnvelopeUtil;
import cmbc.cfca.util.HashUtil;
import cmbc.cfca.util.SignatureUtil2;
import cmbc.cfca.util.cipher.lib.JCrypto;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.PrivateKey;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class SecurityKitImpl
implements SecurityKit {
    private static final Logger logger = LoggerFactory.getLogger(SecurityKitImpl.class);
    boolean initialized = false;
    boolean smxFlag = true;
    PrivateKey privateKey = null;
    X509Cert signedCert = null;
    X509Cert cmbcCert = null;
    Session session = null;
    ConcurrentHashMap<String, X509Cert> trustCMBCCerts = new ConcurrentHashMap();
    private String sessionType = "JSOFT_LIB";
    private final Object locked = new Object();
    private static final Mechanism mechanism = new Mechanism("SHA1");

    public final int setSessionType(String sessionType) throws DecryptKitException {
        if ("JNISOFT_LIB".equals(sessionType)) {
            sessionType = "JNISOFT_LIB";
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int Initialize(String myPrivateFile, String myPrivateFilePassword, String myCMBCCertFile) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Initialize>>>>>>Running");
            buffer.append("\n myPrivateFile: ");
            buffer.append(Debugger.dump(myPrivateFile));
            buffer.append("\n myCMBCCertFile: ");
            buffer.append(Debugger.dump(myCMBCCertFile));
            logger.info(buffer.toString());
        }
        try {
            Session session;
            if (this.initialized) {
                throw new DecryptKitException(1879113730);
            }
            try {
                JCrypto.getInstance().initialize(this.sessionType, null);
                session = JCrypto.getInstance().openSession(this.sessionType);
            }
            catch (PKIException e) {
                throw new DecryptKitException(1879113731, (Throwable)e);
            }
            X509Cert cmbcCert = this.LoadBCMCCertFrom(myCMBCCertFile);
            if (cmbcCert == null) {
                throw new DecryptKitException(1879130112);
            }
            this.checkPeerValidate(cmbcCert);
            boolean smxFlag = CertUtil.isSM2Cert(cmbcCert);
            Signer signer = null;
            signer = smxFlag ? new SM2Signer() : new RSASigner();
            boolean success = signer.load(myPrivateFile, myPrivateFilePassword);
            if (!success) {
                throw new DecryptKitException(1879134209);
            }
            this.checkLocalValidate(signer.signedCert);
            String trustCertID = this.buildTrustCertID(cmbcCert);
            ConcurrentHashMap<String, X509Cert> trustCerts = new ConcurrentHashMap<String, X509Cert>();
            trustCerts.put(trustCertID, cmbcCert);
            Object object = this.locked;
            synchronized (object) {
                this.session = session;
                this.smxFlag = smxFlag;
                this.privateKey = signer.privateKey;
                this.signedCert = signer.signedCert;
                this.cmbcCert = cmbcCert;
                this.trustCMBCCerts = trustCerts;
                this.initialized = true;
            }
            return 0;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Initialize<<<<<<Failure");
                buffer.append("\n myPrivateFile: ");
                buffer.append(Debugger.dump(myPrivateFile));
                buffer.append("\n myCMBCCertFile: ");
                buffer.append(Debugger.dump(myCMBCCertFile));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Initialize<<<<<<Failure");
                buffer.append("\n myPrivateFile: ");
                buffer.append(Debugger.dump(myPrivateFile));
                buffer.append("\n myCMBCCertFile: ");
                buffer.append(Debugger.dump(myCMBCCertFile));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    public final int Initialize(String myConfigFile) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Initialize>>>>>>Running");
            buffer.append("\n myConfigFile: ");
            buffer.append(Debugger.dump(myConfigFile));
            logger.info(buffer.toString());
        }
        try {
            DecryptKitConfig config = new DecryptKitConfig(myConfigFile);
            return this.Initialize(config.getPrivateFile(), config.getPrivateFilePassword(), config.getPeerCertFile());
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Initialize<<<<<<Failure");
                buffer.append("\n myConfigFile: ");
                buffer.append(Debugger.dump(myConfigFile));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Initialize<<<<<<Failure");
                buffer.append("\n myConfigFile: ");
                buffer.append(Debugger.dump(myConfigFile));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int upgrade(String myPrivateFile, String myPrivateFilePassword) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("upgrade>>>>>>Running");
            buffer.append("\n myPrivateFile: ");
            buffer.append(Debugger.dump(myPrivateFile));
            logger.info(buffer.toString());
        }
        try {
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            Signer signer = null;
            signer = this.smxFlag ? new SM2Signer() : new RSASigner();
            boolean success = signer.load(myPrivateFile, myPrivateFilePassword);
            if (!success) {
                throw new DecryptKitException(1879134209);
            }
            this.checkLocalValidate(signer.signedCert);
            Object object = this.locked;
            synchronized (object) {
                this.privateKey = signer.privateKey;
                this.signedCert = signer.signedCert;
            }
            return 0;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("upgrade<<<<<<Failure");
                buffer.append("\n myPrivateFile: ");
                buffer.append(Debugger.dump(myPrivateFile));
                logger.error(buffer.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("upgrade<<<<<<Failure");
                buffer.append("\n myPrivateFile: ");
                buffer.append(Debugger.dump(myPrivateFile));
                logger.error(buffer.toString());
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int upgrade(String myCMBCCertFile) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("upgrade>>>>>>Running");
            buffer.append("\n myCMBCCertFile: ");
            buffer.append(Debugger.dump(myCMBCCertFile));
            logger.info(buffer.toString());
        }
        try {
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            X509Cert cmbcCert = this.LoadBCMCCertFrom(myCMBCCertFile);
            if (cmbcCert == null) {
                throw new DecryptKitException(1879130112);
            }
            this.checkPeerValidate(cmbcCert);
            boolean smxFlag = CertUtil.isSM2Cert(cmbcCert);
            if (smxFlag != this.smxFlag) {
                throw new DecryptKitException(1879134208);
            }
            String trustCertID = this.buildTrustCertID(cmbcCert);
            if (this.trustCMBCCerts.size() > 1000) {
                throw new DecryptKitException(0x70010000, "trustCMBCCerts more than 1000");
            }
            this.trustCMBCCerts.put(trustCertID, cmbcCert);
            Object object = this.locked;
            synchronized (object) {
                this.cmbcCert = cmbcCert;
            }
            return 0;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("upgrade<<<<<<Failure");
                buffer.append("\n myCMBCCertFile: ");
                buffer.append(Debugger.dump(myCMBCCertFile));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("upgrade<<<<<<Failure");
                buffer.append("\n myCMBCCertFile: ");
                buffer.append(Debugger.dump(myCMBCCertFile));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    final X509Cert LoadBCMCCertFrom(String myCMBCCertFile) throws DecryptKitException {
        X509Cert myCMBCCert;
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("LoadBCMCCertFrom>>>>>>Running");
            buffer.append("\n myCMBCCertFile: ");
            buffer.append(Debugger.dump(myCMBCCertFile));
            logger.info(buffer.toString());
        }
        try {
            if (myCMBCCertFile == null) {
                throw new DecryptKitException(1879117827);
            }
            File cmbcCertFile = new File(myCMBCCertFile);
            if (!cmbcCertFile.exists()) {
                throw new DecryptKitException(1879121922);
            }
            String extensionName = Signer.getExtensionFilename(cmbcCertFile.getName());
            if (!"cer".equals(extensionName)) {
                throw new DecryptKitException(1879126018);
            }
            myCMBCCert = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(cmbcCertFile);
                myCMBCCert = new X509Cert(fis);
            }
            catch (FileNotFoundException e) {
                throw new DecryptKitException(1879121922, (Throwable)e);
            }
            catch (PKIException e) {
                throw new DecryptKitException(1879130112, (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("LoadBCMCCertFrom<<<<<<Failure");
                buffer.append("\n myCMBCCertFile: ");
                buffer.append(Debugger.dump(myCMBCCertFile));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("LoadBCMCCertFrom<<<<<<Failure");
                buffer.append("\n myCMBCCertFile: ");
                buffer.append(Debugger.dump(myCMBCCertFile));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("LoadBCMCCertFrom<<<<<<Finished");
            buffer.append("\n myCMBCCert: ");
            buffer.append(Debugger.dump(myCMBCCert));
            logger.info(buffer.toString());
        }
        return myCMBCCert;
    }

    final void checkPeerSignedCert(X509Cert cert) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("checkPeerSignedCert>>>>>>Running");
            buffer.append("\n X509Cert: ");
            buffer.append(Debugger.dump(cert));
            logger.info(buffer.toString());
        }
        try {
            if (cert == null) {
                throw new DecryptKitException(0x70017007, "missing cert");
            }
            Date nowTime = new Date();
            if (cert.getNotAfter().before(nowTime)) {
                throw new DecryptKitException(1879142402, this.validTime(cert));
            }
            if (nowTime.before(cert.getNotBefore())) {
                throw new DecryptKitException(0x70017001, this.validTime(cert));
            }
            String certID = this.buildTrustCertID(cert);
            if (!this.trustCMBCCerts.containsKey(certID)) {
                throw new DecryptKitException(1879142408, this.validTime(cert));
            }
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkPeerSignedCert<<<<<<Failure");
                buffer.append("\n X509Cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkPeerSignedCert<<<<<<Failure");
                buffer.append("\n X509Cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    final void checkLocalValidate(X509Cert cert) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("checkLocalValidate>>>>>>Running");
            buffer.append("\n X509Cert: ");
            buffer.append(Debugger.dump(cert));
            logger.info(buffer.toString());
        }
        try {
            if (cert != null) {
                Date nowTime = new Date();
                if (cert.getNotAfter().before(nowTime)) {
                    throw new DecryptKitException(1879142404, this.validTime(cert));
                }
                if (nowTime.before(cert.getNotBefore())) {
                    throw new DecryptKitException(1879142403, this.validTime(cert));
                }
            }
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkLocalValidate<<<<<<Failure");
                buffer.append("\n X509Cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkLocalValidate<<<<<<Failure");
                buffer.append("\n X509Cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    final void checkPeerValidate(X509Cert cert) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("checkPeerValidate>>>>>>Running");
            buffer.append("\n X509Cert: ");
            buffer.append(Debugger.dump(cert));
            logger.info(buffer.toString());
        }
        try {
            if (cert != null) {
                Date nowTime = new Date();
                if (cert.getNotAfter().before(nowTime)) {
                    throw new DecryptKitException(1879142406, this.validTime(cert));
                }
                if (nowTime.before(cert.getNotBefore())) {
                    throw new DecryptKitException(1879142405, this.validTime(cert));
                }
            }
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkPeerValidate<<<<<<Failure");
                buffer.append("\n X509Cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("checkPeerValidate<<<<<<Failure");
                buffer.append("\n X509Cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    final String validTime(X509Cert cert) {
        return String.format("<<%1$tY-%1$tm-%1$te %1$tT -- %2$tY-%2$tm-%2$te %2$tT>>", cert.getNotBefore(), cert.getNotAfter());
    }

    final void deleteFile(String filename) {
        if (filename != null) {
            try {
                File file = new File(filename);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final byte[] EnvelopeEncryptMessage(byte[] binaryPlainMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("EnvelopeEncryptMessage>>>>>>Running");
            buffer.append("\n binaryPlainMessage: ");
            buffer.append(Debugger.dump(binaryPlainMessage));
            logger.info(buffer.toString());
        }
        try {
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (binaryPlainMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            String symmetricAlgorithm = null;
            symmetricAlgorithm = this.smxFlag ? "SM4/CBC/PKCS7Padding" : "DESede/CBC/PKCS7Padding";
            if (logger.isInfoEnabled()) {
                logger.info("EnvelopeEncryptMessage<<<<<<smxFlag: " + this.smxFlag);
            }
            byte[] base64EnvelopedData = null;
            try {
                base64EnvelopedData = EnvelopeUtil.envelopeMessage(binaryPlainMessage, symmetricAlgorithm, new X509Cert[]{this.cmbcCert}, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113746, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("EnvelopeEncryptMessage<<<<<<Finished: base64EnvelopedData: " + Debugger.dumpBase64(base64EnvelopedData));
            }
            return base64EnvelopedData;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("EnvelopeEncryptMessage<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("EnvelopeEncryptMessage<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    public final byte[] EnvelopeDecryptMessage(byte[] base64EnvelopeMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("EnvelopeDecryptMessage>>>>>>Running");
            buffer.append("\n base64EnvelopeMessage: ");
            buffer.append(Debugger.dumpBase64(base64EnvelopeMessage));
            logger.info(buffer.toString());
        }
        try {
            byte[] binaryPlainMessage;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (base64EnvelopeMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            try {
                binaryPlainMessage = EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage, this.privateKey, this.signedCert, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113761, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("EnvelopeDecryptMessage<<<<<<binaryPlainMessage: " + Debugger.dump(binaryPlainMessage));
            }
            return binaryPlainMessage;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("EnvelopeDecryptMessage<<<<<<Failure");
                buffer.append("\n base64EnvelopeMessage: ");
                buffer.append(Debugger.dumpBase64(base64EnvelopeMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("EnvelopeDecryptMessage<<<<<<Failure");
                buffer.append("\n base64EnvelopeMessage: ");
                buffer.append(Debugger.dumpBase64(base64EnvelopeMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    final byte[] P7AttachMessageSign(byte[] binaryPlainMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("P7AttachMessageSign>>>>>>Running");
            buffer.append("\n binaryPlainMessage: ");
            buffer.append(Debugger.dump(binaryPlainMessage));
            logger.info(buffer.toString());
        }
        try {
            byte[] base64SignedMessage;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (binaryPlainMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            SignatureUtil2 engine = new SignatureUtil2();
            String mechanism = null;
            mechanism = this.smxFlag ? "SM3withSM2" : "SHA256withRSAEncryption";
            if (logger.isInfoEnabled()) {
                logger.info("P7AttachMessageSign<<<<<<smxFlag: " + this.smxFlag);
            }
            try {
                base64SignedMessage = engine.p7SignMessageAttach(mechanism, binaryPlainMessage, this.privateKey, this.signedCert, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(0x70010011, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("P7AttachMessageSign<<<<<<base64SignedMessage: " + Debugger.dumpBase64(base64SignedMessage));
            }
            return base64SignedMessage;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("P7AttachMessageSign<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("P7AttachMessageSign<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    final byte[] P7AttachMessageVerify(byte[] base64SignedMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("P7AttachMessageVerify>>>>>>Running");
            buffer.append("\n base64SignedMessage: ");
            buffer.append(Debugger.dumpBase64(base64SignedMessage));
            logger.info(buffer.toString());
        }
        try {
            SignatureUtil2 engine;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (base64SignedMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            try {
                engine = new SignatureUtil2();
                boolean verifyResult = engine.p7VerifyMessageAttach(base64SignedMessage, this.session);
                if (!verifyResult) {
                    throw new DecryptKitException(1879113732);
                }
                this.checkPeerSignedCert(engine.getSignerCert());
            }
            catch (DecryptKitException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113762, (Throwable)e);
            }
            byte[] binaryPlainMessage = engine.getSourceData();
            if (logger.isInfoEnabled()) {
                logger.info("P7AttachMessageVerify<<<<<<Finished: binaryPlainMessage=" + Debugger.dump(binaryPlainMessage));
            }
            return binaryPlainMessage;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("P7AttachMessageVerify<<<<<<Failure");
                buffer.append("\n base64SignedMessage: ");
                buffer.append(Debugger.dumpBase64(base64SignedMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("P7AttachMessageVerify<<<<<<Failure");
                buffer.append("\n base64SignedMessage: ");
                buffer.append(Debugger.dumpBase64(base64SignedMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    public final byte[] P7DetachMessageSign(byte[] binaryPlainMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("P7DetachMessageSign>>>>>>Running");
            buffer.append("\n binaryPlainMessage: ");
            buffer.append(Debugger.dump(binaryPlainMessage));
            logger.info(buffer.toString());
        }
        try {
            byte[] base64SignedMessage;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (binaryPlainMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            SignatureUtil2 engine = new SignatureUtil2();
            String mechanism = null;
            mechanism = this.smxFlag ? "SM3withSM2" : "SHA256withRSAEncryption";
            if (logger.isInfoEnabled()) {
                logger.info("P7DetachMessageSign<<<<<<smxFlag: " + this.smxFlag);
            }
            try {
                base64SignedMessage = engine.p7SignMessageDetach(mechanism, binaryPlainMessage, this.privateKey, this.signedCert, this.session);
            }
            catch (Exception e) {
                throw new DecryptKitException(0x70010011, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("P7DetachMessageSign<<<<<<base64SignedMessage: " + Debugger.dumpBase64(base64SignedMessage));
            }
            return base64SignedMessage;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("P7DetachMessageSign<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("P7DetachMessageSign<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    public boolean P7DetachMessageVerify(byte[] binaryPlainMessage, byte[] base64SignedMessage) throws DecryptKitException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("P7DetachMessageVerify>>>>>>Running");
            buffer.append("\n binaryPlainMessage: ");
            buffer.append(Debugger.dump(binaryPlainMessage));
            buffer.append("\n base64SignedMessage: ");
            buffer.append(Debugger.dumpBase64(base64SignedMessage));
            logger.info(buffer.toString());
        }
        try {
            boolean verifyResult;
            if (!this.initialized) {
                throw new DecryptKitException(0x70010001);
            }
            if (binaryPlainMessage == null) {
                throw new DecryptKitException(1879117826);
            }
            if (base64SignedMessage == null) {
                throw new DecryptKitException(0x70011000);
            }
            try {
                SignatureUtil2 engine = new SignatureUtil2();
                verifyResult = engine.p7VerifyMessageDetach(binaryPlainMessage, base64SignedMessage, this.session);
                if (!verifyResult) {
                    throw new DecryptKitException(1879113732);
                }
                this.checkPeerSignedCert(engine.getSignerCert());
            }
            catch (DecryptKitException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DecryptKitException(1879113762, (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("p7VerifyMessageDetach<<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (DecryptKitException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("p7VerifyMessageDetach<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                buffer.append("\n base64SignedMessage: ");
                buffer.append(Debugger.dumpBase64(base64SignedMessage));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("p7VerifyMessageDetach<<<<<<Failure");
                buffer.append("\n binaryPlainMessage: ");
                buffer.append(Debugger.dump(binaryPlainMessage));
                buffer.append("\n base64SignedMessage: ");
                buffer.append(Debugger.dumpBase64(base64SignedMessage));
                logger.error(buffer.toString(), e);
            }
            throw new DecryptKitException(0x70010000, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int Uninitialize() throws DecryptKitException {
        Object buffer;
        if (logger.isInfoEnabled()) {
            buffer = new StringBuilder();
            ((StringBuilder)buffer).append("Uninitialize>>>>>>Running");
            logger.info(((StringBuilder)buffer).toString());
        }
        buffer = this.locked;
        synchronized (buffer) {
            this.initialized = false;
            this.smxFlag = true;
            this.privateKey = null;
            this.signedCert = null;
            this.cmbcCert = null;
            this.trustCMBCCerts.clear();
        }
        if (logger.isInfoEnabled()) {
            buffer = new StringBuilder();
            ((StringBuilder)buffer).append("Uninitialize<<<<<<Finished");
            logger.info(((StringBuilder)buffer).toString());
        }
        return 0;
    }

    private final String buildTrustCertID(X509Cert cert) throws DecryptKitException {
        if (cert == null) {
            throw new DecryptKitException(0x70010000, "missing cert");
        }
        byte[] hash = null;
        try {
            ASN1Object extension = cert.getExtensionData(Extension.subjectKeyIdentifier);
            if (extension != null) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(extension);
                hash = subjectKeyIdentifier.getKeyIdentifier();
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.debug("buildCertID::<<<<<<Failure", e);
            }
            hash = null;
        }
        if (hash == null) {
            try {
                hash = HashUtil.rsaHashMessage(cert.getPublicKeyData(), mechanism);
            }
            catch (PKIException e) {
                throw new DecryptKitException(0x70010000, (Throwable)e);
            }
        }
        return new String(Hex.encode(hash)).toLowerCase();
    }
}

