/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools.php;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.cmbc.tools.CMBCDecryptKit;
import cfca.sadk.cmbc.tools.DecryptKit;
import cfca.sadk.cmbc.tools.DecryptKitException;

public final class PHPDecryptKit {
    private static final Logger logger = LoggerFactory.getLogger(PHPDecryptKit.class);
    static final DecryptKit decryptKit = new CMBCDecryptKit();

    private PHPDecryptKit() {
    }

    public static final int Initialize(String myPrivateFile, String myPrivateFilePassword, String myCMBCCertFile) {
        try {
            return decryptKit.Initialize(myPrivateFile, myPrivateFilePassword, myCMBCCertFile);
        }
        catch (DecryptKitException e) {
            logger.error("Initialize Failure", e);
            return e.getErrorCode();
        }
        catch (Exception e) {
            logger.error("Initialize Failure", e);
            return 0x70010000;
        }
    }

    public static final int Initialize(String myConfigFile) {
        try {
            return decryptKit.Initialize(myConfigFile);
        }
        catch (DecryptKitException e) {
            logger.error("Initialize Failure", e);
            return e.getErrorCode();
        }
        catch (Exception e) {
            logger.error("Initialize Failure", e);
            return 0x70010000;
        }
    }

    public static final int Uninitialize() {
        try {
            return decryptKit.Uninitialize();
        }
        catch (DecryptKitException e) {
            logger.error("Uninitialize Failure", e);
            return e.getErrorCode();
        }
        catch (Exception e) {
            logger.error("Uninitialize Failure", e);
            return 0x70010000;
        }
    }

    public static final String SignAndEncryptMessage(String base64PlainMessage) {
        try {
            return decryptKit.SignAndEncryptMessage(base64PlainMessage);
        }
        catch (DecryptKitException e) {
            logger.error("SignAndEncryptMessage Failure", e);
            return String.format("$ERRCODE=0x%h, ERRHINT=%s", e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("SignAndEncryptMessage Failure", e);
            return String.format("$ERRCODE=0x%h, ERRHINT=%s", 0x70010000, e.getMessage());
        }
    }

    public static final String DecryptAndVerifyMessage(String base64EnvelopeMessage) {
        try {
            return decryptKit.DecryptAndVerifyMessage(base64EnvelopeMessage);
        }
        catch (DecryptKitException e) {
            String returnText = String.format("$ERRCODE=0x%h, ERRHINT=%s", e.getErrorCode(), e.getMessage());
            if (logger.isErrorEnabled()) {
                logger.error("DecryptAndVerifyMessage Failure: returnText>>" + returnText, e);
            }
            return returnText;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("DecryptAndVerifyMessage Failure", e);
            }
            return String.format("$ERRCODE=0x%h, ERRHINT=%s", 0x70010000, e.getMessage());
        }
    }
}

