/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.signature;

import cfca.sm.algorithm.SM3Digest;
import cfca.sm2.signature.SM2PublicKey;
import cfca.util.cipher.lib.JNISoftLib;
import cfca.util.cipher.lib.Session;
import cryptokit.SMJNI.SM3JNI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.security.PublicKey;

public final class SM2HashUtil {
    private static final int bufferSize = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashFile(boolean withZ, byte[] userId, String sourceFilePath, long startPos, long dataLength, PublicKey pubKey, String generate_sourceFilePath, Session session) throws Exception {
        RandomAccessFile inFile = null;
        FileOutputStream ouFile = null;
        try {
            int rLength;
            SM3JNI engine = null;
            SM3Digest digest = null;
            if (session instanceof JNISoftLib) {
                engine = new SM3JNI();
            } else {
                digest = new SM3Digest();
            }
            SM2HashUtil.updateZ(withZ, engine, digest, pubKey);
            byte[] hash = new byte[32];
            inFile = new RandomAccessFile(new File(sourceFilePath), "r");
            if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                ouFile = new FileOutputStream(generate_sourceFilePath);
            }
            inFile.seek(startPos);
            byte[] buffer = new byte[16384];
            long remainLength = dataLength;
            int n = rLength = remainLength < (long)buffer.length ? (int)remainLength : buffer.length;
            while ((rLength = inFile.read(buffer, 0, rLength)) != -1) {
                SM2HashUtil.update(engine, digest, buffer, 0, rLength);
                if (ouFile != null) {
                    ouFile.write(buffer, 0, rLength);
                }
                if ((remainLength -= (long)rLength) <= 0L) break;
                rLength = remainLength > (long)buffer.length ? buffer.length : (int)remainLength;
            }
            SM2HashUtil.doFinal(engine, digest, hash);
            byte[] byArray = hash;
            return byArray;
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
            if (ouFile != null) {
                ouFile.close();
            }
        }
    }

    private static void updateZ(boolean withZ, SM3JNI jniHash, SM3Digest jvmHash, PublicKey pubKey) throws Exception {
        if (withZ) {
            if (pubKey == null) {
                throw new IllegalArgumentException("null not allowed for pubKey withZ");
            }
            byte[] value = ((SM2PublicKey)pubKey).getDefaultZ();
            SM2HashUtil.update(jniHash, jvmHash, value, 0, value.length);
        }
    }

    private static void update(SM3JNI jniHash, SM3Digest jvmHash, byte[] data, int offset, int length) throws Exception {
        if (data == null || data.length < offset) {
            return;
        }
        if (jniHash != null) {
            byte[] buffer = new byte[length];
            System.arraycopy(data, offset, buffer, 0, buffer.length);
            jniHash.update(buffer);
        } else {
            jvmHash.update(data, offset, length);
        }
    }

    private static void doFinal(SM3JNI jniHash, SM3Digest jvmHash, byte[] hash) throws Exception {
        if (jniHash != null) {
            jniHash.doFinal(new byte[0], hash);
        } else {
            jvmHash.doFinal(hash, 0);
        }
    }
}

