/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.signature;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.org.bouncycastle.asn1.sec.ECPrivateKey;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x9.X962Parameters;
import cfca.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk32.org.bouncycastle.util.BigIntegers;
import cfca.sm2.signature.SM2PublicKey;
import java.math.BigInteger;
import java.security.PrivateKey;

public final class SM2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 5602980457820266873L;
    private BigInteger d = null;
    private byte[] dBytes = null;
    private SM2PublicKey pubKey = null;

    public static SM2PrivateKey getInstance(byte[] encoded) {
        return new SM2PrivateKey(encoded);
    }

    public SM2PrivateKey(byte[] encoded) {
        BigInteger d;
        if (encoded == null) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        byte[] pubX = null;
        byte[] pubY = null;
        switch (encoded.length) {
            case 32: {
                d = new BigInteger(1, encoded);
                break;
            }
            case 96: {
                d = new BigInteger(1, this.copyOfRange(encoded, 0, 32));
                pubX = this.copyOfRange(encoded, 32, 32);
                pubY = this.copyOfRange(encoded, 64, 32);
                break;
            }
            default: {
                try {
                    AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)new X962Parameters(DERNull.INSTANCE));
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance(encoded);
                    if (!aid.equals(info.getPrivateKeyAlgorithm())) {
                        throw new SecurityException("encoded not valid");
                    }
                    ECPrivateKey key = ECPrivateKey.getInstance(info.parsePrivateKey());
                    d = key.getKey();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.d = d;
        this.dBytes = BigIntegers.asUnsignedByteArray(32, d);
        this.pubKey = pubX == null || pubY == null ? SM2PrivateKey.buildPublicKey(d) : new SM2PublicKey(pubX, pubY);
    }

    public SM2PrivateKey(ECPrivateKeyParameters priParam) {
        if (priParam == null) {
            throw new IllegalArgumentException("null not allowed for priParam");
        }
        this.d = priParam.getD();
        this.dBytes = BigIntegers.asUnsignedByteArray(32, this.d);
        this.pubKey = SM2PrivateKey.buildPublicKey(this.d);
    }

    public byte[] getEncoded() {
        X962Parameters params = new X962Parameters(DERNull.INSTANCE);
        PrivateKeyInfo info = null;
        ECPrivateKey keyStructure = new ECPrivateKey(this.getD(), params);
        try {
            info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), keyStructure);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new SecurityException("getEncoded Failure for SM2PrivateKey");
        }
    }

    public BigInteger getD() {
        return this.d;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getD_Bytes() {
        return this.dBytes;
    }

    public void setSM2PublicKey(SM2PublicKey pubKey) {
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.pubKey;
    }

    private static SM2PublicKey buildPublicKey(BigInteger d) {
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new SM2PublicKey(new ECPublicKeyParameters(Q, params));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
        result = 31 * result + (this.pubKey == null ? 0 : this.pubKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SM2PrivateKey other = (SM2PrivateKey)obj;
        if (this.d == null ? other.d != null : !this.d.equals(other.d)) {
            return false;
        }
        return !(this.pubKey == null ? other.pubKey != null : !this.pubKey.equals(other.pubKey));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2PrivateKey [d=0x");
        buffer.append(this.d.toString(16));
        buffer.append("]");
        return buffer.toString();
    }

    private final byte[] copyOfRange(byte[] data, int from, int length) {
        byte[] value = new byte[length];
        System.arraycopy(data, from, value, 0, value.length);
        return value;
    }
}

