/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.signature;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk32.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.util.Enumeration;

public class SM2SignerInfox
extends ASN1Object {
    private ASN1Integer version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1Integer encryptedDigestR;
    private ASN1Integer encryptedDigestS;
    private ASN1Set unauthenticatedAttributes;
    private byte[] signatureAsBytes;

    public SM2SignerInfox(ASN1Integer version, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digAlgorithm, ASN1Set authenticatedAttributes, AlgorithmIdentifier digEncryptionAlgorithm, ASN1Integer encryptedDigestR, ASN1Integer encryptedDigestS, ASN1Set unauthenticatedAttributes) {
        this.version = version;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digAlgorithm = digAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digEncryptionAlgorithm = digEncryptionAlgorithm;
        this.encryptedDigestR = encryptedDigestR;
        this.encryptedDigestS = encryptedDigestS;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public SM2SignerInfox(ASN1Sequence seq) {
        this.decoded(seq);
    }

    private final void decoded(ASN1Sequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("null not allowed for seq");
        }
        Enumeration e = seq.getObjects();
        this.version = (ASN1Integer)e.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(e.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        Object obj = e.nextElement();
        if (obj instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)obj, false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(obj);
        }
        obj = e.nextElement();
        if (obj instanceof ASN1Sequence) {
            ASN1Sequence rsSequnence = (ASN1Sequence)obj;
            Enumeration eRS = rsSequnence.getObjects();
            this.encryptedDigestR = ASN1Integer.getInstance(eRS.nextElement());
            this.encryptedDigestS = ASN1Integer.getInstance(eRS.nextElement());
        } else if (obj instanceof ASN1OctetString) {
            ASN1OctetString str = (ASN1OctetString)obj;
            this.signatureAsBytes = str.getOctets();
            if (128 != this.signatureAsBytes.length) {
                ASN1Sequence rsSequnence = ASN1Sequence.getInstance(this.signatureAsBytes);
                Enumeration eRS = rsSequnence.getObjects();
                this.encryptedDigestR = ASN1Integer.getInstance(eRS.nextElement());
                this.encryptedDigestS = ASN1Integer.getInstance(eRS.nextElement());
            }
        } else {
            this.encryptedDigestR = (ASN1Integer)obj;
            this.encryptedDigestS = (ASN1Integer)e.nextElement();
        }
        if (this.signatureAsBytes == null) {
            this.signatureAsBytes = new byte[64];
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, this.encryptedDigestR.getPositiveValue()), 0, this.signatureAsBytes, 0, 32);
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, this.encryptedDigestS.getPositiveValue()), 0, this.signatureAsBytes, 32, 32);
        }
        this.unauthenticatedAttributes = e.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)e.nextElement(), false) : null;
    }

    public final ASN1Integer getVersion() {
        return this.version;
    }

    public final IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public final ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public final AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public final ASN1Integer getEncryptedDigestR() {
        return this.encryptedDigestR;
    }

    public final ASN1Integer getEncryptedDigestS() {
        return this.encryptedDigestS;
    }

    public final byte[] getSignatureAsBytes() {
        return this.signatureAsBytes;
    }

    public final AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public final ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public final ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.issuerAndSerialNumber);
        v.add(this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            v.add(new DERTaggedObject(false, 0, this.authenticatedAttributes));
        }
        v.add(this.digEncryptionAlgorithm);
        if (this.isNewFormat()) {
            ASN1EncodableVector rsV = new ASN1EncodableVector();
            rsV.add(this.encryptedDigestR);
            rsV.add(this.encryptedDigestS);
            try {
                v.add(new DEROctetString(new DERSequence(rsV)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            v.add(this.encryptedDigestR);
            v.add(this.encryptedDigestS);
        }
        if (this.unauthenticatedAttributes != null) {
            v.add(new DERTaggedObject(false, 1, this.unauthenticatedAttributes));
        }
        return new DERSequence(v);
    }

    boolean isNewFormat() {
        return false;
    }
}

