/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2rsa.common;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.PKCS7SignFileParser;
import cfca.internal.tool.BigIntegerUtil;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.BERSet;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.rsa.signature.RSASignUtil;
import cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk32.signature.sm2.SM2PackageUtil;
import cfca.sm2.signature.SM2HashUtil;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2.signature.SM2SignerInfo;
import cfca.sm2.signature.SM2SignerInfo2;
import cfca.sm2.signature.SM2SignerInfox;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCS7AttachSourceFile;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.cipher.lib.BCSoftLib;
import cfca.util.cipher.lib.JNISoftLib;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;

public class PKCS7SignedFile {
    static final Logger logger = LoggerFactory.getLogger(PKCS7SignedFile.class);
    private String digestAlgorithm;
    private byte[] signature;
    private byte[] sourceData;
    private X509Cert signerCert;
    private final Session session;

    public PKCS7SignedFile(Session session) {
        this.session = session == null ? new BCSoftLib() : session;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSignerCert::>>>>>>Running");
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            buffer.append("\n issuerAndSN: ");
            buffer.append(Debugger.dump(issuerAndSN));
            logger.debug(buffer.toString());
        }
        try {
            if (certs == null) {
                throw new PKIException("null not allowed for certs");
            }
            if (issuerAndSN == null) {
                throw new PKIException("null not allowed for issuerAndSN");
            }
            String issuer = issuerAndSN.getName().toString();
            BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
            X500Name certIssuer = null;
            BigInteger certSN = null;
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i] == null) continue;
                certIssuer = certs[i].getIssuerX500Name();
                certSN = certs[i].getSerialNumber();
                if (!certIssuer.toString().equals(issuer) || certSN.compareTo(sn) != 0) continue;
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getSignerCert::<<<<<<Finished");
                    buffer.append("\n match cert: ");
                    buffer.append(Debugger.dump(certs[i]));
                    logger.debug(buffer.toString());
                }
                return certs[i];
            }
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCert::<<<<<<NO NOT FIND SignerCert");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                buffer.append("\n issuerAndSN: ");
                buffer.append(Debugger.dump(issuerAndSN));
                logger.error(buffer.toString());
            }
            return null;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCert::<<<<<<Failure");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                buffer.append("\n issuerAndSN: ");
                buffer.append(Debugger.dump(issuerAndSN));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCert::<<<<<<Failure");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                buffer.append("\n issuerAndSN: ");
                buffer.append(Debugger.dump(issuerAndSN));
                logger.error(buffer.toString(), e);
            }
            throw new PKIException(e);
        }
    }

    public final boolean verifyP7SignedFile(String signFile, String saveSrcFilePath) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyP7SignedFile>>>>>>Running");
            buffer.append("\n signFile: ");
            buffer.append(Debugger.dump(signFile));
            buffer.append("\n saveSrcFilePath: ");
            buffer.append(Debugger.dump(saveSrcFilePath));
            logger.debug(buffer.toString());
        }
        if (signFile == null) {
            logger.error("verifyP7SignedFile<<<<<<Failure: null not allowed for signFile");
            throw new IllegalArgumentException("null not allowed for signFile");
        }
        try {
            PKCS7SignFileParser parser = new PKCS7SignFileParser(new File(signFile));
            parser.parser();
            logger.debug("verifyP7SignedFile::::::Parser Okay");
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert cert = new X509Cert(Certificate.getInstance(certSet.getObjectAt(0)));
            if (cert.isSM2Cert()) {
                logger.debug("verifyP7SignedFile::::::verifySM2P7SignedFile");
                return this.verifySM2P7SignedFile(signFile, saveSrcFilePath, true, null, parser);
            }
            if (cert.isRSACert()) {
                logger.debug("verifyP7SignedFile:::::verifyRSAP7SignedFile");
                return this.verifyRSAP7SignedFile(signFile, saveSrcFilePath, parser);
            }
            throw new SecurityException("Invalid signCert[RSA/SM2]");
        }
        catch (Exception e) {
            logger.error("verifyP7SignedFile<<<<<<Failure", e);
            throw e;
        }
    }

    private boolean verifySM2P7SignedFile(String signFile, String saveSrcFilePath, boolean ifZValue, byte[] userId, PKCS7SignFileParser parser) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySM2P7SignedFile>>>>>>Running");
            buffer.append("\n signFile: ");
            buffer.append(Debugger.dump(signFile));
            buffer.append("\n saveSrcFilePath: ");
            buffer.append(Debugger.dump(saveSrcFilePath));
            buffer.append("\n ifZValue: " + ifZValue);
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            logger.debug(buffer.toString());
        }
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                logger.debug("verifySM2P7SignedFile::::::ASN1Node[sourceData]: size==1");
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            } else {
                logger.debug("verifySM2P7SignedFile::::::ASN1Node[sourceData]: size!=1");
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                boolean verifyResult;
                X509Cert signerCert;
                if (this.isNewFormat()) {
                    logger.debug("verifySM2P7SignedFile::::::isNewFormat=True");
                    signerInfo = SM2SignerInfo2.getInstance(signerEnumer.nextElement());
                } else {
                    logger.debug("verifySM2P7SignedFile::::::isNewFormat=False");
                    signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                }
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                this.signerCert = signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySM2P7SignedFile<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                this.digestAlgorithm = "SM3";
                this.signature = signature;
                this.sourceData = "source file is too big, will not display,please see the sourceFilePath attribute".getBytes("UTF8");
                byte[] hash = null;
                long valueStartPos = sourceData_node.valueStartPos;
                long valueLength = sourceData_node.valueLength;
                if (ifZValue) {
                    logger.debug("verifySM2P7SignedFile::::::ifZValue=True");
                    hash = SM2HashUtil.hashFile(true, userId, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, pubKey, saveSrcFilePath, this.session);
                } else {
                    logger.debug("verifySM2P7SignedFile::::::ifZValue=False");
                    hash = SM2HashUtil.hashFile(false, null, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, null, saveSrcFilePath, this.session);
                }
                if (this.session instanceof JNISoftLib) {
                    logger.debug("verifySM2P7SignedFile::::::verifyByJNI Running");
                    SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                    byte[] pubX = sm2PubKey.getPubX();
                    byte[] pubY = sm2PubKey.getPubY();
                    verifyResult = SM2PackageUtil.verifyByJNI(hash, signature, pubX, pubY);
                    logger.debug("verifySM2P7SignedFile::::::verifyByJNI Finished");
                } else {
                    logger.debug("verifySM2P7SignedFile::::::verifyByBC Running");
                    verifyResult = SM2PackageUtil.verifyByBC(hash, signature, pubKey);
                    logger.debug("verifySM2P7SignedFile::::::verifyByBC Finished");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2P7SignedFile<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySM2P7SignedFile<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySM2P7SignedFile<<<<<<Failure", e);
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private boolean verifyRSAP7SignedFile(String signFile, String saveSrcFilePath, PKCS7SignFileParser parser) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyRSAP7SignedFile>>>>>>Running");
            buffer.append("\n signFile: ");
            buffer.append(Debugger.dump(signFile));
            buffer.append("\n saveSrcFilePath: ");
            buffer.append(Debugger.dump(saveSrcFilePath));
            logger.debug(buffer.toString());
        }
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                logger.debug("verifyRSAP7SignedFile::::::ASN1Node[sourceData]: size==1");
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            } else {
                logger.debug("verifyRSAP7SignedFile::::::ASN1Node[sourceData]: size!=1");
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                String signM;
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifyRSAP7SignedFile<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                this.signerCert = signerCert;
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifyRSAP7SignedFile<<<<<<Failure: DO NOT SUPPORT DigestEncryptionAlgorithm");
                        buffer.append("\n encryptionId: ");
                        buffer.append(Debugger.dump(encryptionId));
                        buffer.append("\n Valid DigestEncryptionAlgorithm : ");
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.rsaEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.md5WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha1WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha256WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha512WithRSAEncryption));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                this.digestAlgorithm = signM = RSASignUtil.GetDigestAlgorithm(digestId);
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                this.signature = signature;
                this.sourceData = "source file is too big, will not display".getBytes("UTF8");
                if (logger.isDebugEnabled()) {
                    logger.debug("verifyRSAP7SignedFile::::::verifySignFile Running signature=" + Debugger.dump(signature));
                }
                boolean verifyResult = RSASignUtil.verifySignFile(signM, pubKey, sourceData_node.f.getAbsolutePath(), sourceData_node.valueStartPos, sourceData_node.valueLength, signature, saveSrcFilePath, this.session);
                logger.debug("verifyRSAP7SignedFile::::::verifySignFile Finished");
                if (logger.isDebugEnabled()) {
                    logger.debug("verifyRSAP7SignedFile<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifyRSAP7SignedFile<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifyRSAP7SignedFile<<<<<<Failure", e);
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public final void packageRSASignedFile(String contentType, String sourceFile, String signFile, byte[] signature, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        StringBuffer buffer;
        if (logger.isDebugEnabled()) {
            buffer = new StringBuffer();
            buffer.append("packageRSASignedFile>>>>>>Running");
            buffer.append("\n contentType: " + contentType);
            buffer.append("\n sourceFile: ");
            buffer.append(Debugger.dump(sourceFile));
            buffer.append("\n signFile: ");
            buffer.append(Debugger.dump(signFile));
            buffer.append("\n signature: ");
            buffer.append(Debugger.dump(signature));
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        if (certs == null || certs.length == 0) {
            if (logger.isErrorEnabled()) {
                buffer = new StringBuffer();
                buffer.append("packageRSASignedFile<<<<<<Failure: Required certs");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                logger.error(buffer.toString());
            }
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        try {
            DEROctetString encryptedData = new DEROctetString(signature);
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)new DERNull());
            AlgorithmIdentifier digestAlgIdentifier = null;
            String digestAlgorithm = mechanism.getMechanismType();
            if (digestAlgorithm.equals("MD5withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, (ASN1Encodable)new DERNull());
            } else if (digestAlgorithm.equals("SHA1withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, (ASN1Encodable)new DERNull());
            } else if (digestAlgorithm.equals("SHA256withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, (ASN1Encodable)new DERNull());
            } else if (digestAlgorithm.equals("SHA512withRSA")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, (ASN1Encodable)new DERNull());
            }
            SignerInfo signerInfo = new SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
            ContentInfo contentInfo = null;
            PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
            if (contentType == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("packageRSASignedFile::::::contentType=RFC(" + PKCSObjectIdentifiers.data.getId() + ")");
                }
                contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, derSourceData);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("packageRSASignedFile::::::contentType=" + contentType);
                }
                contentInfo = new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            }
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            BERSet digestAlgorithmSets = new BERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists()) {
                sign_file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfoTemp);
            dos.close();
            logger.debug("packageRSASignedFile<<<<<<Finished");
        }
        catch (Exception e) {
            logger.error("packageRSASignedFile<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public final void packageSM2SignedFile(String contentType, String sourceFile, String signFile, byte[] signature, X509Cert[] certs) throws PKIException {
        StringBuffer buffer;
        if (logger.isDebugEnabled()) {
            buffer = new StringBuffer();
            buffer.append("packageSM2SignedFile>>>>>>Running");
            buffer.append("\n contentType: " + contentType);
            buffer.append("\n sourceFile: ");
            buffer.append(Debugger.dump(sourceFile));
            buffer.append("\n signFile: ");
            buffer.append(Debugger.dump(signFile));
            buffer.append("\n signature: ");
            buffer.append(Debugger.dump(signature));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        if (certs == null || certs.length == 0) {
            if (logger.isErrorEnabled()) {
                buffer = new StringBuffer();
                buffer.append("packageSM2SignedFile<<<<<<Failure: Required certs");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                logger.error(buffer.toString());
            }
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (signature == null || signature.length != 64) {
            if (logger.isErrorEnabled()) {
                buffer = new StringBuffer();
                buffer.append("packageSM2SignedFile<<<<<<Failure: Required signature MUST BE 64Bytes");
                buffer.append("\n signature: ");
                buffer.append(Debugger.dump(signature));
                logger.error(buffer.toString());
            }
            throw new PKIException("signature of SM2 MUST BE NOT NULL AND LENGTH MUST BE 64");
        }
        try {
            ASN1SM2Signature derSignature = new ASN1SM2Signature(signature);
            ASN1Integer derR = derSignature.getR();
            ASN1Integer derS = derSignature.getS();
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, (ASN1Encodable)new DERNull());
            AlgorithmIdentifier digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, (ASN1Encodable)new DERNull());
            SM2SignerInfox signerInfo = null;
            if (this.isNewFormat()) {
                logger.debug("packageSM2SignedFile::::::isNewFormat=True");
                signerInfo = new SM2SignerInfo2(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            } else {
                logger.debug("packageSM2SignedFile::::::isNewFormat=False");
                signerInfo = new SM2SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            }
            ContentInfo contentInfo = null;
            PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
            if (contentType == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("packageSM2SignedFile::::::contentType=SM2(" + PKCSObjectIdentifiers.sm2Data.getId() + ")");
                }
                contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2Data, derSourceData);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("packageSM2SignedFile::::::contentType=" + contentType);
                }
                contentInfo = new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            }
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            DERSet digestAlgorithmSets = new DERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.sm2SignedData, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists()) {
                sign_file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfoTemp);
            dos.close();
            logger.debug("packageSM2SignedFile<<<<<<Finished");
        }
        catch (Exception e) {
            logger.error("packageSM2SignedFile<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public final void packageSignedFile(String contentType, String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (certs == null || certs.length == 0 || certs[0] == null) {
            logger.error("packageSignedFile<<<<<<Failure: Required certs");
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a: RequiredCerts");
        }
        if (certs[0].isSM2Cert()) {
            logger.debug("packageSignedFile:::::::packageSM2SignedFile");
            this.packageSM2SignedFile(contentType, sourceFilePath, signFile, signture, certs);
        } else if (certs[0].isRSACert()) {
            logger.debug("packageSignedFile:::::::packageRSASignedFile");
            this.packageRSASignedFile(contentType, sourceFilePath, signFile, signture, mechanism, certs);
        } else {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a: RequiredCerts[RSA/SM2]");
        }
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public final byte[] getSourceData() {
        return this.sourceData;
    }

    public final X509Cert getSignerX509Cert() {
        return this.signerCert;
    }

    boolean isNewFormat() {
        return false;
    }
}

