/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.org.bouncycastle.util.encoders.Base64Encoder;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.system.Debugger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Base64 {
    static final Logger logger;
    static final int outputLength = 10240;

    public static byte[] encode(byte[] data) {
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeRunning");
            Base64.appendContext(buffer, data);
            logger.trace(buffer.toString());
        }
        byte[] encoding = null;
        if (data != null) {
            Base64Encoder encoder = new Base64Encoder();
            int len = (data.length + 2) / 3 * 4;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
            try {
                encoder.encode(data, 0, data.length, bOut);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("encoding base64 failure", e);
                }
                throw new RuntimeException("encoding base64 failure: " + e.getMessage(), e);
            }
            encoding = bOut.toByteArray();
        }
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeResult");
            Base64.appendContext(buffer, encoding);
            logger.trace(buffer.toString());
        }
        return encoding;
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeRunning");
            Base64.appendContext(buffer, data);
            logger.trace(buffer.toString());
        }
        int returnLength = 0;
        if (data != null && out != null) {
            Base64Encoder encoder = new Base64Encoder();
            returnLength = encoder.encode(data, 0, data.length, out);
        }
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeResult");
            buffer.append("\n returnLength: " + returnLength);
            logger.trace(buffer.toString());
        }
        return returnLength;
    }

    public static int encode(byte[] data, int offset, int length, OutputStream out) throws IOException {
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeRunning");
            Base64.appendContext(buffer, data);
            buffer.append("\n offset=" + offset);
            buffer.append("\n length=" + length);
            logger.trace(buffer.toString());
        }
        if (offset < 0) {
            logger.trace("encoding base64 failure: offset is negative");
            throw new IllegalArgumentException("encoding base64 failure: offset is negative");
        }
        if (length < 0) {
            logger.trace("encoding base64 failure: length is negative");
            throw new IllegalArgumentException("encoding base64 failure: length is negative");
        }
        int returnLength = 0;
        if (data != null && out != null) {
            if (data.length < offset + length) {
                logger.trace("encoding base64 failure: invalid offset/length");
                throw new IllegalArgumentException("encoding base64 failure: invalid offset/length");
            }
            Base64Encoder encoder = new Base64Encoder();
            returnLength = encoder.encode(data, offset, length, out);
        }
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeResult");
            buffer.append("\n returnLength: " + returnLength);
            logger.trace(buffer.toString());
        }
        return returnLength;
    }

    public static byte[] decode(byte[] data) {
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decodeRunning");
            Base64.appendContext(buffer, data);
            logger.trace(buffer.toString());
        }
        byte[] decoding = null;
        if (data != null) {
            Base64Encoder encoder = new Base64Encoder();
            int len = data.length / 4 * 3;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
            try {
                encoder.decode(data, 0, data.length, bOut);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("decoding base64 failure", e);
                }
                throw new RuntimeException("decoding base64 failure: " + e.getMessage(), e);
            }
            decoding = bOut.toByteArray();
        }
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decodeResult");
            Base64.appendContext(buffer, decoding);
            logger.trace(buffer.toString());
        }
        return decoding;
    }

    public static byte[] decode(String data) {
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeRunning");
            Base64.appendContext(buffer, data);
            logger.trace(buffer.toString());
        }
        byte[] decoding = null;
        if (data != null) {
            Base64Encoder encoder = new Base64Encoder();
            int len = data.length() / 4 * 3;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
            try {
                encoder.decode(data, bOut);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("decoding base64 failure", e);
                }
                throw new RuntimeException("decoding base64 failure: " + e.getMessage(), e);
            }
            decoding = bOut.toByteArray();
        }
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decodeResult");
            Base64.appendContext(buffer, decoding);
            logger.trace(buffer.toString());
        }
        return decoding;
    }

    public static int decode(String data, OutputStream out) throws IOException {
        int returnLength;
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encodeRunning");
            Base64.appendContext(buffer, data);
            logger.trace(buffer.toString());
        }
        try {
            Base64Encoder encoder = new Base64Encoder();
            returnLength = encoder.decode(data, out);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("decoding base64 failure", e);
            }
            throw new RuntimeException("decoding base64 failure: " + e.getMessage(), e);
        }
        if (logger.isTraceEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decodeResult");
            buffer.append("\n returnLength: " + returnLength);
            logger.trace(buffer.toString());
        }
        return returnLength;
    }

    static final void appendContext(StringBuffer buffer, byte[] content) {
        buffer.append("\n content: ");
        if (content == null) {
            buffer.append("none ");
        } else if (content.length > 10240) {
            buffer.append("contentLength=" + content.length);
            buffer.append("(more than 10K) ");
        } else {
            buffer.append("contentLength=" + content.length);
            buffer.append("\n " + Hex.toHexString(content));
        }
    }

    static final void appendContext(StringBuffer buffer, String content) {
        buffer.append("\n content: ");
        if (content == null) {
            buffer.append("none ");
        } else if (content.length() > 10240) {
            buffer.append("contentLength=" + content.length());
            buffer.append("(more than 10K) ");
        } else {
            buffer.append("contentLength=" + content.length());
            buffer.append("\n " + content);
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(Base64.class);
    }
}

