/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.FileUtil;
import cfca.internal.tool.InitKeyStore;
import cfca.internal.tool.P7b;
import cfca.internal.tool.PKCS12;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sm.algorithm.SM2Pfx;
import cfca.sm2rsa.common.PKCS7SignedData2;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.X9ObjectIdentifiers;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class CertUtil {
    static final Logger logger;

    /*
     * Exception decompiling
     */
    public static byte[] getCertExtensionData(X509Cert cert, String oid) throws PKIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static X509Cert getCertFromSM2(String sm2FilePath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromSM2[File]>>>>>>Running");
            buffer.append("\n sm2FilePath: ");
            buffer.append(Debugger.dump(sm2FilePath));
            logger.debug(buffer.toString());
        }
        try {
            byte[] sm2FileData;
            if (sm2FilePath == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sm2FilePath");
            }
            try {
                sm2FileData = FileUtil.getBytesFromFile(sm2FilePath);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getCertFromSM2[File]::::::GetBytesFromFile Finished");
                    buffer.append("\n sm2FileData: ");
                    buffer.append(Debugger.dump(sm2FileData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851121", "\u8bc1\u4e66\u5de5\u5177\u5305\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            X509Cert cert = CertUtil.getCertFromSM2(sm2FileData);
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getCertFromSM2[File]<<<<<<Finished");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                logger.debug(buffer.toString());
            }
            return cert;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getCertFromSM2[File]<<<<<<Failure");
                buffer.append("\n sm2FilePath: ");
                buffer.append(Debugger.dump(sm2FilePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Cert getCertFromSM2(byte[] sm2FileData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromSM2[Data]>>>>>>Running");
            buffer.append("\n sm2FileData: ");
            buffer.append(Debugger.dump(sm2FileData));
            logger.debug(buffer.toString());
        }
        try {
            if (sm2FileData == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sm2FileData");
            }
            FilterInputStream in = null;
            try {
                byte[] binarySM2FileData;
                byte[] byArray = binarySM2FileData = ASN1Parser.isBase64Encode(sm2FileData) ? Base64.decode(sm2FileData) : sm2FileData;
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getCertFromSM2[Data]::::::Decoding");
                    buffer.append("\n binarySM2FileData: ");
                    buffer.append(Debugger.dump(binarySM2FileData));
                    logger.debug(buffer.toString());
                }
                in = new ASN1InputStream(new ByteArrayInputStream(binarySM2FileData));
                SM2Pfx object = SM2Pfx.getInstance(((ASN1InputStream)in).readObject());
                X509Cert cert = object.getPublicCert();
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getCertFromSM2[Data]<<<<<<Finished");
                    buffer.append("\n cert: ");
                    buffer.append(Debugger.dump(cert));
                    logger.debug(buffer.toString());
                }
                X509Cert x509Cert = cert;
                return x509Cert;
            }
            catch (Exception e) {
                throw new PKIException("851110", "\u8bc1\u4e66\u5de5\u5177\u5305SM2\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new PKIException("851110", "\u8bc1\u4e66\u5de5\u5177\u5305SM2\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
                    }
                }
            }
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw e;
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromSM2[Data]<<<<<<Failure");
            buffer.append("\n sm2FileData: ");
            buffer.append(Debugger.dump(sm2FileData));
            logger.error(buffer.toString(), e);
            throw e;
        }
    }

    public static X509Cert getCertFromPfx(String pfxFilePath, String pfxFilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromPfx[File]>>>>>>Running");
            buffer.append("\n pfxFilePath: ");
            buffer.append(Debugger.dump(pfxFilePath));
            logger.debug(buffer.toString());
        }
        try {
            byte[] pfxFileData;
            if (pfxFilePath == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePath");
            }
            if (pfxFilePass == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePass");
            }
            try {
                pfxFileData = FileUtil.getBytesFromFile(pfxFilePath);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getCertFromPfx[File]::::::GetBytesFromFile Finished");
                    buffer.append("\n pfxFileData: ");
                    buffer.append(Debugger.dump(pfxFileData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851121", "\u8bc1\u4e66\u5de5\u5177\u5305\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            return CertUtil.getCertFromPfx(pfxFileData, pfxFilePass);
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getCertFromPfx[File]<<<<<<Failure");
                buffer.append("\n pfxFilePath: ");
                buffer.append(Debugger.dump(pfxFilePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static X509Cert getCertFromPfx(byte[] pfxFileData, String pfxFilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromPfx[Data]>>>>>>Running");
            buffer.append("\n pfxFileData: ");
            buffer.append(Debugger.dump(pfxFileData));
            logger.debug(buffer.toString());
        }
        try {
            if (pfxFileData == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFileData");
            }
            if (pfxFilePass == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePass");
            }
            try {
                PKCS12 pkcs12 = new PKCS12();
                pkcs12.load(pfxFileData);
                logger.debug("getCertFromPfx[Data]::::::Loading Finished");
                pkcs12.decrypt(pfxFilePass.toCharArray());
                logger.debug("getCertFromPfx[Data]::::::Decrypt Finished");
                X509Cert cert = pkcs12.getCerts()[0];
                logger.debug("getCertFromPfx[Data]<<<<<<Finished");
                return cert;
            }
            catch (Exception e) {
                throw new PKIException("851111", "\u8bc1\u4e66\u5de5\u5177\u5305PFX\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getCertFromPfx[Data]<<<<<<Failure");
                buffer.append("\n pfxFileData: ");
                buffer.append(Debugger.dump(pfxFileData));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static X509Cert getCertFromPfx(InputStream pfxInputStream, String pfxFilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromPfx[Steam]>>>>>>Running");
            logger.debug(buffer.toString());
        }
        try {
            if (pfxInputStream == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxInputStream");
            }
            if (pfxFilePass == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePass");
            }
            try {
                PKCS12 pkcs12 = new PKCS12();
                pkcs12.load(pfxInputStream);
                logger.debug("getCertFromPfx[Steam]::::::Loading Finished");
                pkcs12.decrypt(pfxFilePass.toCharArray());
                logger.debug("getCertFromPfx[Steam]::::::Decrypt Finished");
                X509Cert cert = pkcs12.getCerts()[0];
                logger.debug("getCertFromPfx[Steam]<<<<<<Finished");
                return cert;
            }
            catch (Exception e) {
                throw new PKIException("851111", "\u8bc1\u4e66\u5de5\u5177\u5305PFX\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getCertFromPfx[Steam]<<<<<<Failure");
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static X509Cert getCertFromJks(String jksFilePath, String jksFilePass, String alias) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromJks[File]>>>>>>Running");
            buffer.append("\n jksFilePath: ");
            buffer.append(Debugger.dump(jksFilePath));
            logger.debug(buffer.toString());
        }
        try {
            if (jksFilePath == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: jksFilePath");
            }
            if (jksFilePass == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: jksFilePass");
            }
            if (alias == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: alias");
            }
            try {
                KeyStore keyStore = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePass);
                Certificate certificate = keyStore.getCertificate(alias);
                if (certificate != null) {
                    return new X509Cert(certificate.getEncoded());
                }
                throw new PKIException("851113", "\u8bc1\u4e66\u5de5\u5177\u5305JKS\u6587\u4ef6\u6ca1\u6709\u6307\u5b9a\u522b\u540d: " + alias);
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("851112", "\u8bc1\u4e66\u5de5\u5177\u5305JKS\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getCertFromJks[File]<<<<<<Failure");
                buffer.append("\n jksFilePath: ");
                buffer.append(Debugger.dump(jksFilePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static X509Cert[] parseP7b(String filePath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("parseP7b[File]>>>>>>Running");
            buffer.append("\n filePath: ");
            buffer.append(Debugger.dump(filePath));
            logger.debug(buffer.toString());
        }
        try {
            byte[] p7bFileData;
            if (filePath == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: filePath");
            }
            try {
                p7bFileData = FileUtil.getBytesFromFile(filePath);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("parseP7b[File]::::::GetBytesFromFile Finished");
                    buffer.append("\n p7bFileData: ");
                    buffer.append(Debugger.dump(p7bFileData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851114", "\u8bc1\u4e66\u5de5\u5177\u5305P7B\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            try {
                return P7b.parseP7b(p7bFileData);
            }
            catch (Exception e) {
                throw new PKIException("851114", "\u8bc1\u4e66\u5de5\u5177\u5305P7B\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("parseP7b[File]<<<<<<Failure");
                buffer.append("\n filePath: ");
                buffer.append(Debugger.dump(filePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static X509Cert[] parseP7b(byte[] p7bData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("parseP7b[Data]>>>>>>Running");
            buffer.append("\n p7bData: ");
            buffer.append(Debugger.dump(p7bData));
            logger.debug(buffer.toString());
        }
        try {
            if (p7bData == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: p7bData");
            }
            try {
                return P7b.parseP7b(p7bData);
            }
            catch (Exception e) {
                throw new PKIException("851114", "\u8bc1\u4e66\u5de5\u5177\u5305P7B\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("parseP7b[Data]<<<<<<Failure");
                buffer.append("\n p7bData: ");
                buffer.append(Debugger.dump(p7bData));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static void generateP7bFile(X509Cert[] certs, String saveFilePath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateP7bFile>>>>>>Running");
            buffer.append("\n saveFilePath: ");
            buffer.append(Debugger.dump(saveFilePath));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        try {
            if (certs == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: certs");
            }
            if (saveFilePath == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: saveFilePath");
            }
            try {
                P7b.generateP7bFile(certs, saveFilePath);
            }
            catch (Exception e) {
                throw new PKIException("851114", "\u8bc1\u4e66\u5de5\u5177\u5305P7B\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateP7bFile>>>>>>Running");
                buffer.append("\n saveFilePath: ");
                buffer.append(Debugger.dump(saveFilePath));
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static boolean isSM2Cert(X509Cert cert) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("isSM2Cert>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        try {
            boolean isSM2Cert;
            boolean bl = isSM2Cert = cert != null && cert.isSM2Cert();
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("isSM2Cert<<<<<<Finished, isSM2Cert=" + isSM2Cert);
                try {
                    buffer.append("\n certAlgorithmOID: ");
                    buffer.append(Debugger.dump(cert.getCertStructure().getSignatureAlgorithm().getAlgorithm()));
                    buffer.append("\n destAlgorithmOID: ");
                    buffer.append(Debugger.dump(X9ObjectIdentifiers.sm3_with_SM2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.debug(buffer.toString());
            }
            return isSM2Cert;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("isSM2Cert<<<<<<Failure");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            return false;
        }
    }

    public static boolean isCACert(X509Cert cert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("isCACert>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        try {
            boolean isCA;
            boolean bl = isCA = cert != null && cert.isCACert();
            if (logger.isDebugEnabled()) {
                logger.debug("isCACert<<<<<<Finished, isCACert=" + isCA);
            }
            return isCA;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("isCACert<<<<<<Failure");
                buffer.append("\n cert: ");
                buffer.append(Debugger.dump(cert));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static X509Cert getSignerCertFromP7SignData(byte[] p7SignedData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSignerCertFromP7SignData>>>>>>Running");
            buffer.append("\n p7SignedData: ");
            buffer.append(Debugger.dump(p7SignedData));
            logger.debug(buffer.toString());
        }
        try {
            if (p7SignedData == null) {
                throw new PKIException("851100", "\u8bc1\u4e66\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: p7SignedData");
            }
            try {
                PKCS7SignedData2 pkcs7SignedData = new PKCS7SignedData2(null);
                pkcs7SignedData.loadBase64(p7SignedData);
                return pkcs7SignedData.getSignerX509Cert();
            }
            catch (Exception e) {
                throw new PKIException("851114", "\u8bc1\u4e66\u5de5\u5177\u5305P7B\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getSignerCertFromP7SignData<<<<<<Failure");
                buffer.append("\n p7SignedData: ");
                buffer.append(Debugger.dump(p7SignedData));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(CertUtil.class);
    }
}

