/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.crypto.BlockCipher;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.util.cipher.lib.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;

public class EncryptUtil {
    static final Logger logger;

    private static byte[] doWithPwd(byte[] data, String keyMaterial, boolean encryptFlag) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("doWithPwd::>>>>>>Running");
            buffer.append("\n data: ");
            buffer.append(Debugger.dump(data));
            buffer.append("\n keyMaterial: ");
            buffer.append(Debugger.dump(keyMaterial));
            buffer.append("\n encryptFlag: " + encryptFlag);
            logger.debug(buffer.toString());
        }
        byte[] ivKey = Hex.decode(keyMaterial);
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        byte[] iv = new byte[8];
        byte[] key = new byte[24];
        System.arraycopy(ivKey, 0, iv, 0, 8);
        System.arraycopy(ivKey, 8, key, 0, 24);
        CBCParam param = new CBCParam(iv);
        algName.setParam(param);
        byte[] encryptMessageBytes = null;
        encryptMessageBytes = encryptFlag ? RSASymmetricCryptoUtil.encrypt(key, data, algName) : RSASymmetricCryptoUtil.decrypt(key, data, algName);
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("doWithPwd::<<<<<<Finished: ");
            buffer.append("\n encryptMessageBytes: ");
            buffer.append(Debugger.dump(encryptMessageBytes));
            logger.debug(buffer.toString());
        }
        return encryptMessageBytes;
    }

    public static String encryptMessageByPwd_3DES(String sourceData, String keyMaterial) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encryptMessageByPwd_3DES>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n keyMaterial: ");
            buffer.append(Debugger.dump(keyMaterial));
            logger.debug(buffer.toString());
        }
        try {
            if (sourceData == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (keyMaterial == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: keyMaterial");
            }
            if (Hex.isHex(keyMaterial) && keyMaterial.length() == 64) {
                try {
                    byte[] sourceData_utf8 = sourceData.getBytes("UTF-8");
                    byte[] encryptData = EncryptUtil.doWithPwd(sourceData_utf8, keyMaterial, true);
                    String base64EncryptMessage = new String(Base64.encode(encryptData), "UTF-8");
                    if (logger.isDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("encryptMessageByPwd_3DES<<<<<<Finished: ");
                        buffer.append("\n binaryEncryptMessage: ");
                        buffer.append(Debugger.dump(encryptData));
                        buffer.append("\n base64EncryptMessage: ");
                        buffer.append(Debugger.dump(base64EncryptMessage));
                        logger.debug(buffer.toString());
                    }
                    return base64EncryptMessage;
                }
                catch (PKIException e) {
                    throw new PKIException(e);
                }
                catch (Exception e) {
                    throw new PKIException("851010", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u52a0\u5bc6\u5931\u8d25", e);
                }
            }
            throw new PKIException("851003", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u5bc6\u94a5\u53c2\u6570\u8981\u6c4264\u4e2a\u5341\u516d\u8fdb\u5236\u5b57\u7b26");
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("encryptMessageByPwd_3DES<<<<<<Failure");
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n keyMaterial: ");
                buffer.append(Debugger.dump(keyMaterial));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static String decryptMessageByPwd_3DES(String base64EncryptedData, String keyMaterial) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decryptMessageByPwd_3DES>>>>>>Running");
            buffer.append("\n base64EncryptedData: ");
            buffer.append(Debugger.dump(base64EncryptedData));
            buffer.append("\n keyMaterial: ");
            buffer.append(Debugger.dump(keyMaterial));
            logger.debug(buffer.toString());
        }
        try {
            if (base64EncryptedData == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64EncryptedData");
            }
            if (keyMaterial == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: keyMaterial");
            }
            if (base64EncryptedData != null && Hex.isHex(keyMaterial) && keyMaterial.length() == 64) {
                try {
                    byte[] encryptData_utf8;
                    byte[] data = base64EncryptedData.getBytes("UTF-8");
                    byte[] byArray = encryptData_utf8 = ASN1Parser.isBase64Encode(data) ? Base64.decode(data) : data;
                    if (logger.isDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("decryptMessageByPwd_3DES::::::Decoding");
                        buffer.append("\n binaryEncryptedData: ");
                        buffer.append(Debugger.dump(encryptData_utf8));
                        logger.debug(buffer.toString());
                    }
                    byte[] sourceData = EncryptUtil.doWithPwd(encryptData_utf8, keyMaterial, false);
                    String sourceText = new String(sourceData, "UTF-8");
                    if (logger.isDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("decryptMessageByPwd_3DES<<<<<<Finished");
                        buffer.append("\n sourceData: ");
                        buffer.append(Debugger.dump(sourceData));
                        buffer.append("\n sourceText: ");
                        buffer.append(Debugger.dump(sourceText));
                        logger.debug(buffer.toString());
                    }
                    return sourceText;
                }
                catch (PKIException e) {
                    throw new PKIException(e);
                }
                catch (Exception e) {
                    throw new PKIException("851011", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u89e3\u5bc6\u5931\u8d25", e);
                }
            }
            throw new PKIException("851003", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u5bc6\u94a5\u53c2\u6570\u8981\u6c4264\u4e2a\u5341\u516d\u8fdb\u5236\u5b57\u7b26");
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("decryptMessageByPwd_3DES>>>>>>Running");
                buffer.append("\n base64EncryptedData: ");
                buffer.append(Debugger.dump(base64EncryptedData));
                buffer.append("\n keyMaterial: ");
                buffer.append(Debugger.dump(keyMaterial));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static void encryptFileByPwd_3DES(String sourceFilePath, String encryptFilePath, String keyMaterial) throws PKIException {
        block19: {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("encryptFileByPwd_3DES>>>>>>Running");
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n encryptFilePath: ");
                buffer.append(Debugger.dump(encryptFilePath));
                buffer.append("\n keyMaterial: ");
                buffer.append(Debugger.dump(keyMaterial));
                logger.debug(buffer.toString());
            }
            try {
                if (sourceFilePath == null) {
                    throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
                }
                if (encryptFilePath == null) {
                    throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: encryptFilePath");
                }
                if (keyMaterial == null) {
                    throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: keyMaterial");
                }
                if (Hex.isHex(keyMaterial) && keyMaterial.length() == 64) {
                    FileOutputStream fos = null;
                    try {
                        byte[] ivKey = Hex.decode(keyMaterial);
                        byte[] iv = new byte[8];
                        byte[] key = new byte[24];
                        System.arraycopy(ivKey, 0, iv, 0, 8);
                        System.arraycopy(ivKey, 8, key, 0, 24);
                        CBCParam param = new CBCParam(iv);
                        fos = new FileOutputStream(encryptFilePath);
                        EncryptUtil.bigFileBlockEncrypt(true, key, new DESedeEngine(), param, new File(sourceFilePath), fos);
                        logger.debug("encryptFileByPwd_3DES<<<<<<Finished");
                        break block19;
                    }
                    catch (PKIException e) {
                        throw new PKIException(e);
                    }
                    catch (Exception e) {
                        throw new PKIException("851020", "\u52a0\u5bc6\u5de5\u5177\u5305\u6587\u4ef6\u52a0\u5bc6\u5931\u8d25", e);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                throw new PKIException("851003", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u5bc6\u94a5\u53c2\u6570\u8981\u6c4264\u4e2a\u5341\u516d\u8fdb\u5236\u5b57\u7b26");
            }
            catch (PKIException e) {
                if (logger.isErrorEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("encryptFileByPwd_3DES<<<<<<Finished");
                    buffer.append("\n sourceFilePath: ");
                    buffer.append(Debugger.dump(sourceFilePath));
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(Debugger.dump(encryptFilePath));
                    buffer.append("\n keyMaterial: ");
                    buffer.append(Debugger.dump(keyMaterial));
                    logger.error(buffer.toString(), e);
                }
                throw e;
            }
        }
    }

    public static void decryptFileByPwd_3DES(String encryptFilePath, String plainTextFilePath, String keyMaterial) throws PKIException {
        block19: {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("decryptFileByPwd_3DES>>>>>>Running");
                buffer.append("\n encryptFilePath: ");
                buffer.append(Debugger.dump(encryptFilePath));
                buffer.append("\n plainTextFilePath: ");
                buffer.append(Debugger.dump(plainTextFilePath));
                buffer.append("\n keyMaterial: ");
                buffer.append(Debugger.dump(keyMaterial));
                logger.debug(buffer.toString());
            }
            try {
                if (encryptFilePath == null) {
                    throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: encryptFilePath");
                }
                if (plainTextFilePath == null) {
                    throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: plainTextFilePath");
                }
                if (keyMaterial == null) {
                    throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: keyMaterial");
                }
                if (Hex.isHex(keyMaterial) && keyMaterial.length() == 64) {
                    FileOutputStream fos = null;
                    try {
                        byte[] ivKey = Hex.decode(keyMaterial);
                        byte[] iv = new byte[8];
                        byte[] key = new byte[24];
                        System.arraycopy(ivKey, 0, iv, 0, 8);
                        System.arraycopy(ivKey, 8, key, 0, 24);
                        CBCParam param = new CBCParam(iv);
                        fos = new FileOutputStream(plainTextFilePath);
                        EncryptUtil.bigFileBlockEncrypt(false, key, new DESedeEngine(), param, new File(encryptFilePath), fos);
                        logger.debug("decryptFileByPwd_3DES<<<<<<Finished");
                        break block19;
                    }
                    catch (PKIException e) {
                        throw new PKIException(e);
                    }
                    catch (Exception e) {
                        throw new PKIException("851021", "\u52a0\u5bc6\u5de5\u5177\u5305\u6587\u4ef6\u89e3\u5bc6\u5931\u8d25", e);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                throw new PKIException("851003", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u5bc6\u94a5\u53c2\u6570\u8981\u6c4264\u4e2a\u5341\u516d\u8fdb\u5236\u5b57\u7b26");
            }
            catch (PKIException e) {
                if (logger.isErrorEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("decryptFileByPwd_3DES>>>>>>Running");
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(Debugger.dump(encryptFilePath));
                    buffer.append("\n plainTextFilePath: ");
                    buffer.append(Debugger.dump(plainTextFilePath));
                    buffer.append("\n keyMaterial: ");
                    buffer.append(Debugger.dump(keyMaterial));
                    logger.error(buffer.toString(), e);
                }
                throw e;
            }
        }
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, File file, FileOutputStream fos) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("bigFileBlockEncrypt::>>>>>>Running");
            buffer.append("\n encryptFlag: " + encryptFlag);
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n param: ");
            buffer.append(Debugger.dump(param));
            logger.debug(buffer.toString());
        }
        FileInputStream fis = null;
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
            cipher.init(encryptFlag, params);
            int readLen = 0;
            byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = file.length();
            int processLen = 0;
            fis = new FileInputStream(file);
            int len1 = 0;
            int len2 = 0;
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == GlobalVariable.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    fos.write(outBytes, 0, processLen);
                    continue;
                }
                len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                len2 = cipher.doFinal(outBytes, len1);
                fos.write(outBytes, 0, len1 + len2);
                break;
            }
            logger.debug("bigFileBlockEncrypt::<<<<<<Finished");
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("bigFileBlockEncrypt::<<<<<<Failure");
                buffer.append("\n encryptFlag: " + encryptFlag);
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                buffer.append("\n param: ");
                buffer.append(Debugger.dump(param));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error("bigFileBlockEncrypt::<<<<<<Failure when close stream", e);
                }
            }
        }
    }

    public static byte[] encrypt(Mechanism symmetricAlgorithm, Key key, byte[] sourceData, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(Debugger.dump(symmetricAlgorithm));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (symmetricAlgorithm == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (key == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: key");
            }
            if (sourceData == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
            }
            if (session == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            EncryptUtil.checkMechanismWithKey(symmetricAlgorithm, key);
            try {
                byte[] binaryEncryptMessage = session.encrypt(symmetricAlgorithm, key, sourceData);
                byte[] base64EncryptMessage = Base64.encode(binaryEncryptMessage);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("encrypt<<<<<<Finished: ");
                    buffer.append("\n binaryEncryptMessage: ");
                    buffer.append(Debugger.dump(binaryEncryptMessage));
                    buffer.append("\n base64EncryptMessage: ");
                    buffer.append(Debugger.dumpBase64(base64EncryptMessage));
                    logger.debug(buffer.toString());
                }
                return base64EncryptMessage;
            }
            catch (PKIException e) {
                throw new PKIException(e);
            }
            catch (Exception e) {
                throw new PKIException("851010", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u52a0\u5bc6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("encrypt<<<<<<Failure");
                buffer.append("\n Mechanism: ");
                buffer.append(Debugger.dump(symmetricAlgorithm));
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                buffer.append("\n sourceData: ");
                buffer.append(Debugger.dump(sourceData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static byte[] decrypt(Mechanism symmetricAlgorithm, Key key, byte[] base64EncryptedData, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(Debugger.dump(symmetricAlgorithm));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n base64EncryptedData: ");
            buffer.append(Debugger.dump(base64EncryptedData));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (symmetricAlgorithm == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (key == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: key");
            }
            if (base64EncryptedData == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: base64EncryptedData");
            }
            if (session == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            EncryptUtil.checkMechanismWithKey(symmetricAlgorithm, key);
            try {
                byte[] binaryEncryptMessage;
                byte[] byArray = binaryEncryptMessage = ASN1Parser.isBase64Encode(base64EncryptedData) ? Base64.decode(base64EncryptedData) : base64EncryptedData;
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("decrypt<<<<<<Decoding: ");
                    buffer.append("\n binaryEncryptMessage: ");
                    buffer.append(Debugger.dump(binaryEncryptMessage));
                    logger.debug(buffer.toString());
                }
                byte[] binaryDecryptMessage = session.decrypt(symmetricAlgorithm, key, binaryEncryptMessage);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("decrypt<<<<<<Finished: ");
                    buffer.append("\n binaryDecryptMessage: ");
                    buffer.append(Debugger.dump(binaryEncryptMessage));
                    logger.debug(buffer.toString());
                }
                return binaryDecryptMessage;
            }
            catch (PKIException e) {
                throw new PKIException(e);
            }
            catch (Exception e) {
                throw new PKIException("851011", "\u52a0\u5bc6\u5de5\u5177\u5305\u6d88\u606f\u89e3\u5bc6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("decrypt<<<<<<Failure");
                buffer.append("\n Mechanism: ");
                buffer.append(Debugger.dump(symmetricAlgorithm));
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                buffer.append("\n base64EncryptedData: ");
                buffer.append(Debugger.dump(base64EncryptedData));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static void encrypt(Mechanism symmetricAlgorithm, Key key, String sourceFilePath, String encryptFilePath, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(Debugger.dump(symmetricAlgorithm));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(Debugger.dump(encryptFilePath));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (symmetricAlgorithm == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (key == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: key");
            }
            if (sourceFilePath == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
            }
            if (encryptFilePath == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: encryptFilePath");
            }
            if (session == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            EncryptUtil.checkMechanismWithKey(symmetricAlgorithm, key);
            try {
                session.encrypt(symmetricAlgorithm, key, sourceFilePath, encryptFilePath);
                logger.debug("encrypt<<<<<<Finished.");
            }
            catch (PKIException e) {
                throw new PKIException(e);
            }
            catch (Exception e) {
                throw new PKIException("851020", "\u52a0\u5bc6\u5de5\u5177\u5305\u6587\u4ef6\u52a0\u5bc6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("encrypt<<<<<<Failure");
                buffer.append("\n Mechanism: ");
                buffer.append(Debugger.dump(symmetricAlgorithm));
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                buffer.append("\n sourceFilePath: ");
                buffer.append(Debugger.dump(sourceFilePath));
                buffer.append("\n encryptFilePath: ");
                buffer.append(Debugger.dump(encryptFilePath));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static void decrypt(Mechanism symmetricAlgorithm, Key key, String encryptFilePath, String plainTextFilePath, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(Debugger.dump(symmetricAlgorithm));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n encryptFilePath: ");
            buffer.append(Debugger.dump(encryptFilePath));
            buffer.append("\n plainTextFilePath: ");
            buffer.append(Debugger.dump(plainTextFilePath));
            buffer.append("\n session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (symmetricAlgorithm == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: symmetricAlgorithm");
            }
            if (key == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: key");
            }
            if (encryptFilePath == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: encryptFilePath");
            }
            if (plainTextFilePath == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: plainTextFilePath");
            }
            if (session == null) {
                throw new PKIException("851000", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            EncryptUtil.checkMechanismWithKey(symmetricAlgorithm, key);
            try {
                session.decrypt(symmetricAlgorithm, key, encryptFilePath, plainTextFilePath);
            }
            catch (PKIException e) {
                throw new PKIException(e);
            }
            catch (Exception e) {
                throw new PKIException("851021", "\u52a0\u5bc6\u5de5\u5177\u5305\u6587\u4ef6\u89e3\u5bc6\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("decrypt<<<<<<Failure");
                buffer.append("\n Mechanism: ");
                buffer.append(Debugger.dump(symmetricAlgorithm));
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                buffer.append("\n encryptFilePath: ");
                buffer.append(Debugger.dump(encryptFilePath));
                buffer.append("\n plainTextFilePath: ");
                buffer.append(Debugger.dump(plainTextFilePath));
                buffer.append("\n session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    private static void checkMechanismWithKey(Mechanism symmetricAlgorithm, Key key) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("checkMechanismWithKey::>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(Debugger.dump(symmetricAlgorithm));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            logger.debug(buffer.toString());
        }
        try {
            if ("DESede/CBC/PKCS7Padding".equals(symmetricAlgorithm.getMechanismType())) {
                logger.debug("checkMechanismWithKey::<<<<<<DESede/CBC/PKCS7Padding");
                if (symmetricAlgorithm.getParam() == null) {
                    throw new PKIException("851002", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u673a\u5236: missing iv");
                }
                if (key.getEncoded().length != 24) {
                    throw new PKIException("851001", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: key");
                }
            }
            if ("SM4/CBC/PKCS7Padding".equals(symmetricAlgorithm.getMechanismType())) {
                logger.debug("checkMechanismWithKey::<<<<<<SM4/CBC/PKCS7Padding");
                if (symmetricAlgorithm.getParam() == null) {
                    throw new PKIException("851002", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u673a\u5236: missing iv");
                }
                if (key.getEncoded().length != 16) {
                    throw new PKIException("851001", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: key");
                }
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("checkMechanismWithKey::<<<<<<Failure");
                buffer.append("\n Mechanism: ");
                buffer.append(Debugger.dump(symmetricAlgorithm));
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(EncryptUtil.class);
    }
}

