/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sm.algorithm.SM3Digest;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cryptokit.jni.JNIHash;
import cryptokit.jni.JNISM2;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;

public class HashUtil {
    static final Logger logger;

    public static byte[] rsaHashMessage(byte[] sourceData, Mechanism mechanism) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rsaHashMessage>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("rsaHashMessage<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        if (mechanism == null) {
            logger.error("rsaHashMessage<<<<<<Failure, Required not null: mechanism");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
        }
        try {
            RSADigest digest = new RSADigest(mechanism);
            byte[] hashValue = digest.hashMessage(sourceData, false);
            if (logger.isDebugEnabled()) {
                logger.debug("rsaHashMessage<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("rsaHashMessage<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] rsaHashMessageDER(byte[] sourceData, Mechanism mechanism) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rsaHashMessageDER>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("rsaHashMessageDER<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        if (mechanism == null) {
            logger.error("rsaHashMessageDER<<<<<<Failure, Required not null: mechanism");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
        }
        try {
            RSADigest digest = new RSADigest(mechanism);
            byte[] hashValue = digest.hashMessage(sourceData, true);
            if (logger.isDebugEnabled()) {
                logger.debug("rsaHashMessageDER<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("rsaHashMessageDER<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] rsaHashFile(String sourceFilePath, Mechanism mechanism) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rsaHashFile>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("rsaHashFile<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        if (mechanism == null) {
            logger.error("rsaHashFile<<<<<<Failure, Required not null: mechanism");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
        }
        try {
            RSADigest digest = new RSADigest(mechanism);
            byte[] hashValue = digest.hashFile(sourceFilePath, false);
            if (logger.isDebugEnabled()) {
                logger.debug("rsaHashFile<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("rsaHashFile<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] rsaHashFileDER(String sourceFilePath, Mechanism mechanism) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rsaHashFileDER>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("rsaHashFileDER<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        if (mechanism == null) {
            logger.error("rsaHashFileDER<<<<<<Failure, Required not null: mechanism");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: mechanism");
        }
        try {
            RSADigest digest = new RSADigest(mechanism);
            byte[] hashValue = digest.hashFile(sourceFilePath, true);
            if (logger.isDebugEnabled()) {
                logger.debug("rsaHashFileDER<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("rsaHashFileDER<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashMessageWithZValue_BC(byte[] sourceData, SM2PublicKey pubKey) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashMessageWithZValue_BC>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n pubKey: ");
            buffer.append(Debugger.dump(pubKey));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        if (pubKey == null) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure, Required not null: pubKey");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubKey");
        }
        try {
            byte[] zvalue = pubKey.getDefaultZ();
            byte[] hashValue = new byte[32];
            SM3Digest digest = new SM3Digest();
            digest.update(zvalue, 0, zvalue.length);
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hashValue, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithZValue_BC<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashFileWithZValue_BC(String sourceFilePath, SM2PublicKey pubKey) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFileWithZValue_BC>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n pubKey: ");
            buffer.append(Debugger.dump(pubKey));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        if (pubKey == null) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure, Required not null: pubKey");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubKey");
        }
        try {
            byte[] zvalue = pubKey.getDefaultZ();
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFileWithZValue_BC::::::zvalue=" + Hex.toHexString(zvalue));
            }
            SM3Digest digest = new SM3Digest();
            digest.update(zvalue, 0, zvalue.length);
            byte[] hashValue = HashUtil.sm2HashFile(digest, sourceFilePath);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFileWithZValue_BC<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashMessageWithZValue_BC(byte[] userId, byte[] sourceData, BigInteger pubX, BigInteger pubY) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashMessageWithZValue_BC>>>>>>Running");
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n pubX: ");
            buffer.append(Debugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(Debugger.dump(pubY));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        if (pubX == null) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure, Required not null: pubX");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubX");
        }
        if (pubY == null) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure, Required not null: pubY");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubY");
        }
        try {
            byte[] zvalue = SM2Params.calcZ(pubX, pubY, userId);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithZValue_BC::::::zvalue=" + Hex.toHexString(zvalue));
            }
            byte[] hashValue = new byte[32];
            SM3Digest digest = new SM3Digest();
            digest.update(zvalue, 0, zvalue.length);
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hashValue, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithZValue_BC<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashMessageWithZValue_BC<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashMessageWithZValue_JNI(byte[] userId, byte[] sourceData, byte[] pubX, byte[] pubY) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashMessageWithZValue_JNI>>>>>>Running");
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n pubX: ");
            buffer.append(Debugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(Debugger.dump(pubY));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("sm2HashMessageWithZValue_JNI<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        if (pubX == null) {
            logger.error("sm2HashMessageWithZValue_JNI<<<<<<Failure, Required not null: pubX");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubX");
        }
        if (pubY == null) {
            logger.error("sm2HashMessageWithZValue_JNI<<<<<<Failure, Required not null: pubY");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubY");
        }
        if (pubX.length != 32) {
            logger.error("sm2HashMessageWithZValue_JNI<<<<<<Failure, Required not null length: pubX[32]");
            throw new PKIException("851301", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: pubX");
        }
        if (pubY.length != 32) {
            logger.error("sm2HashMessageWithZValue_JNI<<<<<<Failure, Required not null length: pubY[32]");
            throw new PKIException("851301", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: pubY");
        }
        try {
            byte[] zvalue = new byte[32];
            if (userId == null) {
                userId = SM2Params.getDefaultuserid();
            }
            JNISM2.calculateZValue(pubX, pubY, userId, zvalue);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithZValue_JNI::::::zvalue=" + Hex.toHexString(zvalue));
            }
            byte[] hashValue = new byte[32];
            JNIHash sm3_jni = new JNIHash();
            sm3_jni.init(JNIHash.NID_ChinaSM3);
            sm3_jni.update(zvalue);
            sm3_jni.update(sourceData);
            sm3_jni.doFinal(hashValue);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithZValue_JNI<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashMessageWithZValue_JNI<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashMessageWithoutZValue_BC(byte[] sourceData) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashMessageWithoutZValue_BC>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("sm2HashMessageWithoutZValue_BC<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        try {
            byte[] hashValue = new byte[32];
            SM3Digest digest = new SM3Digest();
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hashValue, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithoutZValue_BC<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashMessageWithoutZValue_BC<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashMessageWithoutZValue_JNI(byte[] sourceData) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashMessageWithoutZValue_JNI>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (sourceData == null) {
            logger.error("sm2HashMessageWithoutZValue_JNI<<<<<<Failure, Required not null: sourceData");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceData");
        }
        try {
            byte[] hashValue = new byte[32];
            JNIHash sm3_jni = new JNIHash();
            sm3_jni.init(JNIHash.NID_ChinaSM3);
            sm3_jni.update(sourceData);
            sm3_jni.doFinal(hashValue);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessageWithoutZValue_JNI<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashMessageWithoutZValue_JNI<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashFileWithZValue_BC(byte[] userId, String sourceFilePath, BigInteger pubX, BigInteger pubY) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFileWithZValue_BC>>>>>>Running");
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n pubX: ");
            buffer.append(Debugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(Debugger.dump(pubY));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        if (pubX == null) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure, Required not null: pubX");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubX");
        }
        if (pubY == null) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure, Required not null: pubY");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubY");
        }
        try {
            byte[] zvalue = SM2Params.calcZ(pubX, pubY, userId);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFileWithZValue_BC::::::zvalue=" + Hex.toHexString(zvalue));
            }
            SM3Digest digest = new SM3Digest();
            digest.update(zvalue, 0, zvalue.length);
            byte[] hashValue = HashUtil.sm2HashFile(digest, sourceFilePath);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFileWithZValue_BC<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashFileWithZValue_BC<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashFileWithZValue_JNI(byte[] userId, String sourceFilePath, byte[] pubX, byte[] pubY) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFileWithZValue_JNI>>>>>>Running");
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n pubX: ");
            buffer.append(Debugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(Debugger.dump(pubY));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFileWithZValue_JNI<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        if (pubX == null) {
            logger.error("sm2HashFileWithZValue_JNI<<<<<<Failure, Required not null: pubX");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubX");
        }
        if (pubY == null) {
            logger.error("sm2HashFileWithZValue_JNI<<<<<<Failure, Required not null: pubY");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pubY");
        }
        if (pubX.length != 32) {
            logger.error("sm2HashFileWithZValue_JNI<<<<<<Failure, Required not null length: pubX[32]");
            throw new PKIException("851301", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: pubX");
        }
        if (pubY.length != 32) {
            logger.error("sm2HashFileWithZValue_JNI<<<<<<Failure, Required not null length: pubY[32]");
            throw new PKIException("851301", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u65e0\u6548\u53c2\u6570: pubY");
        }
        try {
            byte[] zvalue = new byte[32];
            if (userId == null) {
                userId = SM2Params.getDefaultuserid();
            }
            JNISM2.calculateZValue(pubX, pubY, userId, zvalue);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFileWithZValue_JNI::::::zvalue=" + Hex.toHexString(zvalue));
            }
            byte[] hashValue = HashUtil.sm2HashFile(sourceFilePath, zvalue);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFileWithZValue_JNI<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashFileWithZValue_JNI<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public static byte[] sm2HashFileWithoutZValue_BC(String sourceFilePath) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFileWithoutZValue_BC>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFileWithoutZValue_BC<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        SM3Digest digest = new SM3Digest();
        byte[] hashValue = HashUtil.sm2HashFile(digest, sourceFilePath);
        if (logger.isDebugEnabled()) {
            logger.debug("sm2HashFileWithoutZValue_BC<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
        }
        return hashValue;
    }

    public static byte[] sm2HashFileWithoutZValue_JNI(String sourceFilePath) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFileWithoutZValue_JNI>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFileWithoutZValue_JNI<<<<<<Failure, Required not null: sourceFilePath");
            throw new PKIException("851300", " \u6563\u5217\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sourceFilePath");
        }
        byte[] hashValue = HashUtil.sm2HashFile(sourceFilePath, null);
        if (logger.isDebugEnabled()) {
            logger.debug("sm2HashFileWithoutZValue_JNI<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
        }
        return hashValue;
    }

    public static final byte[] sm2HashMessage(SM2PublicKey sm2PublicKey, byte[] data, boolean withZ) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashMessage>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(Debugger.dump(sm2PublicKey));
            buffer.append("\n data: ");
            buffer.append(Debugger.dump(data));
            buffer.append("\n withZ: " + withZ);
            logger.debug(buffer.toString());
        }
        if (data == null) {
            logger.error("sm2HashMessage<<<<<<Failure, Required not null: data");
            throw new IllegalArgumentException("null not allowed for data");
        }
        try {
            SM3Digest digest = new SM3Digest();
            byte[] hashValue = new byte[32];
            if (withZ) {
                if (sm2PublicKey == null) {
                    logger.error("sm2HashMessage<<<<<<Failure, Required not null: sm2PublicKey");
                    throw new IllegalArgumentException("null not allowed for sm2PublicKey");
                }
                byte[] zValue = sm2PublicKey.getDefaultZ();
                if (zValue == null) {
                    zValue = SM2Params.calcZ(sm2PublicKey.getQ());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("sm2HashMessage::::::zvalue=" + Hex.toHexString(zValue));
                }
                digest.update(zValue, 0, zValue.length);
            }
            digest.update(data, 0, data.length);
            digest.doFinal(hashValue, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashMessage<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashMessage<<<<<<Failure", e);
            throw new RuntimeException(e);
        }
    }

    public static final byte[] sm2HashFile(SM2PublicKey sm2PublicKey, String sourceFilePath, boolean withZ) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFile>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(Debugger.dump(sm2PublicKey));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n withZ: " + withZ);
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFile<<<<<<Failure, Required not null: sourceFilePath");
            throw new IllegalArgumentException("null not allowed for data");
        }
        try {
            SM3Digest digest = new SM3Digest();
            if (withZ) {
                if (sm2PublicKey == null) {
                    logger.error("sm2HashFile<<<<<<Failure, Required not null: sm2PublicKey");
                    throw new IllegalArgumentException("null not allowed for sm2PubKey");
                }
                byte[] zValue = sm2PublicKey.getDefaultZ();
                if (zValue == null) {
                    zValue = SM2Params.calcZ(sm2PublicKey.getQ());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("sm2HashFile::::::zvalue=" + Hex.toHexString(zValue));
                }
                digest.update(zValue, 0, zValue.length);
            }
            byte[] hashValue = HashUtil.sm2HashFile(digest, sourceFilePath);
            if (logger.isDebugEnabled()) {
                logger.debug("sm2HashFile<<<<<<Finished, hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new RuntimeException(e);
        }
    }

    private static final byte[] sm2HashFile(SM3Digest digest, String sourceFilePath) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFile::>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFile::<<<<<<Failure, Required not null: sourceFilePath");
            throw new IllegalArgumentException("null not allowed for data");
        }
        byte[] hash = new byte[32];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            byte[] buffer = new byte[8096];
            int rLength = 0;
            while ((rLength = fis.read(buffer)) >= 0) {
                digest.update(buffer, 0, rLength);
            }
            digest.doFinal(hash, 0);
        }
        catch (FileNotFoundException e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new SecurityException("doHashSM3 failure: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new SecurityException("doHashSM3 failure: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new SecurityException("doHashSM3 failure: " + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return hash;
    }

    private static final byte[] sm2HashFile(String sourceFilePath, byte[] zvalue) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sm2HashFile::>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n zvalue: ");
            buffer.append(Debugger.dump(zvalue));
            logger.debug(buffer.toString());
        }
        if (sourceFilePath == null) {
            logger.error("sm2HashFile::<<<<<<Failure, Required not null: sourceFilePath");
            throw new IllegalArgumentException("null not allowed for data");
        }
        byte[] hash = new byte[32];
        FileInputStream fis = null;
        try {
            JNIHash sm3_jni = new JNIHash();
            sm3_jni.init(JNIHash.NID_ChinaSM3);
            if (zvalue != null && zvalue.length == 32) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sm2HashFile::::::::zvalue=" + Hex.toHexString(zvalue));
                }
                sm3_jni.update(zvalue);
            }
            fis = new FileInputStream(sourceFilePath);
            byte[] buffer = new byte[8096];
            int rLength = 0;
            byte[] data = null;
            while ((rLength = fis.read(buffer)) >= 0) {
                data = new byte[rLength];
                System.arraycopy(buffer, 0, data, 0, data.length);
                sm3_jni.update(data);
            }
            sm3_jni.doFinal(hash);
        }
        catch (FileNotFoundException e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new SecurityException("doHashSM3 failure: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new SecurityException("doHashSM3 failure: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("sm2HashFile<<<<<<Failure", e);
            throw new SecurityException("doHashSM3 failure: " + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return hash;
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(HashUtil.class);
    }

    static final class RSADigest {
        final Digest digest;
        final AlgorithmIdentifier algId;

        RSADigest(Mechanism mechanism) throws PKIException {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("RSADigest::>>>>>>Running");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(mechanism));
                logger.debug(buffer.toString());
            }
            String type = mechanism.getMechanismType();
            ASN1ObjectIdentifier oid = null;
            if (type.equals("SHA1") || type.equals("SHA1withRSAEncryption")) {
                logger.debug("RSADigest::<<<<<<Finished: SHA1");
                this.digest = new SHA1Digest();
                oid = X509ObjectIdentifiers.id_SHA1;
            } else if (type.equals("SHA256") || type.equals("SHA256withRSAEncryption")) {
                logger.debug("RSADigest::<<<<<<Finished: SHA256");
                this.digest = new SHA256Digest();
                oid = NISTObjectIdentifiers.id_sha256;
            } else if (type.equals("SHA512") || type.equals("SHA512withRSA")) {
                logger.debug("RSADigest::<<<<<<Finished: SHA512");
                this.digest = new SHA512Digest();
                oid = NISTObjectIdentifiers.id_sha512;
            } else if (type.equals("MD5") || type.equals("MD5withRSAEncryption")) {
                logger.debug("RSADigest::<<<<<<Finished: MD5");
                this.digest = new MD5Digest();
                oid = PKCSObjectIdentifiers.md5;
            } else {
                logger.error("RSADigest::<<<<<<Failure: NOT SUPPORT" + type);
                throw new PKIException("can not support this algorithm:" + type);
            }
            this.algId = new AlgorithmIdentifier(oid, (ASN1Encodable)DERNull.INSTANCE);
        }

        final byte[] hashMessage(byte[] message, boolean derFlag) throws PKIException {
            try {
                byte[] hashValue = new byte[this.digest.getDigestSize()];
                if (message != null) {
                    this.digest.update(message, 0, message.length);
                }
                this.digest.doFinal(hashValue, 0);
                if (logger.isDebugEnabled()) {
                    logger.debug("RSADigest::hashMessage<<<<<<RAWHashValue=" + Hex.toHexString(hashValue));
                }
                if (derFlag) {
                    DigestInfo dInfo = new DigestInfo(this.algId, hashValue);
                    hashValue = dInfo.getEncoded("DER");
                    if (logger.isDebugEnabled()) {
                        logger.debug("RSADigest::hashMessage<<<<<<DERHashValue=" + Hex.toHexString(hashValue));
                    }
                }
                return hashValue;
            }
            catch (IOException e) {
                throw new PKIException("RSADigest::hashMessage failure[IO] ", e);
            }
        }

        final byte[] hashFile(String sourceFilePath, boolean derFlag) throws PKIException {
            FileInputStream fis = null;
            try {
                byte[] hashValue = new byte[this.digest.getDigestSize()];
                fis = new FileInputStream(sourceFilePath);
                byte[] buffer = new byte[8096];
                int rLength = 0;
                while ((rLength = fis.read(buffer)) >= 0) {
                    this.digest.update(buffer, 0, rLength);
                }
                this.digest.doFinal(hashValue, 0);
                if (logger.isDebugEnabled()) {
                    logger.debug("RSADigest::hashFile::::::RAWhashValue=" + Hex.toHexString(hashValue));
                }
                if (derFlag) {
                    DigestInfo dInfo = new DigestInfo(this.algId, hashValue);
                    hashValue = dInfo.getEncoded("DER");
                    if (logger.isDebugEnabled()) {
                        logger.debug("RSADigest::hashMessage::::::DERHashValue=" + Hex.toHexString(hashValue));
                    }
                }
                byte[] byArray = hashValue;
                return byArray;
            }
            catch (FileNotFoundException e) {
                throw new PKIException("RSADigest::hashFile failure[FileNotFound] ", e);
            }
            catch (IOException e) {
                throw new PKIException("RSADigest::hashFile failure[IO] ", e);
            }
            catch (Exception e) {
                throw new PKIException("RSADigest::hashFile failure", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

