/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.FileUtil;
import cfca.internal.tool.InitKeyStore;
import cfca.internal.tool.PKCS12;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sm.algorithm.SM2Pfx;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.util.cipher.lib.Session;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;

public class KeyUtil {
    static final Logger logger;

    public static SM2PrivateKey getPrivateKeyFromSM2(String sm2FilePath, String sm2FilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2[File]>>>>>>Running");
            buffer.append("\n sm2FilePath: ");
            buffer.append(Debugger.dump(sm2FilePath));
            logger.debug(buffer.toString());
        }
        try {
            byte[] sm2FileData;
            if (sm2FilePath == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sm2FilePath");
            }
            if (sm2FilePass == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sm2FilePass");
            }
            try {
                sm2FileData = FileUtil.getBytesFromFile(sm2FilePath);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getPrivateKeyFromSM2[File]::::::GetBytesFromFile Finished");
                    buffer.append("\n sm2FileData: ");
                    buffer.append(Debugger.dump(sm2FileData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851421", "\u5bc6\u94a5\u5de5\u5177\u5305\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            SM2PrivateKey key = KeyUtil.getPrivateKeyFromSM2(sm2FileData, sm2FilePass);
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getPrivateKeyFromSM2[File]<<<<<<Finished");
                buffer.append("\n key: ");
                buffer.append(Debugger.dump(key));
                logger.debug(buffer.toString());
            }
            return key;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getPrivateKeyFromSM2[File]<<<<<<Failure");
                buffer.append("\n sm2FilePath: ");
                buffer.append(Debugger.dump(sm2FilePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SM2PrivateKey getPrivateKeyFromSM2(byte[] sm2FileData, String sm2FilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2[Data]>>>>>>Running");
            buffer.append("\n sm2FileData: ");
            buffer.append(Debugger.dump(sm2FileData));
            logger.debug(buffer.toString());
        }
        try {
            if (sm2FileData == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sm2FileData");
            }
            if (sm2FilePass == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: sm2FilePass");
            }
            FilterInputStream in = null;
            try {
                byte[] binarySM2FileData;
                byte[] byArray = binarySM2FileData = ASN1Parser.isBase64Encode(sm2FileData) ? Base64.decode(sm2FileData) : sm2FileData;
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getPrivateKeyFromSM2[Data]::::::Decoding");
                    buffer.append("\n binarySM2FileData: ");
                    buffer.append(Debugger.dump(binarySM2FileData));
                    logger.debug(buffer.toString());
                }
                in = new ASN1InputStream(new ByteArrayInputStream(binarySM2FileData));
                SM2Pfx object = SM2Pfx.getInstance(((ASN1InputStream)in).readObject());
                SM2PrivateKey key = object.getPrivateKey(sm2FilePass);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getPrivateKeyFromSM2[Data]<<<<<<Finished");
                    buffer.append("\n key: ");
                    buffer.append(Debugger.dump(key));
                    logger.debug(buffer.toString());
                }
                SM2PrivateKey sM2PrivateKey = key;
                return sM2PrivateKey;
            }
            catch (Exception e) {
                throw new PKIException("851410", "\u5bc6\u94a5\u5de5\u5177\u5305SM2\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw e;
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromSM2[Data]<<<<<<Failure");
            buffer.append("\n sm2FileData: ");
            buffer.append(Debugger.dump(sm2FileData));
            logger.error(buffer.toString(), e);
            throw e;
        }
    }

    public static PrivateKey getPrivateKeyFromPFX(byte[] pfxFileData, String pfxFilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX[Data]>>>>>>Running");
            buffer.append("\n pfxFileData: ");
            buffer.append(Debugger.dump(pfxFileData));
            logger.debug(buffer.toString());
        }
        try {
            if (pfxFileData == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFileData");
            }
            if (pfxFilePass == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePass");
            }
            try {
                PKCS12 pkcs12 = new PKCS12();
                pkcs12.load(pfxFileData);
                logger.debug("getPrivateKeyFromPFX[Data]::::::Loading Finished");
                pkcs12.decrypt(pfxFilePass.toCharArray());
                logger.debug("getPrivateKeyFromPFX[Data]::::::Decrypt Finished");
                PrivateKey key = pkcs12.getPrivateKey();
                logger.debug("getPrivateKeyFromPFX[Data]<<<<<<Finished");
                return key;
            }
            catch (Exception e) {
                throw new PKIException("851411", "\u5bc6\u94a5\u5de5\u5177\u5305PFX\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getPrivateKeyFromPFX[Data]<<<<<<Failure");
                buffer.append("\n pfxFileData: ");
                buffer.append(Debugger.dump(pfxFileData));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static PrivateKey getPrivateKeyFromPFX(InputStream pfxInputStream, String pfxFilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX[Steam]>>>>>>Running");
            logger.debug(buffer.toString());
        }
        try {
            if (pfxInputStream == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxInputStream");
            }
            if (pfxFilePass == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePass");
            }
            try {
                PKCS12 pkcs12 = new PKCS12();
                pkcs12.load(pfxInputStream);
                logger.debug("getPrivateKeyFromPFX[Steam]::::::Loading Finished");
                pkcs12.decrypt(pfxFilePass.toCharArray());
                logger.debug("getPrivateKeyFromPFX[Steam]::::::Decrypt Finished");
                PrivateKey key = pkcs12.getPrivateKey();
                logger.debug("getPrivateKeyFromPFX[Steam]<<<<<<Finished");
                return key;
            }
            catch (Exception e) {
                throw new PKIException("851411", "\u5bc6\u94a5\u5de5\u5177\u5305PFX\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getPrivateKeyFromPFX[Steam]<<<<<<Failure");
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxFilePath, String pfxFilePass) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromPFX[File]>>>>>>Running");
            buffer.append("\n pfxFilePath: ");
            buffer.append(Debugger.dump(pfxFilePath));
            logger.debug(buffer.toString());
        }
        try {
            byte[] pfxFileData;
            if (pfxFilePath == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePath");
            }
            if (pfxFilePass == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pfxFilePass");
            }
            try {
                pfxFileData = FileUtil.getBytesFromFile(pfxFilePath);
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("getPrivateKeyFromPFX[File]::::::GetBytesFromFile Finished");
                    buffer.append("\n pfxFileData: ");
                    buffer.append(Debugger.dump(pfxFileData));
                    logger.debug(buffer.toString());
                }
            }
            catch (Exception e) {
                throw new PKIException("851421", "\u5bc6\u94a5\u5de5\u5177\u5305\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
            return KeyUtil.getPrivateKeyFromPFX(pfxFileData, pfxFilePass);
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getPrivateKeyFromPFX[File]<<<<<<Failure");
                buffer.append("\n pfxFilePath: ");
                buffer.append(Debugger.dump(pfxFilePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(String jksFilePath, String jksFilePass, String alias) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getPrivateKeyFromJKS[File]>>>>>>Running");
            buffer.append("\n jksFilePath: ");
            buffer.append(Debugger.dump(jksFilePath));
            logger.debug(buffer.toString());
        }
        try {
            if (jksFilePath == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: jksFilePath");
            }
            if (jksFilePass == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: jksFilePass");
            }
            if (alias == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: alias");
            }
            try {
                KeyStore ks = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePass);
                char[] password = jksFilePass.toCharArray();
                return (PrivateKey)ks.getKey(alias, password);
            }
            catch (Exception e) {
                throw new PKIException("851412", "\u5bc6\u94a5\u5de5\u5177\u5305JKS\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getPrivateKeyFromJKS[File]<<<<<<Failure");
                buffer.append("\n jksFilePath: ");
                buffer.append(Debugger.dump(jksFilePath));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static KeyPair generateRSAKeyPair(Mechanism mechanism, int keyLength, Session session) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateRSAKeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n keyLength: " + keyLength);
            buffer.append("\n  session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        if (mechanism == null) {
            logger.error("generateRSAKeyPair<<<<<<Failure, null not allowed for mechanism");
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (session == null) {
            logger.error("generateRSAKeyPair<<<<<<Failure, null not allowed for session");
            throw new IllegalArgumentException("null not allowed for session");
        }
        try {
            KeyPair keypair = session.generateKeyPair(mechanism, keyLength);
            logger.debug("generateRSAKeyPair<<<<<<Finished");
            return keypair;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateRSAKeyPair<<<<<<Failure");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(mechanism));
                buffer.append("\n  session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateRSAKeyPair<<<<<<Failure");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(mechanism));
                buffer.append("\n  session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateSM2KeyPair(Mechanism mechanism, Session session) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateSM2KeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n  session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        if (mechanism == null) {
            logger.error("generateSM2KeyPair<<<<<<Failure, null not allowed for mechanism");
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (session == null) {
            logger.error("generateSM2KeyPair<<<<<<Failure, null not allowed for session");
            throw new IllegalArgumentException("null not allowed for session");
        }
        try {
            KeyPair keyPair = session.generateKeyPair(mechanism, 256);
            logger.debug("generateSM2KeyPair<<<<<<Finished");
            return keyPair;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateSM2KeyPair<<<<<<Failure");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(mechanism));
                buffer.append("\n  session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateSM2KeyPair<<<<<<Failure");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(mechanism));
                buffer.append("\n  session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw new RuntimeException(e);
        }
    }

    public static Key generateKey(Mechanism keyType, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKey>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(keyType));
            buffer.append("\n  session: ");
            buffer.append(Debugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            if (keyType == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: keyType");
            }
            if (session == null) {
                throw new PKIException("851400", "\u5bc6\u94a5\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: session");
            }
            Key key = session.generateKey(keyType);
            logger.debug("generateKey<<<<<<Finished");
            return key;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("generateKey<<<<<<Failure");
                buffer.append("\n mechanism: ");
                buffer.append(Debugger.dump(keyType));
                buffer.append("\n  session: ");
                buffer.append(Debugger.dump(session));
                logger.error(buffer.toString(), e);
            }
            throw e;
        }
    }

    public static SM2PublicKey getSM2PublicKey(byte[] pubX, byte[] pubY) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSM2PublicKey>>>>>>Running");
            buffer.append("\n pubX: ");
            buffer.append(Debugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(Debugger.dump(pubY));
            logger.debug(buffer.toString());
        }
        if (pubX == null || pubY == null) {
            logger.error("getSM2PublicKey<<<<<<Failure, null not allowed for pubX/pubY");
            throw new IllegalArgumentException("null not allowed for pubX/pubY");
        }
        try {
            ECDomainParameters params = SM2Params.sm2DomainParameters;
            ECPoint pubPoint = params.getCurve().createPoint(new BigInteger(1, pubX), new BigInteger(1, pubY)).normalize();
            SM2PublicKey key = new SM2PublicKey(new ECPublicKeyParameters(pubPoint, params));
            logger.debug("getSM2PublicKey<<<<<<Finished");
            return key;
        }
        catch (Exception e) {
            logger.error("getSM2PublicKey<<<<<<Failure", e);
            throw new RuntimeException(e);
        }
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] d, byte[] pubX, byte[] pubY) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSM2PrivateKey>>>>>>Running");
            buffer.append("\n d: hidden");
            buffer.append("\n pubX: ");
            buffer.append(Debugger.dump(pubX));
            buffer.append("\n pubY: ");
            buffer.append(Debugger.dump(pubY));
            logger.debug(buffer.toString());
        }
        if (d == null) {
            logger.error("getSM2PrivateKey<<<<<<Failure, null not allowed for d");
            throw new IllegalArgumentException("null not allowed for d");
        }
        try {
            ECDomainParameters params = SM2Params.sm2DomainParameters;
            BigInteger D = new BigInteger(1, d);
            SM2PublicKey pubKey = null;
            if (pubX != null && pubY != null) {
                pubKey = KeyUtil.getSM2PublicKey(pubX, pubY);
            } else {
                FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
                ECPoint Q = multiplier.multiply(params.getG(), D).normalize();
                pubKey = new SM2PublicKey(new ECPublicKeyParameters(Q, params));
            }
            ECPrivateKeyParameters priv = new ECPrivateKeyParameters(D, params);
            SM2PrivateKey priKey = new SM2PrivateKey(priv);
            if (pubX != null && pubY != null) {
                priKey.setSM2PublicKey(pubKey);
            }
            logger.debug("getSM2PrivateKey<<<<<<Finished");
            return priKey;
        }
        catch (Exception e) {
            logger.error("getSM2PrivateKey<<<<<<Failure", e);
            throw new RuntimeException(e);
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(KeyUtil.class);
    }
}

